/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hc.core5.http.io.entity;

import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import org.apache.hc.core5.http.ContentType;
import org.apache.hc.core5.http.io.entity.PathEntity;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

class TestPathEntity {
    TestPathEntity() {
    }

    @Test
    void testBasics() throws Exception {
        Path tmpPath = Files.createTempFile("testfile", ".txt", new FileAttribute[0]);
        tmpPath.toFile().deleteOnExit();
        try (PathEntity httpEntity = new PathEntity(tmpPath, ContentType.TEXT_PLAIN);){
            Assertions.assertEquals((long)Files.size(tmpPath), (long)httpEntity.getContentLength());
            try (InputStream content = httpEntity.getContent();){
                Assertions.assertNotNull((Object)content);
            }
            Assertions.assertTrue((boolean)httpEntity.isRepeatable());
            Assertions.assertFalse((boolean)httpEntity.isStreaming());
            Assertions.assertTrue((boolean)Files.deleteIfExists(tmpPath), (String)("Failed to delete " + tmpPath));
        }
    }

    @Test
    void testNullConstructor() {
        Assertions.assertThrows(NullPointerException.class, () -> new PathEntity(null, ContentType.TEXT_PLAIN));
    }

    @Test
    void testWriteTo() throws Exception {
        Path tmpPath = Files.createTempFile("testfile", ".txt", new FileAttribute[0]);
        tmpPath.toFile().deleteOnExit();
        try (OutputStream outStream = Files.newOutputStream(tmpPath, new OpenOption[0]);){
            outStream.write(0);
            outStream.write(1);
            outStream.write(2);
            outStream.write(3);
        }
        var3_3 = null;
        try (PathEntity httpEntity = new PathEntity(tmpPath, ContentType.TEXT_PLAIN);){
            ByteArrayOutputStream out = new ByteArrayOutputStream();
            httpEntity.writeTo((OutputStream)out);
            byte[] bytes = out.toByteArray();
            Assertions.assertNotNull((Object)bytes);
            Assertions.assertEquals((long)Files.size(tmpPath), (long)bytes.length);
            for (int i = 0; i < 4; ++i) {
                Assertions.assertEquals((int)i, (int)bytes[i]);
            }
            Assertions.assertTrue((boolean)Files.deleteIfExists(tmpPath), (String)("Failed to delete " + tmpPath));
            Assertions.assertThrows(NullPointerException.class, () -> httpEntity.writeTo(null));
        }
        catch (Throwable throwable) {
            var3_3 = throwable;
            throw throwable;
        }
    }
}

