/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.agents.plan.tools;

import java.lang.reflect.Method;
import java.lang.reflect.Parameter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.apache.flink.agents.api.annotation.ToolParam;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.core.JsonProcessingException;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.databind.ObjectMapper;

public class SchemaUtils {
    public static String generateSchema(Method method) throws JsonProcessingException {
        Parameter[] parameters;
        ObjectMapper mapper = new ObjectMapper();
        HashMap<String, Object> schema = new HashMap<String, Object>();
        schema.put("type", "object");
        HashMap<String, Map<String, Object>> properties = new HashMap<String, Map<String, Object>>();
        ArrayList<String> required = new ArrayList<String>();
        for (Parameter param : parameters = method.getParameters()) {
            String paramName = param.getName();
            String paramDescription = null;
            if (param.isAnnotationPresent(ToolParam.class)) {
                ToolParam toolParam = param.getAnnotation(ToolParam.class);
                if (!Objects.requireNonNull(toolParam).name().isEmpty()) {
                    paramName = toolParam.name();
                }
                if (toolParam.required()) {
                    required.add(paramName);
                }
                if (!toolParam.description().isEmpty()) {
                    paramDescription = toolParam.description();
                }
            }
            Map<String, Object> paramSchema = SchemaUtils.getParamSchema(param);
            paramSchema.put("description", paramDescription);
            properties.put(paramName, paramSchema);
        }
        schema.put("properties", properties);
        if (!required.isEmpty()) {
            schema.put("required", required);
        }
        return mapper.writeValueAsString(schema);
    }

    private static Map<String, Object> getParamSchema(Parameter param) {
        HashMap<String, Object> paramSchema = new HashMap<String, Object>();
        Class<?> paramType = param.getType();
        if (paramType == String.class) {
            paramSchema.put("type", "string");
        } else if (paramType == Integer.TYPE || paramType == Integer.class) {
            paramSchema.put("type", "integer");
        } else if (paramType == Double.TYPE || paramType == Double.class) {
            paramSchema.put("type", "number");
        } else if (paramType == Boolean.TYPE || paramType == Boolean.class) {
            paramSchema.put("type", "boolean");
        } else {
            paramSchema.put("type", "object");
        }
        return paramSchema;
    }
}

