/*
 * Decompiled with CFR 0.152.
 */
package org.odftoolkit.odfdom.dom.element.text;

import org.odftoolkit.odfdom.dom.DefaultElementVisitor;
import org.odftoolkit.odfdom.dom.OdfDocumentNamespace;
import org.odftoolkit.odfdom.dom.attribute.style.StyleNumFormatAttribute;
import org.odftoolkit.odfdom.dom.attribute.style.StyleNumLetterSyncAttribute;
import org.odftoolkit.odfdom.dom.attribute.text.TextFormulaAttribute;
import org.odftoolkit.odfdom.dom.attribute.text.TextNameAttribute;
import org.odftoolkit.odfdom.dom.attribute.text.TextRefNameAttribute;
import org.odftoolkit.odfdom.pkg.ElementVisitor;
import org.odftoolkit.odfdom.pkg.OdfElement;
import org.odftoolkit.odfdom.pkg.OdfFileDom;
import org.odftoolkit.odfdom.pkg.OdfName;

public class TextSequenceElement
extends OdfElement {
    public static final OdfName ELEMENT_NAME = OdfName.newName(OdfDocumentNamespace.TEXT, "sequence");

    public TextSequenceElement(OdfFileDom ownerDoc) {
        super(ownerDoc, ELEMENT_NAME);
    }

    public OdfName getOdfName() {
        return ELEMENT_NAME;
    }

    public String getStyleNumFormatAttribute() {
        StyleNumFormatAttribute attr = (StyleNumFormatAttribute)this.getOdfAttribute(OdfDocumentNamespace.STYLE, "num-format");
        if (attr != null) {
            return String.valueOf(attr.getValue());
        }
        return null;
    }

    public void setStyleNumFormatAttribute(String styleNumFormatValue) {
        StyleNumFormatAttribute attr = new StyleNumFormatAttribute((OdfFileDom)this.ownerDocument);
        this.setOdfAttribute(attr);
        attr.setValue(styleNumFormatValue);
    }

    public Boolean getStyleNumLetterSyncAttribute() {
        StyleNumLetterSyncAttribute attr = (StyleNumLetterSyncAttribute)this.getOdfAttribute(OdfDocumentNamespace.STYLE, "num-letter-sync");
        if (attr != null) {
            return attr.booleanValue();
        }
        return null;
    }

    public void setStyleNumLetterSyncAttribute(Boolean styleNumLetterSyncValue) {
        StyleNumLetterSyncAttribute attr = new StyleNumLetterSyncAttribute((OdfFileDom)this.ownerDocument);
        this.setOdfAttribute(attr);
        attr.setBooleanValue(styleNumLetterSyncValue);
    }

    public String getTextFormulaAttribute() {
        TextFormulaAttribute attr = (TextFormulaAttribute)this.getOdfAttribute(OdfDocumentNamespace.TEXT, "formula");
        if (attr != null) {
            return String.valueOf(attr.getValue());
        }
        return null;
    }

    public void setTextFormulaAttribute(String textFormulaValue) {
        TextFormulaAttribute attr = new TextFormulaAttribute((OdfFileDom)this.ownerDocument);
        this.setOdfAttribute(attr);
        attr.setValue(textFormulaValue);
    }

    public String getTextNameAttribute() {
        TextNameAttribute attr = (TextNameAttribute)this.getOdfAttribute(OdfDocumentNamespace.TEXT, "name");
        if (attr != null) {
            return String.valueOf(attr.getValue());
        }
        return null;
    }

    public void setTextNameAttribute(String textNameValue) {
        TextNameAttribute attr = new TextNameAttribute((OdfFileDom)this.ownerDocument);
        this.setOdfAttribute(attr);
        attr.setValue(textNameValue);
    }

    public String getTextRefNameAttribute() {
        TextRefNameAttribute attr = (TextRefNameAttribute)this.getOdfAttribute(OdfDocumentNamespace.TEXT, "ref-name");
        if (attr != null) {
            return String.valueOf(attr.getValue());
        }
        return null;
    }

    public void setTextRefNameAttribute(String textRefNameValue) {
        TextRefNameAttribute attr = new TextRefNameAttribute((OdfFileDom)this.ownerDocument);
        this.setOdfAttribute(attr);
        attr.setValue(textRefNameValue);
    }

    public void accept(ElementVisitor visitor) {
        if (visitor instanceof DefaultElementVisitor) {
            DefaultElementVisitor defaultVisitor = (DefaultElementVisitor)visitor;
            defaultVisitor.visit(this);
        } else {
            visitor.visit(this);
        }
    }

    public void newTextNode(String content) {
        if (content != null && !content.equals("")) {
            this.appendChild(this.getOwnerDocument().createTextNode(content));
        }
    }
}

