/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derbyTesting.functionTests.tests.jdbcapi;

import java.sql.CallableStatement;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import javax.sql.ConnectionPoolDataSource;
import javax.sql.PooledConnection;
import junit.framework.Test;
import org.apache.derbyTesting.junit.BaseJDBCTestCase;
import org.apache.derbyTesting.junit.BaseJDBCTestSetup;
import org.apache.derbyTesting.junit.BaseTestSuite;
import org.apache.derbyTesting.junit.J2EEDataSource;
import org.apache.derbyTesting.junit.JDBC;
import org.apache.derbyTesting.junit.TestConfiguration;

public class StatementPoolingTest
extends BaseJDBCTestCase {
    private LogicalPooledConnectionFactory lpcf;

    public StatementPoolingTest(String name) {
        super(name);
    }

    @Override
    public void tearDown() throws Exception {
        this.closePooledConnectionFactory();
        super.tearDown();
    }

    private void closePooledConnectionFactory() throws SQLException {
        if (this.lpcf != null) {
            try {
                this.lpcf.close();
            }
            finally {
                this.lpcf = null;
            }
        }
    }

    private Connection getCachingConnection() throws SQLException {
        return this.getCachingConnection(7);
    }

    private Connection getCachingConnection(int cacheSize) throws SQLException {
        if (this.lpcf == null) {
            this.lpcf = new LogicalPooledConnectionFactory();
        }
        return this.lpcf.getConnection(cacheSize);
    }

    public void testCacheOverflow() throws SQLException {
        int stmtCount = 150;
        Connection con = this.getCachingConnection(11);
        for (int i = 0; i < 150; ++i) {
            PreparedStatement pStmt = con.prepareStatement("values " + i);
            ResultSet rs = pStmt.executeQuery();
            JDBC.assertSingleValueResultSet(rs, Integer.toString(i));
            pStmt.close();
        }
        con.close();
    }

    public void testPoolingEnabledByCheckingImplementationDetails() throws SQLException {
        String conClass = "CachingLogicalConnection";
        String psClass = "LogicalPreparedStatement";
        String csClass = "LogicalCallableStatement";
        String dmdClass = "LogicalDatabaseMetaData";
        Connection con = this.getCachingConnection();
        StatementPoolingTest.assertClassName(con, "CachingLogicalConnection");
        StatementPoolingTest.assertClassName(con.prepareStatement("values 1"), "LogicalPreparedStatement");
        StatementPoolingTest.assertClassName(con.prepareStatement("values 1", 1), "LogicalPreparedStatement");
        StatementPoolingTest.assertClassName(con.prepareStatement("values 1", 2), "LogicalPreparedStatement");
        StatementPoolingTest.assertClassName(con.prepareStatement("values 1", 1003, 1007), "LogicalPreparedStatement");
        StatementPoolingTest.assertClassName(con.prepareStatement("values 1", 1004, 1008), "LogicalPreparedStatement");
        StatementPoolingTest.assertClassName(con.prepareStatement("values 1", (String[])null), "LogicalPreparedStatement");
        StatementPoolingTest.assertClassName(con.prepareStatement("values 1", new String[0]), "LogicalPreparedStatement");
        StatementPoolingTest.assertClassName(con.prepareCall("values 1"), "LogicalCallableStatement");
        StatementPoolingTest.assertClassName(con.prepareCall("values 1", 1003, 1007), "LogicalCallableStatement");
        StatementPoolingTest.assertClassName(con.prepareCall("values 1", 1003, 1007, 2), "LogicalCallableStatement");
        StatementPoolingTest.assertClassName(con.getMetaData(), "LogicalDatabaseMetaData");
    }

    private static void assertClassName(Object obj, String expectedName) {
        StatementPoolingTest.assertNotNull((String)"The expected name cannot be <null>", (Object)expectedName);
        StatementPoolingTest.assertNotNull((String)"The object cannot be <null>", (Object)obj);
        String[] names = obj.getClass().getName().split("\\.");
        String simpleName = names[names.length - 1];
        if (JDBC.vmSupportsJDBC4() && !((String)expectedName).endsWith("40")) {
            if (JDBC.vmSupportsJDBC42() && ((String)expectedName).contains("Statement")) {
                expectedName = (String)expectedName + "42";
            } else if (StatementPoolingTest.usingEmbedded()) {
                expectedName = (String)expectedName + "40";
            }
        }
        StatementPoolingTest.assertEquals((String)expectedName, (String)simpleName);
    }

    public void testPrepareStatementPath() throws SQLException {
        PreparedStatement ps = this.prepareStatement("values 9708");
        ps.close();
    }

    public void testPrepareCallPath() throws SQLException {
        CallableStatement cs = this.prepareCall("CALL SYSCS_UTIL.SYSCS_SET_RUNTIMESTATISTICS(0)");
        cs.close();
    }

    public void testPrepareCallWithNoCallPath() throws SQLException {
        CallableStatement cs = this.prepareCall("values 1");
        cs.close();
    }

    public void testClosingPSClosesRS() throws SQLException {
        PreparedStatement ps = this.prepareStatement("values 99");
        ResultSet rs = ps.executeQuery();
        ps.close();
        try {
            rs.next();
            StatementPoolingTest.fail((String)"Result set should have been closed");
        }
        catch (SQLException sqle) {
            StatementPoolingTest.assertSQLState("XCL16", sqle);
        }
    }

    public void testHoldabilityIsResetExplicitClose() throws SQLException {
        this.doTestHoldabilityIsReset(true);
    }

    public void testHoldabilityIsResetNoExplicitClose() throws SQLException {
        this.doTestHoldabilityIsReset(false);
    }

    private void doTestHoldabilityIsReset(boolean closeConnection) throws SQLException {
        Connection con = this.getCachingConnection();
        StatementPoolingTest.assertEquals((String)"Unexpected default holdability", (int)1, (int)con.getHoldability());
        con.setHoldability(2);
        StatementPoolingTest.assertEquals((String)"Holdability not updated", (int)2, (int)con.getHoldability());
        if (closeConnection) {
            con.close();
        }
        con = this.getCachingConnection();
        StatementPoolingTest.assertEquals((String)"Holdability not reset", (int)1, (int)con.getHoldability());
    }

    public void testIsolationLevelIsResetExplicitCloseQuery() throws SQLException {
        this.doTestIsolationLevelIsReset(true, true);
    }

    public void testIsolationLevelIsResetExplicitCloseNoQuery() throws SQLException {
        this.doTestIsolationLevelIsReset(true, false);
    }

    public void testIsolationLevelIsResetNoExplicitCloseNoQuery() throws SQLException {
        this.doTestIsolationLevelIsReset(false, false);
    }

    public void testIsolationLevelIsResetNoExplicitCloseQuery() throws SQLException {
        this.doTestIsolationLevelIsReset(false, true);
    }

    private void doTestIsolationLevelIsReset(boolean closeConnection, boolean executeQuery) throws SQLException {
        Connection con = this.getCachingConnection();
        StatementPoolingTest.assertEquals((String)"Unexpected default isolation level", (int)2, (int)con.getTransactionIsolation());
        con.setTransactionIsolation(4);
        StatementPoolingTest.assertEquals((String)"Isolation level not updated", (int)4, (int)con.getTransactionIsolation());
        if (executeQuery) {
            PreparedStatement ps = con.prepareStatement("values 2");
            JDBC.assertSingleValueResultSet(ps.executeQuery(), "2");
            ps.close();
        }
        if (closeConnection) {
            con.close();
        }
        con = this.getCachingConnection();
        StatementPoolingTest.assertEquals((String)"Isolation level not reset", (int)2, (int)con.getTransactionIsolation());
    }

    public void testCachingLogicalConnectionCloseLeavesPhysicalStatementsOpen() throws SQLException {
        String SELECT_SQL = "select * from clcclso";
        Connection con = this.getCachingConnection();
        con.setAutoCommit(false);
        Statement stmt = this.createStatement();
        stmt.executeUpdate("create table clcclso (id int)");
        PreparedStatement ps = con.prepareStatement("select * from clcclso");
        con.commit();
        con.close();
        try {
            ps.execute();
            StatementPoolingTest.fail((String)"Logical connection close did not close logical statement.");
        }
        catch (SQLException sqle) {
            StatementPoolingTest.assertSQLState("XJ012", sqle);
        }
        stmt = this.createStatement();
        stmt.executeUpdate("drop table clcclso");
        this.commit();
        con = this.getCachingConnection();
        ps = con.prepareStatement("select * from clcclso");
        try {
            ps.execute();
            StatementPoolingTest.fail((String)"Execution should have failed");
        }
        catch (SQLException sqle) {
            StatementPoolingTest.assertSQLState("42X05", sqle);
        }
        ps.close();
        ps = con.prepareStatement("values 976");
        JDBC.assertSingleValueResultSet(ps.executeQuery(), "976");
        ps.close();
        con.close();
    }

    public void resTestCloseDoesNotAffectOtherStatement() throws SQLException {
        String sql = "select * from stmtpooltest where val > 0 and val <= 7 order by val";
        PreparedStatement psForward = this.prepareStatement("select * from stmtpooltest where val > 0 and val <= 7 order by val");
        ResultSet rsForward = psForward.executeQuery();
        StatementPoolingTest.assertTrue((boolean)rsForward.next());
        StatementPoolingTest.assertEquals((String)"1", (String)rsForward.getString(1));
        StatementPoolingTest.assertTrue((boolean)rsForward.next());
        StatementPoolingTest.assertEquals((String)"2", (String)rsForward.getString(1));
        PreparedStatement psScrollable = this.prepareStatement("select * from stmtpooltest where val > 0 and val <= 7 order by val", 1004, 1007);
        ResultSet rsScrollable = psScrollable.executeQuery();
        for (int val = 1; val <= 7; ++val) {
            StatementPoolingTest.assertTrue((boolean)rsScrollable.next());
            StatementPoolingTest.assertEquals((int)val, (int)rsScrollable.getInt(1));
        }
        PreparedStatement psToClose = this.prepareStatement("select val from stmtpooltest where val = 5");
        JDBC.assertSingleValueResultSet(psToClose.executeQuery(), "5");
        psToClose.close();
        StatementPoolingTest.assertTrue((boolean)rsForward.next());
        StatementPoolingTest.assertEquals((String)"3", (String)rsForward.getString(1));
        StatementPoolingTest.assertTrue((boolean)rsScrollable.first());
        StatementPoolingTest.assertEquals((String)"1", (String)rsScrollable.getString(1));
        psToClose = this.prepareStatement("select val from stmtpooltest where val = 5");
        JDBC.assertSingleValueResultSet(psToClose.executeQuery(), "5");
        psToClose.close();
        StatementPoolingTest.assertTrue((boolean)rsScrollable.last());
        StatementPoolingTest.assertEquals((String)"7", (String)rsScrollable.getString(1));
        StatementPoolingTest.assertFalse((boolean)rsScrollable.next());
        rsScrollable.close();
        StatementPoolingTest.assertTrue((boolean)rsForward.next());
        StatementPoolingTest.assertEquals((String)"4", (String)rsForward.getString(1));
        rsForward.close();
    }

    public void testDeleteReferringTableWhenOpen() throws SQLException {
        this.getConnection().setAutoCommit(false);
        Statement stmt = this.createStatement();
        stmt.executeUpdate("create table testdeletewhenopen (id int)");
        stmt.executeUpdate("insert into testdeletewhenopen values 1");
        PreparedStatement ps = this.prepareStatement("select * from testdeletewhenopen");
        JDBC.assertSingleValueResultSet(ps.executeQuery(), "1");
        stmt.executeUpdate("drop table testdeletewhenopen");
        stmt.close();
        ps.close();
        ps = this.prepareStatement("select * from testdeletewhenopen");
        try {
            ps.executeQuery();
            StatementPoolingTest.fail((String)"Prepared statement not valid, referring non-existing table");
        }
        catch (SQLException sqle) {
            StatementPoolingTest.assertSQLState("42X05", sqle);
        }
    }

    public void testDeleteReferringTableWhenInCache() throws SQLException {
        this.getConnection().setAutoCommit(false);
        Statement stmt = this.createStatement();
        stmt.executeUpdate("create table testdeletewhenopen (id int)");
        stmt.executeUpdate("insert into testdeletewhenopen values 1");
        PreparedStatement ps = this.prepareStatement("select * from testdeletewhenopen");
        JDBC.assertSingleValueResultSet(ps.executeQuery(), "1");
        ps.close();
        stmt.executeUpdate("drop table testdeletewhenopen");
        stmt.close();
        ps = this.prepareStatement("select * from testdeletewhenopen");
        try {
            ps.executeQuery();
            StatementPoolingTest.fail((String)"Prepared statement not valid, referring non-existing table");
        }
        catch (SQLException sqle) {
            StatementPoolingTest.assertSQLState("42X05", sqle);
        }
    }

    public void resTestCloseCursorsAtCommit() throws SQLException {
        this.doTestResultSetCloseForHoldability(2);
    }

    public void resTestHoldCursorsOverCommit() throws SQLException {
        this.doTestResultSetCloseForHoldability(1);
    }

    public void testTemporaryTablesAreDeletedInNewLogicalConnection() throws SQLException {
        Connection lcOne = this.getCachingConnection();
        Statement stmt = lcOne.createStatement();
        stmt.executeUpdate("DECLARE GLOBAL TEMPORARY TABLE cpds_temp_table (id int) ON COMMIT PRESERVE ROWS NOT LOGGED");
        JDBC.assertEmpty(stmt.executeQuery("select * from SESSION.cpds_temp_table"));
        stmt.executeUpdate("insert into SESSION.cpds_temp_table values 1");
        lcOne.commit();
        lcOne.close();
        Connection lcTwo = this.getCachingConnection();
        stmt = lcTwo.createStatement();
        try {
            stmt.executeQuery("select * from SESSION.cpds_temp_table");
            StatementPoolingTest.fail((String)"Temporary table still existing in new logical connection.");
        }
        catch (SQLException sqle) {
            StatementPoolingTest.assertSQLState("42X05", sqle);
        }
        lcTwo.rollback();
        lcTwo.close();
    }

    private void doTestResultSetCloseForHoldability(int holdability) throws SQLException {
        this.getConnection().setAutoCommit(false);
        PreparedStatement ps = this.prepareStatement("select * from stmtpooltest order by val", 1003, 1007, holdability);
        ResultSet rs = ps.executeQuery();
        StatementPoolingTest.assertTrue((boolean)rs.next());
        StatementPoolingTest.assertEquals((int)1, (int)rs.getInt(1));
        this.commit();
        if (holdability == 1) {
            StatementPoolingTest.assertTrue((boolean)rs.next());
            StatementPoolingTest.assertEquals((int)2, (int)rs.getInt(1));
            this.rollback();
        }
        this.getConnection().close();
        try {
            rs.next();
            StatementPoolingTest.fail((String)"Should have thrown exception");
        }
        catch (SQLException sqle) {
            StatementPoolingTest.assertSQLState("XCL16", sqle);
        }
    }

    public void testGetStatementCallable() throws SQLException {
        this.doTestGetStatement(this.prepareCall("values 7653"));
    }

    public void testGetStatementPrepared() throws SQLException {
        this.doTestGetStatement(this.prepareStatement("values 7652"));
    }

    private void doTestGetStatement(PreparedStatement ps) throws SQLException {
        ResultSet psRs = ps.executeQuery();
        StatementPoolingTest.assertSame((Object)ps, (Object)psRs.getStatement());
        psRs.close();
        ps.execute();
        psRs = ps.getResultSet();
        StatementPoolingTest.assertSame((Object)ps, (Object)psRs.getStatement());
        StatementPoolingTest.assertFalse((boolean)ps.getMoreResults());
        StatementPoolingTest.assertNull((Object)ps.getResultSet());
        try {
            psRs = ps.executeQuery("values 99");
            StatementPoolingTest.fail((String)"executeQuery(String) should be disallowed");
        }
        catch (SQLException sqle) {
            StatementPoolingTest.assertSQLState("XJ016", sqle);
        }
    }

    public void resTestLogicalConnectionCloseInvalidatesLogicalStatement() throws SQLException {
        Connection con = this.getConnection();
        PreparedStatement ps = con.prepareStatement("select * from stmtpooltest");
        StatementPoolingTest.assertNotNull((Object)ps.getMetaData());
        con.close();
        try {
            ps.getMetaData();
            StatementPoolingTest.fail((String)"Logical statement should be closed and throw exception");
        }
        catch (SQLException sqle) {
            StatementPoolingTest.assertSQLState("XJ012", sqle);
        }
        con = this.getConnection();
        ps = con.prepareStatement("select * from stmtpooltest order by val");
        ResultSet rs = ps.executeQuery();
        StatementPoolingTest.assertTrue((boolean)rs.next());
        StatementPoolingTest.assertNotNull((Object)ps.getMetaData());
        rs.close();
        con.close();
        try {
            ps.getMetaData();
            StatementPoolingTest.fail((String)"Logical statement should be closed and throw exception");
        }
        catch (SQLException sqle) {
            StatementPoolingTest.assertSQLState("XJ012", sqle);
        }
    }

    public void resTestNoCommitOnReuse() throws SQLException {
        this.cleanTableExceptedToBeEmpty();
        String sql = "insert into stmtpooldata (val) values ?";
        this.getConnection().setAutoCommit(false);
        PreparedStatement ps = this.prepareStatement("insert into stmtpooldata (val) values ?");
        ps.setInt(1, 68);
        StatementPoolingTest.assertEquals((int)1, (int)ps.executeUpdate());
        ps.close();
        ps = this.prepareStatement("insert into stmtpooldata (val) values ?");
        ps.setInt(1, 77);
        StatementPoolingTest.assertEquals((int)1, (int)ps.executeUpdate());
        Statement stmt = this.createStatement();
        ResultSet rs = stmt.executeQuery("select val from stmtpooldata order by val");
        JDBC.assertFullResultSet(rs, new String[][]{{"68"}, {"77"}});
        this.rollback();
        rs = stmt.executeQuery("select val from stmtpooldata order by val");
        JDBC.assertEmpty(rs);
    }

    public void resTestCommitOnReuse() throws SQLException {
        this.cleanTableExceptedToBeEmpty();
        String sql = "insert into stmtpooldata (val) values ?";
        this.getConnection().setAutoCommit(true);
        PreparedStatement ps = this.prepareStatement("insert into stmtpooldata (val) values ?");
        ps.setInt(1, 68);
        StatementPoolingTest.assertEquals((int)1, (int)ps.executeUpdate());
        ps.close();
        ps = this.prepareStatement("insert into stmtpooldata (val) values ?");
        ps.setInt(1, 77);
        StatementPoolingTest.assertEquals((int)1, (int)ps.executeUpdate());
        Statement stmt = this.createStatement();
        ResultSet rs = stmt.executeQuery("select val from stmtpooldata order by val");
        JDBC.assertFullResultSet(rs, new String[][]{{"68"}, {"77"}});
        this.rollback();
        rs = stmt.executeQuery("select val from stmtpooldata order by val");
        JDBC.assertFullResultSet(rs, new String[][]{{"68"}, {"77"}});
        StatementPoolingTest.assertEquals((int)2, (int)stmt.executeUpdate("delete from stmtpooldata"));
    }

    public void resTestNoDataCommittedOnInvalidTransactionState() throws SQLException {
        this.cleanTableExceptedToBeEmpty();
        String sql = "insert into stmtpooldata (val) values ?";
        this.getConnection().setAutoCommit(false);
        PreparedStatement ps = this.prepareStatement("insert into stmtpooldata (val) values ?");
        ps.setInt(1, 68);
        StatementPoolingTest.assertEquals((int)1, (int)ps.executeUpdate());
        ps.close();
        ps = this.prepareStatement("insert into stmtpooldata (val) values ?");
        ps.setInt(1, 77);
        StatementPoolingTest.assertEquals((int)1, (int)ps.executeUpdate());
        Statement stmt = this.createStatement();
        ResultSet rs = stmt.executeQuery("select val from stmtpooldata order by val");
        JDBC.assertFullResultSet(rs, new String[][]{{"68"}, {"77"}});
        try {
            this.getConnection().close();
            stmt = this.createStatement();
            rs = stmt.executeQuery("select val from stmtpooldata order by val");
            int rows = 0;
            while (rs.next()) {
                ++rows;
            }
            StatementPoolingTest.fail((String)("Connection should not be allowed to close. Rows in table: " + rows));
        }
        catch (SQLException sqle) {
            StatementPoolingTest.assertSQLState("25001", sqle);
            this.rollback();
        }
        stmt = this.createStatement();
        rs = stmt.executeQuery("select val from stmtpooldata order by val");
        JDBC.assertEmpty(rs);
    }

    private void cleanTableExceptedToBeEmpty() throws SQLException {
        Statement stmt = this.createStatement();
        ResultSet rs = stmt.executeQuery("select * from stmtpooldata");
        int rowCount = 0;
        while (rs.next()) {
            ++rowCount;
        }
        rs.close();
        if (rowCount > 0) {
            StatementPoolingTest.println("Expected empty table, got " + rowCount + " rows.");
            StatementPoolingTest.assertEquals((int)rowCount, (int)stmt.executeUpdate("delete from stmtpooldata"));
        }
    }

    public static Test suite() {
        BaseTestSuite suite = new BaseTestSuite("StatementPoolingTest suite");
        BaseTestSuite baseSuite = new BaseTestSuite(StatementPoolingTest.class);
        suite.addTest(TestConfiguration.connectionCPDecorator((Test)baseSuite));
        BaseTestSuite reqDataSuite = new BaseTestSuite("Requires data suite");
        reqDataSuite.addTest((Test)new StatementPoolingTest("resTestCloseDoesNotAffectOtherStatement"));
        reqDataSuite.addTest((Test)new StatementPoolingTest("resTestLogicalConnectionCloseInvalidatesLogicalStatement"));
        reqDataSuite.addTest((Test)new StatementPoolingTest("resTestHoldCursorsOverCommit"));
        reqDataSuite.addTest((Test)new StatementPoolingTest("resTestCloseCursorsAtCommit"));
        reqDataSuite.addTest((Test)new StatementPoolingTest("resTestNoCommitOnReuse"));
        reqDataSuite.addTest((Test)new StatementPoolingTest("resTestCommitOnReuse"));
        reqDataSuite.addTest((Test)new StatementPoolingTest("resTestNoDataCommittedOnInvalidTransactionState"));
        suite.addTest(TestConfiguration.connectionCPDecorator((Test)new BaseJDBCTestSetup((Test)reqDataSuite){

            public void setUp() throws Exception {
                Statement stmt = this.getConnection().createStatement();
                try {
                    stmt.executeUpdate("drop table stmtpooltest");
                }
                catch (SQLException sqle) {
                    BaseJDBCTestCase.assertSQLState("42Y55", sqle);
                }
                stmt.executeUpdate("create table stmtpooltest (id int generated always as identity,val int)");
                PreparedStatement ps = this.getConnection().prepareStatement("insert into stmtpooltest values (DEFAULT, ?)");
                for (int val = 1; val <= 7; ++val) {
                    ps.setInt(1, val);
                    ps.addBatch();
                }
                ps.executeBatch();
                try {
                    stmt.executeUpdate("drop table stmtpooldata");
                }
                catch (SQLException sqle) {
                    BaseJDBCTestCase.assertSQLState("42Y55", sqle);
                }
                stmt.executeUpdate("create table stmtpooldata (id int generated always as identity,val int)");
            }
        }));
        return TestConfiguration.clientServerDecorator((Test)suite);
    }

    private static class LogicalPooledConnectionFactory {
        private int curCacheSize;
        private PooledConnection pooledConnection;

        private LogicalPooledConnectionFactory() {
        }

        public Connection getConnection(int cacheSize) throws SQLException {
            if (this.pooledConnection == null || this.curCacheSize != cacheSize) {
                this.close();
                ConnectionPoolDataSource cpDs = J2EEDataSource.getConnectionPoolDataSource();
                J2EEDataSource.setBeanProperty(cpDs, "maxStatements", cacheSize);
                J2EEDataSource.setBeanProperty(cpDs, "createDatabase", "create");
                this.pooledConnection = cpDs.getPooledConnection();
                this.curCacheSize = cacheSize;
            }
            return this.pooledConnection.getConnection();
        }

        public void close() throws SQLException {
            if (this.pooledConnection != null) {
                try {
                    this.pooledConnection.close();
                }
                finally {
                    this.pooledConnection = null;
                    this.curCacheSize = -1;
                }
            }
        }
    }
}

