/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derbyTesting.perf.basic.jdbc;

import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import junit.framework.Test;
import org.apache.derbyTesting.junit.BaseTestSuite;
import org.apache.derbyTesting.junit.JDBCPerfTestCase;
import org.apache.derbyTesting.junit.TestConfiguration;

public class ValuesTest
extends JDBCPerfTestCase {
    private PreparedStatement ps;

    public static Test suite() {
        int n = 100000;
        int n2 = 4;
        BaseTestSuite baseTestSuite = new BaseTestSuite("ValuesTest");
        baseTestSuite.addTest((Test)new ValuesTest("fetchByColumnName", n, n2));
        baseTestSuite.addTest((Test)new ValuesTest("fetchByColumnNumber", n, n2));
        BaseTestSuite baseTestSuite2 = new BaseTestSuite("Client_ValuesTest");
        baseTestSuite2.addTest((Test)new ValuesTest("fetchByColumnName", n, n2));
        baseTestSuite2.addTest((Test)new ValuesTest("fetchByColumnNumber", n, n2));
        baseTestSuite.addTest(TestConfiguration.clientServerDecorator((Test)baseTestSuite2));
        return baseTestSuite;
    }

    public ValuesTest(String string, int n, int n2) {
        super(string, n, n2);
    }

    public ValuesTest(String string) {
        super(string);
    }

    public void setUp() throws SQLException {
        ValuesTest.println("Setup()::ValuesTest");
        this.ps = this.openDefaultConnection().prepareStatement("SELECT * FROM TABLE(VALUES (1,1,1), (2,2,2), (3,3,3), (4,4,4), (5,5,5)) AS T(\"cOlumN1\", COLUMN2, \"column3\")", 1003, 1007, 2);
    }

    public void fetchByColumnName() throws SQLException {
        ResultSet resultSet = this.ps.executeQuery();
        while (resultSet.next()) {
            resultSet.getInt("column1");
            resultSet.getInt("COLUMN2");
            resultSet.getInt("column3");
        }
        resultSet.close();
    }

    public void fetchByColumnNumber() throws SQLException {
        ResultSet resultSet = this.ps.executeQuery();
        while (resultSet.next()) {
            resultSet.getInt(1);
            resultSet.getInt(2);
            resultSet.getInt(3);
        }
        resultSet.close();
    }

    @Override
    public void tearDown() throws Exception {
        ValuesTest.println("ValuesTest::tearDown");
        this.ps.close();
        this.ps = null;
        super.tearDown();
    }
}

