/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derbyTesting.functionTests.tests.jdbc4;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.StringReader;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import junit.framework.Test;
import org.apache.derbyTesting.functionTests.tests.jdbcapi.Derby2017LayerATest;
import org.apache.derbyTesting.functionTests.util.streams.LoopingAlphabetReader;
import org.apache.derbyTesting.junit.BaseJDBCTestCase;
import org.apache.derbyTesting.junit.JDBC;
import org.apache.derbyTesting.junit.TestConfiguration;

public class Derby2017LayerBTest
extends BaseJDBCTestCase {
    public Derby2017LayerBTest(String string) {
        super(string);
    }

    public static Test suite() {
        return TestConfiguration.defaultSuite(Derby2017LayerBTest.class);
    }

    public void testStreamInsertCharBufferBoundary() throws IOException, SQLException {
        int[] nArray = new int[]{1, 16383, 0, 32756, 36383, 16384, 196608};
        this.rollback();
        Statement statement = this.createStatement();
        try {
            statement.executeUpdate("create table t2017_len (len int, c clob)");
        }
        catch (SQLException sQLException) {
            Derby2017LayerBTest.assertSQLState("X0Y32", sQLException);
            statement.executeUpdate("delete from t2017_len");
        }
        this.commit();
        this.setAutoCommit(false);
        PreparedStatement preparedStatement = this.prepareStatement("insert into t2017_len values (?,?)");
        for (int n : nArray) {
            preparedStatement.setInt(1, n);
            preparedStatement.setCharacterStream(2, new LoopingAlphabetReader(n));
            preparedStatement.executeUpdate();
        }
        Object object = statement.executeQuery("select len, c from t2017_len");
        int n = 0;
        while (object.next()) {
            ++n;
            int n2 = object.getInt(1);
            Derby2017LayerBTest.assertEquals(new LoopingAlphabetReader(n2), object.getCharacterStream(2));
        }
        Derby2017LayerBTest.assertEquals((int)nArray.length, (int)n);
    }

    public void testFailedStreamInsertCharBufferBoundariesImpl() throws IOException, SQLException {
        int[] nArray = new int[]{1, 16383, 0, 32756, 36383, 16384, 196608};
        this.rollback();
        Statement statement = this.createStatement();
        try {
            statement.executeUpdate("create table t2017_len (len int, c clob)");
        }
        catch (SQLException sQLException) {
            Derby2017LayerBTest.assertSQLState("X0Y32", sQLException);
            statement.executeUpdate("delete from t2017_len");
        }
        this.commit();
        this.setAutoCommit(false);
        PreparedStatement preparedStatement = this.prepareStatement("insert into t2017_len values (?,?)");
        for (int n : nArray) {
            preparedStatement.setInt(1, n);
            preparedStatement.setCharacterStream(2, new Derby2017LayerATest.FailingReader(n, -1L));
            try {
                preparedStatement.executeUpdate();
                Derby2017LayerBTest.fail((String)("Should have failed (length=" + n + ")"));
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
        }
        for (int n : nArray) {
            preparedStatement.setInt(1, n);
            preparedStatement.setCharacterStream(2, new Derby2017LayerATest.FailingReader(n, n / 2));
            try {
                preparedStatement.executeUpdate();
                Derby2017LayerBTest.fail((String)("Should have failed (length=" + n + ")"));
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
        }
        for (int n : nArray) {
            preparedStatement.setInt(1, n);
            preparedStatement.setCharacterStream(2, new Derby2017LayerATest.FailingReader(n, n - 1));
            try {
                preparedStatement.executeUpdate();
                Derby2017LayerBTest.fail((String)("Should have failed (length=" + n + ")"));
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
        }
        Object object = statement.executeQuery("select count(*) from t2017_len");
        object.next();
        Derby2017LayerBTest.assertEquals((int)0, (int)object.getInt(1));
    }

    public void testFailedStreamInsertChar() throws IOException, SQLException {
        String[] stringArray = new String[]{"This is row 1", "This is row 2", "This is row 3", "This is row 4, a bit too long", "This is row 5, a bit too short", "This is row 6", "This is row 7"};
        String[][] stringArray2 = new String[][]{{"This is row 1"}, {"This is row 2"}, {"This is row 3"}, {"This is row 6"}, {"This is row 7"}};
        this.doInsertTest(stringArray, stringArray2, false, false);
    }

    public void testFailedStreamInsertCharAutoCommit() throws IOException, SQLException {
        String[] stringArray = new String[]{"This is row 1", "This is row 2", "This is row 3", "This is row 4, a bit too long", "This is row 5, a bit too short", "This is row 6", "This is row 7"};
        String[][] stringArray2 = new String[][]{{"This is row 1"}, {"This is row 2"}, {"This is row 3"}, {"This is row 6"}, {"This is row 7"}};
        this.doInsertTest(stringArray, stringArray2, true, false);
    }

    public void testFailedStreamInsertCharRollbackOnError() throws IOException, SQLException {
        String[] stringArray = new String[]{"This is row 1", "This is row 2", "This is row 3", "This is row 4, a bit too long", "This is row 5, a bit too short", "This is row 6", "This is row 7"};
        String[][] stringArray2 = new String[][]{{"This is row 6"}, {"This is row 7"}};
        this.doInsertTest(stringArray, stringArray2, false, true);
    }

    public void testFailedStreamInsertCharAutoCommitRollbackOnError() throws IOException, SQLException {
        String[] stringArray = new String[]{"This is row 1", "This is row 2", "This is row 3", "This is row 4, a bit too long", "This is row 5, a bit too short", "This is row 6", "This is row 7"};
        String[][] stringArray2 = new String[][]{{"This is row 1"}, {"This is row 2"}, {"This is row 3"}, {"This is row 6"}, {"This is row 7"}};
        this.doInsertTest(stringArray, stringArray2, true, true);
    }

    public void testFailedStreamInsertBinary() throws IOException, SQLException {
        byte[][] byArray = Derby2017LayerATest.generateDefaultInsert();
        String[][] stringArray = Derby2017LayerATest.generateMaster(byArray, new int[]{3, 4});
        this.doInsertTest(byArray, stringArray, false, false);
    }

    public void testFailedStreamInsertBinaryAutoCommit() throws IOException, SQLException {
        byte[][] byArray = Derby2017LayerATest.generateDefaultInsert();
        String[][] stringArray = Derby2017LayerATest.generateMaster(byArray, new int[]{3, 4});
        this.doInsertTest(byArray, stringArray, true, false);
    }

    public void testFailedStreamInsertBinaryRollbackOnError() throws IOException, SQLException {
        byte[][] byArray = Derby2017LayerATest.generateDefaultInsert();
        String[][] stringArray = Derby2017LayerATest.generateMaster(byArray, new int[]{0, 1, 2, 3, 4});
        this.doInsertTest(byArray, stringArray, false, true);
    }

    public void testFailedStreamInsertBinaryAutoCommitRollbackOnError() throws IOException, SQLException {
        byte[][] byArray = Derby2017LayerATest.generateDefaultInsert();
        String[][] stringArray = Derby2017LayerATest.generateMaster(byArray, new int[]{3, 4});
        this.doInsertTest(byArray, stringArray, true, true);
    }

    private void doInsertTest(String[] stringArray, String[][] stringArray2, boolean bl, boolean bl2) throws IOException, SQLException {
        PreparedStatement preparedStatement;
        Statement statement;
        block10: {
            block9: {
                Derby2017LayerBTest.assertEquals((String)"Expects 7 rows", (int)7, (int)stringArray.length);
                Derby2017LayerBTest.assertTrue((stringArray2.length < stringArray.length ? 1 : 0) != 0);
                this.rollback();
                statement = this.createStatement();
                try {
                    statement.executeUpdate("create table t2017 (c clob)");
                }
                catch (SQLException sQLException) {
                    Derby2017LayerBTest.assertSQLState("X0Y32", sQLException);
                    statement.executeUpdate("delete from t2017");
                }
                this.commit();
                this.setAutoCommit(bl);
                preparedStatement = this.prepareStatement("insert into t2017 values (?)");
                for (int i = 0; i < 3; ++i) {
                    preparedStatement.setCharacterStream(1, new StringReader(stringArray[i]));
                    Derby2017LayerBTest.assertEquals((int)1, (int)preparedStatement.executeUpdate());
                }
                Derby2017LayerATest.FailingReader failingReader = new Derby2017LayerATest.FailingReader(10L, 3L);
                preparedStatement.setCharacterStream(1, failingReader);
                try {
                    preparedStatement.executeUpdate();
                    Derby2017LayerBTest.fail((String)"Insert should have failed");
                }
                catch (SQLException sQLException) {
                    if (!bl2) break block9;
                    this.rollback();
                }
            }
            Derby2017LayerATest.FailingReader failingReader = new Derby2017LayerATest.FailingReader(35002L, 35001L);
            preparedStatement.setCharacterStream(1, failingReader);
            try {
                preparedStatement.executeUpdate();
                Derby2017LayerBTest.fail((String)"Insert should have failed");
            }
            catch (SQLException sQLException) {
                if (!bl2) break block10;
                this.rollback();
            }
        }
        for (int i = 5; i < stringArray.length; ++i) {
            preparedStatement.setCharacterStream(1, new StringReader(stringArray[i]));
            Derby2017LayerBTest.assertEquals((int)1, (int)preparedStatement.executeUpdate());
        }
        if (!bl) {
            this.commit();
        }
        ResultSet resultSet = statement.executeQuery("select * from t2017");
        JDBC.assertUnorderedResultSet(resultSet, stringArray2);
    }

    private void doInsertTest(byte[][] byArray, String[][] stringArray, boolean bl, boolean bl2) throws IOException, SQLException {
        PreparedStatement preparedStatement;
        Statement statement;
        block10: {
            block9: {
                Derby2017LayerBTest.assertEquals((String)"Expects 7 rows", (int)7, (int)byArray.length);
                Derby2017LayerBTest.assertTrue((stringArray.length < byArray.length ? 1 : 0) != 0);
                this.rollback();
                statement = this.createStatement();
                try {
                    statement.executeUpdate("create table t2017_binary (b blob)");
                }
                catch (SQLException sQLException) {
                    Derby2017LayerBTest.assertSQLState("X0Y32", sQLException);
                    statement.executeUpdate("delete from t2017_binary");
                }
                this.commit();
                this.setAutoCommit(bl);
                preparedStatement = this.prepareStatement("insert into t2017_binary values (?)");
                for (int i = 0; i < 3; ++i) {
                    preparedStatement.setBinaryStream(1, new ByteArrayInputStream(byArray[i]));
                    Derby2017LayerBTest.assertEquals((int)1, (int)preparedStatement.executeUpdate());
                }
                FailingInputStream failingInputStream = new FailingInputStream(new Derby2017LayerATest.FailingReader(10L, 3L));
                preparedStatement.setBinaryStream(1, failingInputStream);
                try {
                    preparedStatement.executeUpdate();
                    Derby2017LayerBTest.fail((String)"Insert should have failed");
                }
                catch (SQLException sQLException) {
                    if (!bl2) break block9;
                    this.rollback();
                }
            }
            FailingInputStream failingInputStream = new FailingInputStream(new Derby2017LayerATest.FailingReader(35002L, 35001L));
            preparedStatement.setBinaryStream(1, failingInputStream);
            try {
                preparedStatement.executeUpdate();
                Derby2017LayerBTest.fail((String)"Insert should have failed");
            }
            catch (SQLException sQLException) {
                if (!bl2) break block10;
                this.rollback();
            }
        }
        for (int i = 5; i < byArray.length; ++i) {
            preparedStatement.setBinaryStream(1, new ByteArrayInputStream(byArray[i]));
            Derby2017LayerBTest.assertEquals((int)1, (int)preparedStatement.executeUpdate());
        }
        if (!bl) {
            this.commit();
        }
        ResultSet resultSet = statement.executeQuery("select * from t2017_binary");
        JDBC.assertUnorderedResultSet(resultSet, stringArray);
    }

    private static class FailingInputStream
    extends InputStream {
        private final Derby2017LayerATest.FailingReader in;

        public FailingInputStream(Derby2017LayerATest.FailingReader failingReader) {
            this.in = failingReader;
        }

        @Override
        public int read() throws IOException {
            int n = this.in.read();
            return (byte)n;
        }
    }
}

