/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derbyTesting.functionTests.tests.memory;

import java.sql.Connection;
import java.sql.SQLException;
import java.sql.Statement;
import javax.sql.XAConnection;
import javax.sql.XADataSource;
import javax.transaction.xa.XAResource;
import javax.transaction.xa.Xid;
import junit.framework.Test;
import org.apache.derbyTesting.junit.BaseJDBCTestCase;
import org.apache.derbyTesting.junit.BaseTestSuite;
import org.apache.derbyTesting.junit.J2EEDataSource;
import org.apache.derbyTesting.junit.JDBC;
import org.apache.derbyTesting.junit.TestConfiguration;
import org.apache.derbyTesting.junit.XATestUtil;

public class XAMemTest
extends BaseJDBCTestCase {
    public XAMemTest(String name) {
        super(name);
    }

    public void setUp() throws SQLException {
        this.getConnection();
    }

    public void testDerby4137_TransactionTimeoutSpecifiedNotExceeded() throws Exception {
        XADataSource xads = J2EEDataSource.getXADataSource();
        XAConnection xac = xads.getXAConnection();
        XAResource xar = xac.getXAResource();
        Xid xid = XATestUtil.getXid(8, 9, 10);
        Connection con = xac.getConnection();
        Statement stmt = con.createStatement();
        xar.setTransactionTimeout(100000);
        for (int i = 0; i < 60000; ++i) {
            xar.start(xid, 0);
            stmt.executeQuery("values 1");
            xar.end(xid, 0x4000000);
            xar.commit(xid, true);
        }
        xac.close();
    }

    public static Test suite() {
        if (JDBC.vmSupportsJDBC3()) {
            return TestConfiguration.defaultSuite(XAMemTest.class);
        }
        return new BaseTestSuite("XAMemTest skipped - XADataSource not available");
    }
}

