/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derbyTesting.functionTests.tests.largedata;

import java.io.InputStream;
import java.io.Reader;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.Statement;
import junit.framework.Test;
import org.apache.derbyTesting.functionTests.tests.tools.ImportExportBaseTest;
import org.apache.derbyTesting.functionTests.util.streams.LoopingAlphabetReader;
import org.apache.derbyTesting.functionTests.util.streams.LoopingAlphabetStream;
import org.apache.derbyTesting.junit.BaseTestSuite;
import org.apache.derbyTesting.junit.CleanDatabaseTestSetup;
import org.apache.derbyTesting.junit.SupportFilesSetup;

public class Derby6884Test
extends ImportExportBaseTest {
    String fileName6884 = SupportFilesSetup.getReadWrite("table-data").getPath();
    String lobFile6884 = SupportFilesSetup.getReadWrite("lob-data").getPath();

    public Derby6884Test(String name) {
        super(name);
    }

    public static Test suite() {
        BaseTestSuite suite = new BaseTestSuite("Derby6884Test");
        suite.addTest(Derby6884Test.baseSuite("Derby6884Test:embedded"));
        return suite;
    }

    public void testDerby6884ImportLargeExtfileClob() throws SQLException {
        LoopingAlphabetReader reader;
        Statement s = this.createStatement();
        PreparedStatement ps = this.prepareStatement("insert into DERBY_6884_TESTCLOB values(? , ?)");
        int id = 1;
        int clobSize = 0;
        for (long byteCount = 0L; byteCount < Integer.MAX_VALUE; byteCount += (long)clobSize) {
            ps.setInt(1, id++);
            clobSize = 10240000 + 1024 * id;
            reader = new LoopingAlphabetReader(clobSize);
            ps.setCharacterStream(2, (Reader)reader, clobSize);
            ps.executeUpdate();
        }
        ps.setInt(1, id++);
        reader = new LoopingAlphabetReader(clobSize);
        ps.setCharacterStream(2, (Reader)reader, clobSize);
        ps.executeUpdate();
        this.commit();
        this.doExportTableLobsToExtFile("APP", "DERBY_6884_TESTCLOB", this.fileName6884, null, null, null, this.lobFile6884);
        s.execute("TRUNCATE TABLE DERBY_6884_TESTCLOB");
        this.doImportTableLobsFromExtFile("APP", "DERBY_6884_TESTCLOB", this.fileName6884, null, null, null, 0);
        SupportFilesSetup.deleteFile(this.fileName6884);
        SupportFilesSetup.deleteFile(this.lobFile6884);
    }

    public void testDerby6884ImportLargeExtfileBlob() throws SQLException {
        LoopingAlphabetStream stream;
        Statement s = this.createStatement();
        PreparedStatement ps = this.prepareStatement("insert into DERBY_6884_TESTBLOB values(? , ?)");
        int id = 1;
        int blobSize = 0;
        for (long byteCount = 0L; byteCount < Integer.MAX_VALUE; byteCount += (long)blobSize) {
            ps.setInt(1, id++);
            blobSize = 51200000 + 1024 * id;
            stream = new LoopingAlphabetStream(blobSize);
            ps.setBinaryStream(2, (InputStream)stream, blobSize);
            ps.executeUpdate();
        }
        ps.setInt(1, id++);
        stream = new LoopingAlphabetStream(blobSize);
        ps.setBinaryStream(2, (InputStream)stream, blobSize);
        ps.executeUpdate();
        this.commit();
        this.doExportTableLobsToExtFile("APP", "DERBY_6884_TESTBLOB", this.fileName6884, null, null, null, this.lobFile6884);
        s.execute("TRUNCATE TABLE DERBY_6884_TESTBLOB");
        this.doImportTableLobsFromExtFile("APP", "DERBY_6884_TESTBLOB", this.fileName6884, null, null, null, 0);
        SupportFilesSetup.deleteFile(this.fileName6884);
        SupportFilesSetup.deleteFile(this.lobFile6884);
    }

    protected static Test baseSuite(String name) {
        BaseTestSuite suite = new BaseTestSuite(name);
        suite.addTestSuite(Derby6884Test.class);
        Object test = suite;
        test = new SupportFilesSetup((Test)test);
        return new CleanDatabaseTestSetup((Test)test){

            @Override
            protected void decorateSQL(Statement stmt) throws SQLException {
                Connection conn = stmt.getConnection();
                stmt.execute("CREATE TABLE DERBY_6884_TESTBLOB(id BIGINT, content BLOB)");
                stmt.execute("CREATE TABLE DERBY_6884_TESTCLOB(id BIGINT, content CLOB)");
                conn.commit();
            }
        };
    }
}

