/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.sql.execute;

import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.List;
import java.util.Properties;
import org.apache.derby.catalog.AliasInfo;
import org.apache.derby.catalog.UUID;
import org.apache.derby.iapi.services.context.Context;
import org.apache.derby.iapi.services.context.ContextService;
import org.apache.derby.iapi.services.io.FormatableBitSet;
import org.apache.derby.iapi.sql.ResultDescription;
import org.apache.derby.iapi.sql.conn.Authorizer;
import org.apache.derby.iapi.sql.conn.LanguageConnectionContext;
import org.apache.derby.iapi.sql.depend.ProviderInfo;
import org.apache.derby.iapi.sql.dictionary.IndexRowGenerator;
import org.apache.derby.iapi.sql.dictionary.SchemaDescriptor;
import org.apache.derby.iapi.sql.dictionary.TableDescriptor;
import org.apache.derby.iapi.sql.execute.ConstantAction;
import org.apache.derby.iapi.store.access.StaticCompiledOpenConglomInfo;
import org.apache.derby.iapi.types.DataTypeDescriptor;
import org.apache.derby.iapi.types.RowLocation;
import org.apache.derby.impl.sql.compile.TableName;
import org.apache.derby.impl.sql.execute.AlterConstraintConstantAction;
import org.apache.derby.impl.sql.execute.AlterTableConstantAction;
import org.apache.derby.impl.sql.execute.ColumnInfo;
import org.apache.derby.impl.sql.execute.ConstraintConstantAction;
import org.apache.derby.impl.sql.execute.ConstraintInfo;
import org.apache.derby.impl.sql.execute.CreateAliasConstantAction;
import org.apache.derby.impl.sql.execute.CreateConstraintConstantAction;
import org.apache.derby.impl.sql.execute.CreateIndexConstantAction;
import org.apache.derby.impl.sql.execute.CreateRoleConstantAction;
import org.apache.derby.impl.sql.execute.CreateSchemaConstantAction;
import org.apache.derby.impl.sql.execute.CreateSequenceConstantAction;
import org.apache.derby.impl.sql.execute.CreateTableConstantAction;
import org.apache.derby.impl.sql.execute.CreateTriggerConstantAction;
import org.apache.derby.impl.sql.execute.CreateViewConstantAction;
import org.apache.derby.impl.sql.execute.DeleteConstantAction;
import org.apache.derby.impl.sql.execute.DropAliasConstantAction;
import org.apache.derby.impl.sql.execute.DropConstraintConstantAction;
import org.apache.derby.impl.sql.execute.DropIndexConstantAction;
import org.apache.derby.impl.sql.execute.DropRoleConstantAction;
import org.apache.derby.impl.sql.execute.DropSchemaConstantAction;
import org.apache.derby.impl.sql.execute.DropSequenceConstantAction;
import org.apache.derby.impl.sql.execute.DropStatisticsConstantAction;
import org.apache.derby.impl.sql.execute.DropTableConstantAction;
import org.apache.derby.impl.sql.execute.DropTriggerConstantAction;
import org.apache.derby.impl.sql.execute.DropViewConstantAction;
import org.apache.derby.impl.sql.execute.FKInfo;
import org.apache.derby.impl.sql.execute.GrantRevokeConstantAction;
import org.apache.derby.impl.sql.execute.GrantRoleConstantAction;
import org.apache.derby.impl.sql.execute.IndexConstantAction;
import org.apache.derby.impl.sql.execute.InsertConstantAction;
import org.apache.derby.impl.sql.execute.LockTableConstantAction;
import org.apache.derby.impl.sql.execute.MatchingClauseConstantAction;
import org.apache.derby.impl.sql.execute.MergeConstantAction;
import org.apache.derby.impl.sql.execute.PrivilegeInfo;
import org.apache.derby.impl.sql.execute.RenameConstantAction;
import org.apache.derby.impl.sql.execute.RevokeRoleConstantAction;
import org.apache.derby.impl.sql.execute.SavepointConstantAction;
import org.apache.derby.impl.sql.execute.SetConstraintsConstantAction;
import org.apache.derby.impl.sql.execute.SetRoleConstantAction;
import org.apache.derby.impl.sql.execute.SetSchemaConstantAction;
import org.apache.derby.impl.sql.execute.SetTransactionIsolationConstantAction;
import org.apache.derby.impl.sql.execute.TriggerInfo;
import org.apache.derby.impl.sql.execute.UpdatableVTIConstantAction;
import org.apache.derby.impl.sql.execute.UpdateConstantAction;
import org.apache.derby.shared.common.error.StandardException;

public class GenericConstantActionFactory {
    public ConstantAction getSetConstraintsConstantAction(List<TableName> constraints, boolean initiallyDeferred) {
        return new SetConstraintsConstantAction(constraints, initiallyDeferred);
    }

    public ConstantAction getAlterTableConstantAction(SchemaDescriptor sd, String tableName, UUID tableId, long tableConglomerateId, int tableType, ColumnInfo[] columnInfo, ConstraintConstantAction[] constraintActions, char lockGranularity, boolean compressTable, int behavior, boolean sequential, boolean truncateTable, boolean purge, boolean defragment, boolean truncateEndOfTable, boolean updateStatistics, boolean updateStatisticsAll, boolean dropStatistics, boolean dropStatisticsAll, String indexNameForStatistics) {
        return new AlterTableConstantAction(sd, tableName, tableId, tableConglomerateId, tableType, columnInfo, constraintActions, lockGranularity, compressTable, behavior, sequential, truncateTable, purge, defragment, truncateEndOfTable, updateStatistics, updateStatisticsAll, dropStatistics, dropStatisticsAll, indexNameForStatistics);
    }

    public CreateConstraintConstantAction getCreateConstraintConstantAction(String constraintName, int constraintType, boolean[] constraintCharacteristics, boolean forCreateTable, String tableName, UUID tableId, String schemaName, String[] columnNames, IndexConstantAction indexAction, String constraintText, ConstraintInfo otherConstraint, ProviderInfo[] providerInfo) {
        return new CreateConstraintConstantAction(constraintName, constraintType, constraintCharacteristics, forCreateTable, tableName, tableId, schemaName, columnNames, indexAction, constraintText, otherConstraint, providerInfo);
    }

    public IndexConstantAction getCreateIndexConstantAction(boolean forCreateTable, boolean unique, boolean uniqueWithDuplicateNulls, boolean hasDeferrableChecking, boolean initiallyDeferred, int constraintType, String indexType, String schemaName, String indexName, String tableName, UUID tableId, String[] columnNames, boolean[] isAscending, boolean isConstraint, UUID conglomerateUUID, Properties properties) {
        return new CreateIndexConstantAction(forCreateTable, unique, uniqueWithDuplicateNulls, hasDeferrableChecking, initiallyDeferred, constraintType, indexType, schemaName, indexName, tableName, tableId, columnNames, isAscending, isConstraint, conglomerateUUID, properties);
    }

    public ConstantAction getCreateAliasConstantAction(String aliasName, String schemaName, String javaClassName, AliasInfo aliasInfo, char aliasType) {
        return new CreateAliasConstantAction(aliasName, schemaName, javaClassName, aliasInfo, aliasType);
    }

    public ConstantAction getCreateSchemaConstantAction(String schemaName, String aid) {
        return new CreateSchemaConstantAction(schemaName, aid);
    }

    public ConstantAction getCreateRoleConstantAction(String roleName) {
        return new CreateRoleConstantAction(roleName);
    }

    public ConstantAction getSetRoleConstantAction(String roleName, int type) {
        return new SetRoleConstantAction(roleName, type);
    }

    public ConstantAction getCreateSequenceConstantAction(TableName sequenceName, DataTypeDescriptor dataType, long initialValue, long stepValue, long maxValue, long minValue, boolean cycle) {
        return new CreateSequenceConstantAction(sequenceName.getSchemaName(), sequenceName.getTableName(), dataType, initialValue, stepValue, maxValue, minValue, cycle);
    }

    public ConstantAction getCreateTableConstantAction(String schemaName, String tableName, int tableType, ColumnInfo[] columnInfo, CreateConstraintConstantAction[] constraintActions, Properties properties, char lockGranularity, boolean onCommitDeleteRows, boolean onRollbackDeleteRows) {
        return new CreateTableConstantAction(schemaName, tableName, tableType, columnInfo, constraintActions, properties, lockGranularity, onCommitDeleteRows, onRollbackDeleteRows);
    }

    public ConstantAction getSavepointConstantAction(String savepointName, int statementType) {
        return new SavepointConstantAction(savepointName, statementType);
    }

    public ConstantAction getCreateViewConstantAction(String schemaName, String tableName, int tableType, String viewText, int checkOption, ColumnInfo[] columnInfo, ProviderInfo[] providerInfo, UUID compSchemaId) {
        return new CreateViewConstantAction(schemaName, tableName, tableType, viewText, checkOption, columnInfo, providerInfo, compSchemaId);
    }

    public ConstantAction getDeleteConstantAction(long conglomId, int tableType, StaticCompiledOpenConglomInfo heapSCOCI, IndexRowGenerator[] irgs, long[] indexCIDS, StaticCompiledOpenConglomInfo[] indexSCOCIs, boolean deferred, boolean tableIsPublished, UUID tableID, int lockMode, Object deleteToken, Object keySignature, int[] keyPositions, long keyConglomId, String schemaName, String tableName, ResultDescription resultDescription, FKInfo[] fkInfo, TriggerInfo triggerInfo, FormatableBitSet baseRowReadList, int[] baseRowReadMap, int[] streamStorableHeapColIds, int numColumns, UUID dependencyId, boolean singleRowSource, ConstantAction[] dependentConstantActions, boolean underMerge) throws StandardException {
        return new DeleteConstantAction(conglomId, heapSCOCI, irgs, indexCIDS, indexSCOCIs, deferred, tableID, lockMode, fkInfo, triggerInfo, baseRowReadList, baseRowReadMap, streamStorableHeapColIds, numColumns, singleRowSource, resultDescription, dependentConstantActions, underMerge);
    }

    public ConstraintConstantAction getDropConstraintConstantAction(String constraintName, String constraintSchemaName, String tableName, UUID tableId, String tableSchemaName, IndexConstantAction indexAction, int behavior, int verifyType) {
        return new DropConstraintConstantAction(constraintName, constraintSchemaName, tableName, tableId, tableSchemaName, indexAction, behavior, verifyType);
    }

    public ConstraintConstantAction getAlterConstraintConstantAction(String constraintName, String constraintSchemaName, boolean[] characteristics, String tableName, UUID tableId, String tableSchemaName, IndexConstantAction indexAction) {
        return new AlterConstraintConstantAction(constraintName, constraintSchemaName, characteristics, tableName, tableId, tableSchemaName, indexAction);
    }

    public IndexConstantAction getDropIndexConstantAction(String fullIndexName, String indexName, String tableName, String schemaName, UUID tableId, long tableConglomerateId) {
        return new DropIndexConstantAction(fullIndexName, indexName, tableName, schemaName, tableId, tableConglomerateId);
    }

    public ConstantAction getDropAliasConstantAction(SchemaDescriptor sd, String aliasName, char aliasType) {
        return new DropAliasConstantAction(sd, aliasName, aliasType);
    }

    public ConstantAction getDropRoleConstantAction(String roleName) {
        return new DropRoleConstantAction(roleName);
    }

    public ConstantAction getDropSequenceConstantAction(SchemaDescriptor sd, String seqName) {
        return new DropSequenceConstantAction(sd, seqName);
    }

    public ConstantAction getDropSchemaConstantAction(String schemaName) {
        return new DropSchemaConstantAction(schemaName);
    }

    public ConstantAction getDropTableConstantAction(String fullTableName, String tableName, SchemaDescriptor sd, long conglomerateNumber, UUID tableId, int behavior) {
        return new DropTableConstantAction(fullTableName, tableName, sd, conglomerateNumber, tableId, behavior);
    }

    public ConstantAction getDropViewConstantAction(String fullTableName, String tableName, SchemaDescriptor sd) {
        return new DropViewConstantAction(fullTableName, tableName, sd);
    }

    public ConstantAction getRenameConstantAction(String fullTableName, String tableName, String oldObjectName, String newObjectName, SchemaDescriptor sd, UUID tableId, boolean usedAlterTable, int renamingWhat) {
        return new RenameConstantAction(fullTableName, tableName, oldObjectName, newObjectName, sd, tableId, usedAlterTable, renamingWhat);
    }

    public ConstantAction getInsertConstantAction(TableDescriptor tableDescriptor, long conglomId, StaticCompiledOpenConglomInfo heapSCOCI, IndexRowGenerator[] irgs, long[] indexCIDS, StaticCompiledOpenConglomInfo[] indexSCOCIs, String[] indexNames, boolean deferred, boolean tableIsPublished, boolean hasDeferrableChecks, UUID tableID, int lockMode, Object insertToken, Object rowSignature, Properties targetProperties, FKInfo[] fkInfo, TriggerInfo triggerInfo, int[] streamStorableHeapColIds, boolean[] indexedCols, UUID dependencyId, Object[] stageControl, Object[] ddlList, boolean singleRowSource, RowLocation[] autoincRowLocation, boolean underMerge, String identitySequenceUUIDString) throws StandardException {
        return new InsertConstantAction(tableDescriptor, conglomId, heapSCOCI, irgs, indexCIDS, indexSCOCIs, indexNames, deferred, hasDeferrableChecks, targetProperties, tableID, lockMode, fkInfo, triggerInfo, streamStorableHeapColIds, indexedCols, singleRowSource, autoincRowLocation, underMerge, identitySequenceUUIDString);
    }

    public ConstantAction getUpdatableVTIConstantAction(int statementType, boolean deferred) throws StandardException {
        return new UpdatableVTIConstantAction(statementType, deferred, null);
    }

    public ConstantAction getUpdatableVTIConstantAction(int statementType, boolean deferred, int[] changedColumnIds) throws StandardException {
        return new UpdatableVTIConstantAction(statementType, deferred, changedColumnIds);
    }

    public ConstantAction getLockTableConstantAction(String fullTableName, long conglomerateNumber, boolean exclusiveMode) {
        return new LockTableConstantAction(fullTableName, conglomerateNumber, exclusiveMode);
    }

    public ConstantAction getSetSchemaConstantAction(String schemaName, int type) {
        return new SetSchemaConstantAction(schemaName, type);
    }

    public ConstantAction getSetTransactionIsolationConstantAction(int isolationLevel) {
        return new SetTransactionIsolationConstantAction(isolationLevel);
    }

    public UpdateConstantAction getUpdateConstantAction(TableDescriptor targetTableDesc, StaticCompiledOpenConglomInfo heapSCOCI, IndexRowGenerator[] irgs, long[] indexCIDS, StaticCompiledOpenConglomInfo[] indexSCOCIs, String[] indexNames, boolean deferred, UUID targetUUID, int lockMode, boolean tableIsPublished, int[] changedColumnIds, int[] keyPositions, Object updateToken, FKInfo[] fkInfo, TriggerInfo triggerInfo, FormatableBitSet baseRowReadList, int[] baseRowReadMap, int[] streamStorableHeapColIds, int numColumns, boolean positionedUpdate, boolean singleRowSource, RowLocation[] autoincRowLocation, boolean underMerge, String identitySequenceUUIDString) throws StandardException {
        return new UpdateConstantAction(targetTableDesc, heapSCOCI, irgs, indexCIDS, indexSCOCIs, indexNames, deferred, targetUUID, lockMode, changedColumnIds, fkInfo, triggerInfo, baseRowReadList, baseRowReadMap, streamStorableHeapColIds, numColumns, positionedUpdate, singleRowSource, autoincRowLocation, underMerge, identitySequenceUUIDString);
    }

    protected static Authorizer getAuthorizer() {
        LanguageConnectionContext lcc = (LanguageConnectionContext)GenericConstantActionFactory.getContext("LanguageConnectionContext");
        return lcc.getAuthorizer();
    }

    public ConstantAction getCreateTriggerConstantAction(String triggerSchemaName, String triggerName, int eventMask, boolean isBefore, boolean isRow, boolean isEnabled, TableDescriptor triggerTable, UUID whenSPSId, String whenText, UUID actionSPSId, String actionText, UUID spsCompSchemaId, int[] referencedCols, int[] referencedColsInTriggerAction, String originalWhenText, String originalActionText, boolean referencingOld, boolean referencingNew, String oldReferencingName, String newReferencingName, ProviderInfo[] providerInfo) {
        return new CreateTriggerConstantAction(triggerSchemaName, triggerName, eventMask, isBefore, isRow, isEnabled, triggerTable, whenSPSId, whenText, actionSPSId, actionText, spsCompSchemaId, referencedCols, referencedColsInTriggerAction, originalWhenText, originalActionText, referencingOld, referencingNew, oldReferencingName, newReferencingName, providerInfo);
    }

    public ConstantAction getDropTriggerConstantAction(SchemaDescriptor sd, String triggerName, UUID tableId) {
        return new DropTriggerConstantAction(sd, triggerName, tableId);
    }

    public ConstantAction getDropStatisticsConstantAction(SchemaDescriptor sd, String fullTableName, String objectName, boolean forTable) {
        return new DropStatisticsConstantAction(sd, fullTableName, objectName, forTable);
    }

    public ConstantAction getGrantConstantAction(PrivilegeInfo privileges, List grantees) {
        return new GrantRevokeConstantAction(true, privileges, grantees);
    }

    public ConstantAction getGrantRoleConstantAction(List roleNames, List grantees) {
        return new GrantRoleConstantAction(roleNames, grantees);
    }

    public ConstantAction getRevokeConstantAction(PrivilegeInfo privileges, List grantees) {
        return new GrantRevokeConstantAction(false, privileges, grantees);
    }

    public ConstantAction getRevokeRoleConstantAction(List roleNames, List grantees) {
        return new RevokeRoleConstantAction(roleNames, grantees);
    }

    public ConstantAction getMatchingClauseConstantAction(int clauseType, String matchRefinementName, ResultDescription thenColumnSignature, String rowMakingMethodName, String resultSetFieldName, String actionMethodName, ConstantAction thenAction) {
        return new MatchingClauseConstantAction(clauseType, matchRefinementName, thenColumnSignature, rowMakingMethodName, resultSetFieldName, actionMethodName, thenAction);
    }

    public MergeConstantAction getMergeConstantAction(ConstantAction[] matchingClauses) {
        return new MergeConstantAction(matchingClauses);
    }

    private static Context getContext(final String contextID) {
        if (System.getSecurityManager() == null) {
            return ContextService.getContext(contextID);
        }
        return AccessController.doPrivileged(new PrivilegedAction<Context>(){

            @Override
            public Context run() {
                return ContextService.getContext(contextID);
            }
        });
    }
}

