/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.client;

import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Serializable;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.sql.Connection;
import java.sql.SQLException;
import java.sql.SQLFeatureNotSupportedException;
import java.util.Locale;
import java.util.NoSuchElementException;
import java.util.Properties;
import java.util.StringTokenizer;
import java.util.logging.Logger;
import javax.sql.DataSource;
import javax.sql.PooledConnection;
import javax.sql.XAConnection;
import org.apache.derby.client.ClientAutoloadedDriver;
import org.apache.derby.client.ClientDataSourceInterface;
import org.apache.derby.client.am.ClientMessageId;
import org.apache.derby.client.am.EncryptionManager;
import org.apache.derby.client.am.LogWriter;
import org.apache.derby.client.am.SQLExceptionFactory;
import org.apache.derby.client.am.SqlException;
import org.apache.derby.client.net.NetLogWriter;
import org.apache.derby.shared.common.error.ExceptionUtil;

public class BasicClientDataSource
implements DataSource,
ClientDataSourceInterface,
Serializable {
    private static final long serialVersionUID = 1894299584216955554L;
    public static final String className__ = "org.apache.derby.client.BasicClientDataSource";
    public static final int TRACE_NONE = 0;
    public static final int TRACE_CONNECTION_CALLS = 1;
    public static final int TRACE_STATEMENT_CALLS = 2;
    public static final int TRACE_RESULT_SET_CALLS = 4;
    public static final int TRACE_DRIVER_CONFIGURATION = 16;
    public static final int TRACE_CONNECTS = 32;
    public static final int TRACE_PROTOCOL_FLOWS = 64;
    public static final int TRACE_RESULT_SET_META_DATA = 128;
    public static final int TRACE_PARAMETER_META_DATA = 256;
    public static final int TRACE_DIAGNOSTICS = 512;
    public static final int TRACE_XA_CALLS = 2048;
    public static final int TRACE_ALL = -1;
    public static final int propertyDefault_traceLevel = -1;
    public static final short USER_ONLY_SECURITY = 4;
    public static final short CLEAR_TEXT_PASSWORD_SECURITY = 3;
    public static final short ENCRYPTED_PASSWORD_SECURITY = 7;
    public static final short ENCRYPTED_USER_AND_PASSWORD_SECURITY = 9;
    public static final short STRONG_PASSWORD_SUBSTITUTE_SECURITY = 8;
    private int loginTimeout;
    private transient PrintWriter logWriter;
    private String databaseName;
    private String description;
    private String dataSourceName;
    private int portNumber = 1527;
    private String serverName = "localhost";
    public static final int SSL_OFF = 0;
    private static final String SSL_OFF_STR = "off";
    public static final int SSL_BASIC = 1;
    private static final String SSL_BASIC_STR = "basic";
    public static final int SSL_PEER_AUTHENTICATION = 2;
    private static final String SSL_PEER_AUTHENTICATION_STR = "peerAuthentication";
    private String user = "APP";
    private static final short SECMEC_HAS_NOT_EXPLICITLY_SET = 0;
    private short securityMechanism = 0;
    private boolean retrieveMessageText = true;
    private String traceFile;
    private transient int traceFileSuffixIndex_ = 0;
    private String traceDirectory;
    private boolean traceFileAppend = false;
    private String password;
    private int sslMode;
    private boolean createDatabase;
    private boolean shutdownDatabase;
    private String connectionAttributes = null;
    private int traceLevel = -1;

    @Override
    public synchronized void setLoginTimeout(int seconds) {
        this.loginTimeout = seconds;
    }

    @Override
    public int getLoginTimeout() {
        return this.loginTimeout;
    }

    @Override
    public synchronized void setLogWriter(PrintWriter logWriter) {
        this.logWriter = logWriter;
    }

    @Override
    public PrintWriter getLogWriter() {
        return this.logWriter;
    }

    public static int getSSLModeFromString(String s) throws SqlException {
        if (s != null) {
            if (s.equalsIgnoreCase(SSL_OFF_STR)) {
                return 0;
            }
            if (s.equalsIgnoreCase(SSL_BASIC_STR)) {
                return 1;
            }
            if (s.equalsIgnoreCase(SSL_PEER_AUTHENTICATION_STR)) {
                return 2;
            }
            throw new SqlException(null, new ClientMessageId("XJ05B.C"), "ssl", s, "off, basic, peerAuthentication");
        }
        return 0;
    }

    public static int getClientSSLMode(Properties properties) throws SqlException {
        return BasicClientDataSource.getSSLModeFromString(properties.getProperty("ssl"));
    }

    public static String getUser(Properties properties) {
        String userString = properties.getProperty("user");
        return BasicClientDataSource.parseString(userString, "APP");
    }

    public static short getSecurityMechanism(Properties properties) {
        short secmec;
        String securityMechanismString = properties.getProperty("securityMechanism");
        if (securityMechanismString != null) {
            secmec = Short.parseShort(securityMechanismString);
        } else {
            String passwordString = properties.getProperty("password");
            secmec = BasicClientDataSource.getUpgradedSecurityMechanism(passwordString);
        }
        return secmec;
    }

    private static short getUpgradedSecurityMechanism(String password) {
        if (password == null) {
            return 4;
        }
        return 3;
    }

    public static boolean getRetrieveMessageText(Properties properties) {
        String retrieveMessageTextString = properties.getProperty("retrieveMessageText");
        return BasicClientDataSource.parseBoolean(retrieveMessageTextString, true);
    }

    public static String getTraceFile(Properties properties) {
        return properties.getProperty("traceFile");
    }

    public static String getTraceDirectory(Properties properties) {
        String traceDirectoryString = BasicClientDataSource.readSystemProperty("derby.client.traceDirectory");
        if (traceDirectoryString == null && properties != null) {
            return properties.getProperty("traceDirectory");
        }
        return traceDirectoryString;
    }

    private static String readSystemProperty(final String key) {
        return AccessController.doPrivileged(new PrivilegedAction<String>(){

            @Override
            public String run() {
                try {
                    return System.getProperty(key);
                }
                catch (SecurityException se) {
                    return null;
                }
            }
        });
    }

    public static boolean getTraceFileAppend(Properties properties) {
        String traceFileAppendString = properties.getProperty("traceFileAppend");
        return BasicClientDataSource.parseBoolean(traceFileAppendString, false);
    }

    public static String getPassword(Properties properties) {
        return properties.getProperty("password");
    }

    @Override
    public synchronized void setPassword(String password) {
        this.password = password;
    }

    @Override
    public String getPassword() {
        return this.password;
    }

    private LogWriter computeDncLogWriterForNewConnection(String logWriterInUseSuffix) throws SqlException {
        return BasicClientDataSource.computeDncLogWriterForNewConnection(this.logWriter, this.traceDirectory, this.traceFile, this.traceFileAppend, this.traceLevel, logWriterInUseSuffix, this.traceFileSuffixIndex_++);
    }

    public static LogWriter computeDncLogWriterForNewConnection(PrintWriter logWriter, String traceDirectory, String traceFile, boolean traceFileAppend, int traceLevel, String logWriterInUseSuffix, int traceFileSuffixIndex) throws SqlException {
        LogWriter dncLogWriter = BasicClientDataSource.computeDncLogWriter(logWriter, traceDirectory, traceFile, traceFileAppend, logWriterInUseSuffix, traceFileSuffixIndex, traceLevel);
        return dncLogWriter;
    }

    private static LogWriter computeDncLogWriter(PrintWriter logWriter, String traceDirectory, String traceFile, boolean traceFileAppend, String logWriterInUseSuffix, int traceFileSuffixIndex, int traceLevel) throws SqlException {
        if (traceLevel == 0) {
            return null;
        }
        PrintWriter printWriter = BasicClientDataSource.computePrintWriter(logWriter, traceDirectory, traceFile, traceFileAppend, logWriterInUseSuffix, traceFileSuffixIndex);
        if (printWriter == null) {
            return null;
        }
        NetLogWriter dncLogWriter = new NetLogWriter(printWriter, traceLevel);
        if (printWriter != logWriter && (traceDirectory != null || traceFile != null)) {
            dncLogWriter.printWriterNeedsToBeClosed_ = true;
        }
        return dncLogWriter;
    }

    private static PrintWriter computePrintWriter(PrintWriter logWriter, String traceDirectory, String traceFile, boolean traceFileAppend, String logWriterInUseSuffix, int traceFileSuffixIndex) throws SqlException {
        if (logWriter != null) {
            return logWriter;
        }
        if (traceDirectory != null) {
            String fileName = traceFile == null ? traceDirectory + File.separator + logWriterInUseSuffix + "_" + traceFileSuffixIndex : traceDirectory + File.separator + traceFile + logWriterInUseSuffix + "_" + traceFileSuffixIndex;
            return BasicClientDataSource.getPrintWriter(fileName, true);
        }
        if (traceFile != null) {
            return BasicClientDataSource.getPrintWriter(traceFile, traceFileAppend);
        }
        return null;
    }

    private static PrintWriter getPrintWriter(final String fileName, final boolean fileAppend) throws SqlException {
        PrintWriter printWriter = null;
        try {
            printWriter = AccessController.doPrivileged(new PrivilegedExceptionAction<PrintWriter>(){

                @Override
                public PrintWriter run() throws IOException {
                    String fileCanonicalPath = new File(fileName).getCanonicalPath();
                    return new PrintWriter(new BufferedOutputStream(new FileOutputStream(fileCanonicalPath, fileAppend), 4096), true);
                }
            });
        }
        catch (PrivilegedActionException pae) {
            throw new SqlException(null, new ClientMessageId("XJ113.S"), new Object[]{new Object[]{fileName, pae.getMessage()}, pae});
        }
        return printWriter;
    }

    private static boolean parseBoolean(String boolString, boolean defaultBool) {
        if (boolString != null) {
            return boolString.equalsIgnoreCase("true") || boolString.equalsIgnoreCase("yes");
        }
        return defaultBool;
    }

    private static String parseString(String string, String defaultString) {
        if (string != null) {
            return string;
        }
        return defaultString;
    }

    private static int parseInt(String intString, int defaultInt) {
        if (intString != null) {
            return Integer.parseInt(intString);
        }
        return defaultInt;
    }

    public static Properties tokenizeAttributes(String attributeString, Properties properties) throws SqlException {
        if (attributeString == null) {
            return properties;
        }
        Properties augmentedProperties = properties != null ? (Properties)properties.clone() : new Properties();
        try {
            StringTokenizer attrTokenizer = new StringTokenizer(attributeString, ";");
            while (attrTokenizer.hasMoreTokens()) {
                String v = attrTokenizer.nextToken();
                int eqPos = v.indexOf(61);
                if (eqPos == -1) {
                    throw new SqlException(null, new ClientMessageId("XJ212.S"), attributeString);
                }
                augmentedProperties.setProperty(v.substring(0, eqPos).trim(), v.substring(eqPos + 1).trim());
            }
        }
        catch (NoSuchElementException e) {
            throw new SqlException(null, new ClientMessageId("XJ212.S"), e, attributeString);
        }
        BasicClientDataSource.checkBoolean(augmentedProperties, "retrieveMessageText");
        return augmentedProperties;
    }

    private static void checkBoolean(Properties set, String attribute) throws SqlException {
        String[] booleanChoices = new String[]{"true", "false"};
        BasicClientDataSource.checkEnumeration(set, attribute, booleanChoices);
    }

    private static void checkEnumeration(Properties set, String attribute, String[] choices) throws SqlException {
        String value = set.getProperty(attribute);
        if (value == null) {
            return;
        }
        for (int i = 0; i < choices.length; ++i) {
            if (!value.toUpperCase(Locale.ENGLISH).equals(choices[i].toUpperCase(Locale.ENGLISH))) continue;
            return;
        }
        Object choicesStr = "{";
        for (int i = 0; i < choices.length; ++i) {
            if (i > 0) {
                choicesStr = (String)choicesStr + "|";
            }
            choicesStr = (String)choicesStr + choices[i];
        }
        throw new SqlException(null, new ClientMessageId("XJ05B.C"), attribute, value, choicesStr);
    }

    @Override
    public synchronized void setDatabaseName(String databaseName) {
        this.databaseName = databaseName;
    }

    @Override
    public String getDatabaseName() {
        return this.databaseName;
    }

    @Override
    public synchronized void setDataSourceName(String dataSourceName) {
        this.dataSourceName = dataSourceName;
    }

    @Override
    public String getDataSourceName() {
        return this.dataSourceName;
    }

    @Override
    public synchronized void setDescription(String description) {
        this.description = description;
    }

    @Override
    public String getDescription() {
        return this.description;
    }

    @Override
    public synchronized void setPortNumber(int portNumber) {
        this.portNumber = portNumber;
    }

    @Override
    public int getPortNumber() {
        return this.portNumber;
    }

    @Override
    public synchronized void setServerName(String serverName) {
        this.serverName = serverName;
    }

    @Override
    public String getServerName() {
        return this.serverName;
    }

    @Override
    public synchronized void setUser(String user) {
        this.user = user;
    }

    @Override
    public String getUser() {
        return this.user;
    }

    @Override
    public synchronized void setRetrieveMessageText(boolean retrieveMessageText) {
        this.retrieveMessageText = retrieveMessageText;
    }

    @Override
    public boolean getRetrieveMessageText() {
        return this.retrieveMessageText;
    }

    @Override
    public synchronized void setSecurityMechanism(short securityMechanism) {
        this.securityMechanism = securityMechanism;
    }

    @Override
    public short getSecurityMechanism() {
        return this.getSecurityMechanism(this.getPassword());
    }

    @Override
    public short getSecurityMechanism(String password) {
        if (this.securityMechanism == 0) {
            return BasicClientDataSource.getUpgradedSecurityMechanism(password);
        }
        return this.securityMechanism;
    }

    @Override
    public void setSsl(String mode) throws SqlException {
        this.sslMode = BasicClientDataSource.getSSLModeFromString(mode);
    }

    @Override
    public String getSsl() {
        switch (this.sslMode) {
            default: {
                return SSL_OFF_STR;
            }
            case 1: {
                return SSL_BASIC_STR;
            }
            case 2: 
        }
        return SSL_PEER_AUTHENTICATION_STR;
    }

    @Override
    public void setCreateDatabase(String create) {
        this.createDatabase = create != null && create.equalsIgnoreCase("create");
    }

    @Override
    public String getCreateDatabase() {
        String createstr = null;
        if (this.createDatabase) {
            createstr = "create";
        }
        return createstr;
    }

    @Override
    public void setShutdownDatabase(String shutdown) {
        this.shutdownDatabase = shutdown != null && shutdown.equalsIgnoreCase("shutdown");
    }

    @Override
    public String getShutdownDatabase() {
        String shutdownstr = null;
        if (this.shutdownDatabase) {
            shutdownstr = "shutdown";
        }
        return shutdownstr;
    }

    @Override
    public void setConnectionAttributes(String prop) {
        this.connectionAttributes = prop;
    }

    @Override
    public String getConnectionAttributes() {
        return this.connectionAttributes;
    }

    public static int getTraceLevel(Properties properties) {
        String traceLevelString = BasicClientDataSource.readSystemProperty("derby.client.traceLevel");
        if (traceLevelString == null && properties != null) {
            traceLevelString = properties.getProperty("traceLevel");
        }
        if (traceLevelString != null) {
            return BasicClientDataSource.parseInt(traceLevelString, -1);
        }
        return -1;
    }

    @Override
    public synchronized void setTraceLevel(int traceLevel) {
        this.traceLevel = traceLevel;
    }

    @Override
    public int getTraceLevel() {
        return this.traceLevel;
    }

    @Override
    public synchronized void setTraceFile(String traceFile) {
        this.traceFile = traceFile;
    }

    @Override
    public String getTraceFile() {
        return this.traceFile;
    }

    @Override
    public synchronized void setTraceDirectory(String traceDirectory) {
        this.traceDirectory = traceDirectory;
    }

    @Override
    public String getTraceDirectory() {
        return this.traceDirectory;
    }

    @Override
    public synchronized void setTraceFileAppend(boolean traceFileAppend) {
        this.traceFileAppend = traceFileAppend;
    }

    @Override
    public boolean getTraceFileAppend() {
        return this.traceFileAppend;
    }

    public int maxStatementsToPool() {
        return 0;
    }

    private void updateDataSourceValues(Properties prop) throws SqlException {
        int traceLevel;
        String traceDir = BasicClientDataSource.getTraceDirectory(prop);
        if (traceDir != null) {
            this.setTraceDirectory(traceDir);
        }
        if ((traceLevel = BasicClientDataSource.getTraceLevel(prop)) != -1) {
            this.setTraceLevel(traceLevel);
        }
        if (prop == null) {
            return;
        }
        if (prop.containsKey("user")) {
            this.setUser(BasicClientDataSource.getUser(prop));
        }
        if (prop.containsKey("securityMechanism")) {
            this.setSecurityMechanism(BasicClientDataSource.getSecurityMechanism(prop));
        }
        if (prop.containsKey("traceFile")) {
            this.setTraceFile(BasicClientDataSource.getTraceFile(prop));
        }
        if (prop.containsKey("traceFileAppend")) {
            this.setTraceFileAppend(BasicClientDataSource.getTraceFileAppend(prop));
        }
        if (prop.containsKey("retrieveMessageText")) {
            this.setRetrieveMessageText(BasicClientDataSource.getRetrieveMessageText(prop));
        }
        if (prop.containsKey("ssl")) {
            this.sslMode = BasicClientDataSource.getClientSSLMode(prop);
        }
    }

    private void handleConnectionException(LogWriter logWriter, SqlException sqle) throws SQLException {
        if (sqle.getSQLState().equals(ExceptionUtil.getSQLStateFromIdentifier("XJ212.S"))) {
            throw new SqlException(logWriter, new ClientMessageId("XJ028.C"), sqle, this.constructUrl()).getSQLException();
        }
    }

    private String constructUrl() {
        StringBuilder sb = new StringBuilder(64);
        sb.append("jdbc:derby://");
        sb.append(this.serverName);
        sb.append(':');
        sb.append(this.portNumber);
        sb.append('/');
        sb.append(this.databaseName);
        if (this.connectionAttributes != null) {
            sb.append(';');
            sb.append(this.connectionAttributes);
        }
        return sb.toString();
    }

    @Override
    public Connection getConnection() throws SQLException {
        LogWriter dncLogWriter = null;
        try {
            this.updateDataSourceValues(BasicClientDataSource.tokenizeAttributes(this.getConnectionAttributes(), null));
            dncLogWriter = this.computeDncLogWriterForNewConnection("_sds");
            return this.getConnectionX(dncLogWriter, this.getUser(), this.getPassword());
        }
        catch (SqlException se) {
            this.handleConnectionException(dncLogWriter, se);
            throw se.getSQLException();
        }
    }

    @Override
    public Connection getConnection(String user, String password) throws SQLException {
        LogWriter dncLogWriter = null;
        try {
            this.updateDataSourceValues(BasicClientDataSource.tokenizeAttributes(this.getConnectionAttributes(), null));
            dncLogWriter = this.computeDncLogWriterForNewConnection("_sds");
            return this.getConnectionX(dncLogWriter, user, password);
        }
        catch (SqlException se) {
            this.handleConnectionException(dncLogWriter, se);
            throw se.getSQLException();
        }
    }

    private Connection getConnectionX(LogWriter dncLogWriter, String user, String password) throws SqlException {
        return ClientAutoloadedDriver.getFactory().newNetConnection(dncLogWriter, user, password, this, -1, false);
    }

    @Override
    public boolean isWrapperFor(Class<?> iface) throws SQLException {
        return iface.isInstance(this);
    }

    @Override
    public <T> T unwrap(Class<T> iface) throws SQLException {
        try {
            return iface.cast(this);
        }
        catch (ClassCastException cce) {
            throw new SqlException(null, new ClientMessageId("XJ128.S"), iface).getSQLException();
        }
    }

    @Override
    public Logger getParentLogger() throws SQLFeatureNotSupportedException {
        throw SQLExceptionFactory.notImplemented("getParentLogger");
    }

    protected final PooledConnection getPooledConnectionMinion() throws SQLException {
        LogWriter dncLogWriter = null;
        try {
            this.updateDataSourceValues(BasicClientDataSource.tokenizeAttributes(this.getConnectionAttributes(), null));
            dncLogWriter = this.computeDncLogWriterForNewConnection("_cpds");
            if (dncLogWriter != null) {
                dncLogWriter.traceEntry(this, "getPooledConnection", new Object[0]);
            }
            PooledConnection pooledConnection = BasicClientDataSource.getPooledConnectionX(dncLogWriter, this, this.getUser(), this.getPassword());
            if (dncLogWriter != null) {
                dncLogWriter.traceExit((Object)this, "getPooledConnection", pooledConnection);
            }
            return pooledConnection;
        }
        catch (SqlException se) {
            this.handleConnectionException(dncLogWriter, se);
            throw se.getSQLException();
        }
    }

    protected final PooledConnection getPooledConnectionMinion(String user, String password) throws SQLException {
        LogWriter dncLogWriter = null;
        try {
            this.updateDataSourceValues(BasicClientDataSource.tokenizeAttributes(this.getConnectionAttributes(), null));
            dncLogWriter = this.computeDncLogWriterForNewConnection("_cpds");
            if (dncLogWriter != null) {
                dncLogWriter.traceEntry(this, "getPooledConnection", user, "<escaped>");
            }
            PooledConnection pooledConnection = BasicClientDataSource.getPooledConnectionX(dncLogWriter, this, user, password);
            if (dncLogWriter != null) {
                dncLogWriter.traceExit((Object)this, "getPooledConnection", pooledConnection);
            }
            return pooledConnection;
        }
        catch (SqlException se) {
            this.handleConnectionException(dncLogWriter, se);
            throw se.getSQLException();
        }
    }

    private static PooledConnection getPooledConnectionX(LogWriter dncLogWriter, BasicClientDataSource ds, String user, String password) throws SQLException {
        return ClientAutoloadedDriver.getFactory().newClientPooledConnection(ds, dncLogWriter, user, password);
    }

    protected final XAConnection getXAConnectionMinion() throws SQLException {
        LogWriter dncLogWriter = null;
        try {
            this.updateDataSourceValues(BasicClientDataSource.tokenizeAttributes(this.getConnectionAttributes(), null));
            dncLogWriter = this.computeDncLogWriterForNewConnection("_xads");
            return BasicClientDataSource.getXAConnectionX(dncLogWriter, this, this.getUser(), this.getPassword());
        }
        catch (SqlException se) {
            this.handleConnectionException(dncLogWriter, se);
            throw se.getSQLException();
        }
    }

    protected final XAConnection getXAConnectionMinion(String user, String password) throws SQLException {
        LogWriter dncLogWriter = null;
        try {
            this.updateDataSourceValues(BasicClientDataSource.tokenizeAttributes(this.getConnectionAttributes(), null));
            dncLogWriter = this.computeDncLogWriterForNewConnection("_xads");
            return BasicClientDataSource.getXAConnectionX(dncLogWriter, this, user, password);
        }
        catch (SqlException se) {
            this.handleConnectionException(dncLogWriter, se);
            throw se.getSQLException();
        }
    }

    private static XAConnection getXAConnectionX(LogWriter dncLogWriter, BasicClientDataSource ds, String user, String password) throws SQLException {
        return ClientAutoloadedDriver.getFactory().newClientXAConnection(ds, dncLogWriter, user, password);
    }

    public static Properties getProperties(BasicClientDataSource ths) {
        Properties properties = new Properties();
        Method[] methods = ths.getClass().getMethods();
        for (int i = 0; i < methods.length; ++i) {
            Class<?> returnType;
            String methodName;
            Method m = methods[i];
            if (m.getParameterTypes().length != 0 || Modifier.isStatic(m.getModifiers()) || (methodName = m.getName()).length() < 5 || !methodName.startsWith("get") || !Integer.TYPE.equals(returnType = m.getReturnType()) && !Short.TYPE.equals(returnType) && !String.class.equals(returnType) && !Boolean.TYPE.equals(returnType)) continue;
            String propertyName = methodName.substring(3, 4).toLowerCase(Locale.ENGLISH).concat(methodName.substring(4));
            try {
                Object ov = m.invoke((Object)ths, (Object[])null);
                if (ov == null) continue;
                properties.setProperty(propertyName, ov.toString());
                continue;
            }
            catch (IllegalAccessException illegalAccessException) {
                continue;
            }
            catch (InvocationTargetException invocationTargetException) {
                // empty catch block
            }
        }
        return properties;
    }

    static {
        try {
            new EncryptionManager(null);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

