/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derbyTesting.functionTests.harness;

import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.io.Writer;
import java.lang.reflect.Method;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.util.Enumeration;
import java.util.Locale;
import java.util.Properties;
import java.util.StringTokenizer;
import java.util.Vector;
import junit.framework.Test;
import junit.textui.TestRunner;
import org.apache.derby.shared.common.info.JVMInfo;
import org.apache.derbyTesting.functionTests.harness.CopySuppFiles;
import org.apache.derbyTesting.functionTests.harness.CurrentTime;
import org.apache.derbyTesting.functionTests.harness.FileCompare;
import org.apache.derbyTesting.functionTests.harness.JavaVersionHolder;
import org.apache.derbyTesting.functionTests.harness.MultiTest;
import org.apache.derbyTesting.functionTests.harness.NetServer;
import org.apache.derbyTesting.functionTests.harness.ProcessStreamResult;
import org.apache.derbyTesting.functionTests.harness.RunClass;
import org.apache.derbyTesting.functionTests.harness.RunIJ;
import org.apache.derbyTesting.functionTests.harness.RunList;
import org.apache.derbyTesting.functionTests.harness.Sed;
import org.apache.derbyTesting.functionTests.harness.SkipTest;
import org.apache.derbyTesting.functionTests.harness.SpecialFlags;
import org.apache.derbyTesting.functionTests.harness.SysInfoLog;
import org.apache.derbyTesting.functionTests.harness.TimedProcess;
import org.apache.derbyTesting.functionTests.harness.UnJar;
import org.apache.derbyTesting.functionTests.harness.dbcleanup;
import org.apache.derbyTesting.functionTests.harness.jvm;
import org.apache.derbyTesting.functionTests.harness.shutdown;
import org.apache.derbyTesting.junit.BaseTestSuite;

public class RunTest {
    static boolean verbose = false;
    static boolean skiptest = false;
    static StringBuffer skiptestReason = new StringBuffer();
    static final String testResourceHome = "/org/apache/derbyTesting/functionTests/";
    static String[] validFrameworks = new String[]{"embedded", "", "DerbyNet", "DerbyNetClient", "DB2jcc", "DB2app"};
    static NetServer ns;
    static boolean serverNeedsStopping;
    static boolean jvmnet;
    static String jvmnetjvm;
    static String driverName;
    static String dbName;
    static String jvmName;
    static String javaCmd;
    static String javaVersion;
    static String majorVersion;
    static String minorVersion;
    static int jccMajor;
    static int jccMinor;
    static int imajor;
    static int iminor;
    static boolean isjdk12test;
    static String classpath;
    static String classpathServer;
    public static String framework;
    public static String J9_STATEMENTCACHESIZE;
    static String usesystem;
    static String searchCP;
    static boolean useCommonDB;
    static boolean keepfiles;
    static boolean useprocess;
    static boolean systemdiff;
    static boolean upgradetest;
    static boolean encryption;
    static boolean jdk12exttest;
    static boolean generateUTF8Out;
    static String runningdir;
    static String outputdir;
    static String canondir;
    static String bootcp;
    static String canonpath;
    static String mtestdir;
    static String testSpecialProps;
    static String testJavaFlags;
    static String jvmflags;
    static boolean reportstderr;
    static int timeout;
    public static String timeoutStr;
    static String jarfile;
    static boolean skipsed;
    static String commonDBHome;
    static boolean dbIsNew;
    static String runwithjvm;
    static boolean startServer;
    static String hostName;
    static String testEncoding;
    static String upgradejarpath;
    static boolean replacePolicyFile;
    static String scriptName;
    static String scriptFileName;
    static String testDirName;
    static String defaultPackageName;
    static String javaPath;
    static String testType;
    static String testBase;
    static String testOutName;
    static String passFileName;
    static String failFileName;
    static String UTF8OutName;
    static String tempMasterName;
    static File passFile;
    static File failFile;
    static String shutdownurl;
    static boolean useOutput;
    static boolean outcopy;
    static String userdir;
    static char fileSep;
    static PrintWriter printWriter;
    static PrintWriter pwDiff;
    static File script;
    static File baseDir;
    static boolean deleteBaseDir;
    static File outDir;
    static File runDir;
    static File canonDir;
    static File tmpOutFile;
    static File tempMasterFile;
    static File stdOutFile;
    static File finalOutFile;
    static File UTF8OutFile;
    static File appPropFile;
    static File clPropFile;
    static File diffFile;
    static File tsuiteDir;
    static File rsuiteDir;
    static File extInDir;
    static File extOutDir;
    static File extInOutDir;
    static String topsuitedir;
    static String topsuiteName;
    static String topreportdir;
    static String suiteName;
    static boolean isSuiteRun;
    static boolean lastTestFailed;
    static boolean isI18N;
    static String codeset;
    static boolean junitXASingle;
    static boolean runWithoutSecurityManager;
    static InputStream isSed;

    public static void main(String[] stringArray) throws Exception {
        boolean bl;
        Object object;
        block39: {
            Object object2;
            Locale.setDefault(Locale.US);
            skiptestReason.setLength(0);
            if (stringArray.length == 0) {
                System.out.println("no test name provided");
                System.exit(1);
            }
            scriptName = stringArray[0];
            if (Boolean.getBoolean("listOnly")) {
                System.out.println("LISTONLY :" + scriptName);
                return;
            }
            if (scriptName == null || scriptName.equals("")) {
                System.out.println("Null or blank test script name.");
                System.exit(1);
            }
            if (stringArray.length == 7) {
                defaultPackageName = stringArray[1];
                usesystem = stringArray[2];
                useprocess = false;
                shutdownurl = stringArray[4];
                isSuiteRun = true;
                suiteName = stringArray[5];
                framework = stringArray[6];
                startServer = true;
            }
            testType = scriptName.substring(scriptName.lastIndexOf(".") + 1);
            RunTest.verifyTestType();
            Properties properties = System.getProperties();
            if (!useprocess) {
                properties.put("useprocess", "false");
                if (properties.getProperty("maximumDisplayWidth") == null) {
                    properties.put("maximumDisplayWidth", "128");
                }
                if (properties.getProperty("ij.defaultResourcePackage") != null) {
                    properties.put("ij.defaultResourcePackage", defaultPackageName);
                }
                System.setProperties(properties);
            }
            JavaVersionHolder javaVersionHolder = RunTest.getProperties(properties);
            boolean bl2 = javaVersionHolder.atLeast(1, 6);
            RunTest.setDirectories(scriptName, properties);
            if (testDirName.startsWith("i18n")) {
                isI18N = true;
            }
            AppsRequiredPassword appsRequiredPassword = new AppsRequiredPassword();
            String string = RunTest.createPropString(appsRequiredPassword);
            if (!isSuiteRun && useprocess) {
                object2 = new SysInfoLog();
                ((SysInfoLog)object2).exec(jvmName, javaCmd, classpath, framework, pwDiff, useprocess);
            }
            object2 = CurrentTime.getTime();
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append("*** Start: " + testBase + " jdk" + javaVersion + " ");
            if (framework.length() > 0 && !framework.startsWith("embedded")) {
                stringBuffer.append(framework + " ");
            }
            if (suiteName != null && suiteName.length() > 0) {
                stringBuffer.append(suiteName + " ");
            }
            stringBuffer.append((String)object2 + " ***");
            System.out.println(stringBuffer.toString());
            pwDiff.println(stringBuffer.toString());
            if (driverName != null && !skiptest) {
                RunTest.composePolicyFile();
                object = jvmflags;
                if (jvmflags != null && jvmflags.indexOf("^") > 0) {
                    object = RunTest.spaceJvmFlags(jvmflags);
                }
                if (!timeoutStr.isEmpty() && timeoutStr != null && timeout >= 0) {
                    object = object != null ? "-Dtimeout=" + timeoutStr + " " + (String)object : "-Dtimeout=" + timeoutStr + " ";
                }
                System.out.println("Initialize for framework: " + framework);
                if (jvmnet && framework.startsWith("DerbyNet")) {
                    String string2 = System.getProperty("serverJvmName");
                    if (string2 == null) {
                        string2 = "j9_22";
                    }
                    ns = new NetServer(baseDir, string2, classpathServer, null, (String)object, framework, startServer, appsRequiredPassword.password);
                } else {
                    ns = new NetServer(baseDir, jvmName, classpathServer, javaCmd, (String)object, framework, startServer, appsRequiredPassword.password);
                }
                if (!useprocess && isSuiteRun) {
                    boolean bl3 = false;
                    try {
                        bl3 = ns.testNetworkServerConnection();
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    if (!bl3 && startServer) {
                        ns.start();
                    }
                    if (bl3 && !startServer) {
                        ns.stop();
                    }
                } else {
                    ns.start();
                    serverNeedsStopping = true;
                }
            }
            if (jarfile != null) {
                object = new UnJar();
                UnJar.unjar(jarfile, outDir.getCanonicalPath(), true);
            }
            if (skiptest) {
                if (skiptestReason.length() == 0) {
                    RunTest.addSkiptestReason("Test skipped: skiptest set without setting skiptestReason, please fix RunTest.java...");
                }
                pwDiff.println(skiptestReason);
                System.out.println(skiptestReason);
                RunTest.doCleanup(javaVersion);
                return;
            }
            RunTest.testRun(string, properties);
            if (serverNeedsStopping) {
                ns.stop();
            }
            object = finalOutFile.getPath();
            if (skipsed) {
                tmpOutFile.renameTo(finalOutFile);
            } else {
                try {
                    Sed sed = new Sed();
                    sed.exec(tmpOutFile, finalOutFile, isSed, NetServer.isClientConnection(framework), isI18N, bl2);
                }
                catch (ClassFormatError classFormatError) {
                    if (!verbose) break block39;
                    System.out.println("SED Error: " + classFormatError.getMessage());
                }
            }
        }
        String string = framework;
        if (framework.startsWith("embedded")) {
            string = "";
        }
        FileCompare fileCompare = new FileCompare();
        if (verbose) {
            System.out.println("About to execute: diff.exec( outName = " + (String)object + ",outDir = " + outDir + ",pwDiff = " + pwDiff + ",testOutName = " + testOutName + ",frameworkMaster = " + string + ",jvmName = " + jvmName + ",iminor = " + iminor + ",useprocess = " + useprocess + ",systemdiff = " + systemdiff + ",canondir = " + canondir + ",canonpath = " + canonpath + ")\n");
        }
        if (jvmnet) {
            if (jvmnetjvm == null) {
                jvmnetjvm = "j9_22";
            }
            bl = fileCompare.exec((String)object, outDir, pwDiff, testOutName, string, jvmName, iminor, useprocess, systemdiff, canondir, canonpath, jvmnetjvm);
        } else {
            bl = fileCompare.exec((String)object, outDir, pwDiff, testOutName, string, jvmName, iminor, useprocess, systemdiff, canondir, canonpath, null);
        }
        if (bl) {
            lastTestFailed = true;
            pwDiff.println("Test Failed.");
            System.out.println("Test Failed.");
            keepfiles = true;
            RunTest.addToFailures(scriptName);
            if (useCommonDB) {
                bl = baseDir.delete();
            }
        } else {
            RunTest.addToSuccesses(scriptName);
            pwDiff.flush();
        }
        RunTest.generateUTF8OutFile(finalOutFile);
        RunTest.doCleanup(javaVersion);
    }

    private static void testRun(String string, Properties properties) throws FileNotFoundException, IOException, Exception {
        String string2 = baseDir.getPath();
        String string3 = null;
        if (testType.startsWith("sql")) {
            string3 = script.getPath();
        }
        if (useCommonDB && (usesystem == null || usesystem == "") && (testType.equals("sql") || testType.equals("java") || testType.equals("sql2"))) {
            dbcleanup.doit(dbIsNew);
        }
        if (useprocess) {
            String[] stringArray = RunTest.buildTestCommand(string, string2, string3);
            RunTest.execTestProcess(stringArray);
        } else {
            RunTest.execTestNoProcess(properties, string2, string, string3);
        }
    }

    private static void setDirectories(String string, Properties properties) throws ClassNotFoundException, FileNotFoundException, IOException {
        Object object;
        Object object2;
        Object object3;
        userdir = properties.getProperty("user.dir");
        if (!useprocess) {
            defaultPackageName = "/org/apache/derbyTesting/";
        }
        if (useCommonDB) {
            defaultPackageName = "/org/apache/derbyTesting/";
        }
        String string2 = defaultPackageName + "functionTests/tests/";
        int n = string.lastIndexOf(47);
        if (n == -1) {
            if (!(testType.equals("sql") || testType.equals("java") || testType.equals("junit"))) {
                System.out.println("Test argument should be of the form: <dir>/<test>.<ext>");
                System.exit(1);
            } else {
                scriptFileName = string;
                string2 = string2 + string;
            }
        } else {
            testDirName = n == 0 ? "" : string.substring(0, n);
            scriptFileName = string.substring(n + 1, string.length());
            defaultPackageName = testType.equals("multi") ? defaultPackageName + "functionTests/multi/" + testDirName + "/" : defaultPackageName + "functionTests/tests/" + testDirName + "/";
            string2 = defaultPackageName + scriptFileName;
        }
        testBase = scriptFileName.substring(0, scriptFileName.lastIndexOf("." + testType));
        if (testType.equals("java") || testType.equals("junit")) {
            object3 = defaultPackageName.replace('/', '.');
            int n2 = ((String)object3).length() - 1;
            String string3 = javaPath = n2 == 0 ? "" : ((String)object3).substring(1, n2);
        }
        if (runningdir != null && runningdir.length() > 0) {
            if (File.separatorChar == '\\') {
                object3 = RunTest.convertPathForWin(runningdir);
                runDir = new File(new File((String)object3).getCanonicalPath());
            } else {
                runDir = new File(new File(runningdir).getCanonicalPath());
            }
        }
        String string4 = null;
        if (outputdir == null || outputdir.length() == 0) {
            if (File.separatorChar == '\\') {
                string4 = RunTest.convertPathForWin(userdir);
                object3 = new File(new File(string4).getCanonicalPath());
            } else {
                object3 = new File(new File(userdir).getCanonicalPath());
            }
        } else if (File.separatorChar == '\\') {
            object2 = RunTest.convertPathForWin(outputdir);
            object3 = new File(new File((String)object2).getCanonicalPath());
        } else {
            object3 = new File(new File(outputdir).getCanonicalPath());
        }
        if (!isSuiteRun && !framework.startsWith("embedded")) {
            runDir = object3;
            outDir = new File((File)object3, framework);
            outDir.mkdir();
        } else {
            outDir = object3;
            outDir.mkdir();
            if (topsuitedir != null && topsuitedir.length() > 0) {
                if (File.separatorChar == '\\') {
                    object2 = RunTest.convertPathForWin(topsuitedir);
                    tsuiteDir = new File(new File((String)object2).getCanonicalPath());
                } else {
                    tsuiteDir = new File(new File(topsuitedir).getCanonicalPath());
                }
            } else {
                tsuiteDir = outDir;
            }
            tsuiteDir.mkdir();
            if (topreportdir != null && topreportdir.length() > 0) {
                if (File.separatorChar == '\\') {
                    object2 = RunTest.convertPathForWin(topreportdir);
                    rsuiteDir = new File(new File((String)object2).getCanonicalPath());
                } else {
                    rsuiteDir = new File(new File(topreportdir).getCanonicalPath());
                }
            } else {
                rsuiteDir = outDir;
            }
            rsuiteDir.mkdir();
        }
        fileSep = File.separatorChar;
        if (testType.equals("multi") && (mtestdir == null || mtestdir.length() == 0)) {
            mtestdir = outDir.getPath();
        }
        if (!(testType.equals("java") || testType.equals("junit") || testType.equals("unit") || testType.equals("multi"))) {
            FileWriter fileWriter;
            Object object4;
            object2 = RunTest.loadTestResource("tests/" + testDirName + "/" + scriptFileName);
            if (object2 == null) {
                System.out.println("Could not locate " + string);
                RunTest.addToFailures(string);
                throw new FileNotFoundException(string2);
            }
            object = new BufferedReader(new InputStreamReader((InputStream)object2, "UTF-8"));
            if (upgradetest) {
                try {
                    script = new File(new File(userdir, scriptFileName).getCanonicalPath());
                }
                catch (IOException iOException) {
                    object4 = new File(userdir, scriptFileName);
                    fileWriter = new FileWriter((File)object4);
                    fileWriter.close();
                    script = new File(((File)object4).getCanonicalPath());
                }
            } else {
                try {
                    script = new File(new File(outDir, scriptFileName).getCanonicalPath());
                }
                catch (IOException iOException) {
                    object4 = new File(outDir, scriptFileName);
                    fileWriter = new FileWriter((File)object4);
                    fileWriter.close();
                    script = new File(((File)object4).getCanonicalPath());
                }
            }
            PrintWriter printWriter = null;
            printWriter = new PrintWriter((Writer)new BufferedWriter(new FileWriter(script.getPath()), 10000), true);
            object4 = "";
            while ((object4 = ((BufferedReader)object).readLine()) != null) {
                printWriter.println((String)object4);
            }
            printWriter.close();
            printWriter = null;
            object = null;
        }
        baseDir = null;
        if (useCommonDB) {
            if (File.separatorChar == '\\') {
                object2 = RunTest.convertPathForWin(commonDBHome);
                baseDir = new File(string4, (String)object2);
            } else {
                baseDir = new File(userdir, commonDBHome);
            }
        } else if (!useprocess && isSuiteRun && (usesystem == null || usesystem.length() <= 0)) {
            object2 = suiteName.substring(0, suiteName.indexOf(58));
            if (File.separatorChar == '\\') {
                object = RunTest.convertPathForWin((String)object2);
                baseDir = new File(outDir, (String)object);
            } else {
                baseDir = new File(outDir, (String)object2);
            }
        } else if (usesystem != null && usesystem.length() > 0) {
            if (File.separatorChar == '\\') {
                object2 = RunTest.convertPathForWin(usesystem);
                baseDir = upgradetest ? new File(string4, (String)object2) : new File(outDir, (String)object2);
            } else {
                baseDir = upgradetest ? new File(userdir, usesystem) : new File(outDir, usesystem);
            }
        } else if (File.separatorChar == '\\') {
            object2 = RunTest.convertPathForWin(testBase);
            baseDir = new File(outDir, (String)object2);
        } else {
            baseDir = new File(outDir, testBase);
        }
        if (baseDir.exists()) {
            if (!useCommonDB || lastTestFailed) {
                RunTest.cleanupBaseDir(baseDir);
                lastTestFailed = false;
            } else if (useCommonDB) {
                dbIsNew = false;
            }
        } else {
            boolean bl = baseDir.mkdir();
            dbIsNew = true;
        }
        deleteBaseDir = usesystem == null || usesystem.length() <= 0;
        if (testOutName == null) {
            testOutName = testBase;
        }
        tmpOutFile = new File(outDir, testOutName + ".tmp");
        tempMasterName = testOutName + ".tmpmstr";
        UTF8OutName = testOutName + ".utf8out";
        finalOutFile = new File(outDir, testOutName + ".out");
        diffFile = new File(outDir, testOutName + ".diff");
        stdOutFile = new File(outDir, testOutName + ".std");
        if (isSuiteRun) {
            String string5 = suiteName.substring(0, suiteName.indexOf(":"));
            passFileName = string5 + ".pass";
            passFile = new File(rsuiteDir, passFileName);
            failFileName = string5 + ".fail";
            failFile = new File(rsuiteDir, failFileName);
        } else {
            passFileName = testBase + ".pass";
            passFile = new File(outDir, passFileName);
            failFileName = testBase + ".fail";
            failFile = new File(outDir, failFileName);
        }
        boolean bl = true;
        if (tmpOutFile.exists()) {
            bl = tmpOutFile.delete();
        }
        if ((tempMasterFile = new File(outDir, tempMasterName)).exists()) {
            bl = tempMasterFile.delete();
        }
        if (finalOutFile.exists()) {
            bl = finalOutFile.delete();
        }
        if (diffFile.exists()) {
            bl = diffFile.delete();
        }
        if (stdOutFile.exists()) {
            bl = stdOutFile.delete();
        }
        if ((UTF8OutFile = new File(outDir, UTF8OutName)).exists()) {
            bl = UTF8OutFile.delete();
        }
        if (!isSuiteRun) {
            if (failFile.exists()) {
                bl = failFile.delete();
            }
            if (passFile.exists()) {
                bl = passFile.delete();
            }
        }
        if (!bl) {
            System.out.println("Unable to delete tmp, out and/or diff files to start");
        }
        pwDiff = new PrintWriter((Writer)new BufferedWriter(new FileWriter(diffFile.getPath()), 4096), true);
    }

    private static JavaVersionHolder getProperties(Properties properties) throws Exception {
        String string;
        String string2;
        String string3;
        String string4;
        Object object;
        Object object2;
        String string5;
        Object object3;
        Object object4;
        String string6;
        Object object5;
        String string7;
        String string8;
        Object object6;
        if (jvmflags != null && jvmflags.length() > 0) {
            object6 = new StringTokenizer(jvmflags, "^");
            while (((StringTokenizer)object6).hasMoreTokens()) {
                string8 = ((StringTokenizer)object6).nextToken();
                if (string8.indexOf("=") <= 0 || !string8.startsWith("-D")) continue;
                string7 = string8.substring(2, string8.indexOf("="));
                object5 = string8.substring(string8.indexOf("=") + 1, string8.length());
                properties.put(string7, object5);
            }
        }
        searchCP = properties.getProperty("ij.searchClassPath");
        object6 = properties.getProperty("framework");
        if (object6 != null) {
            framework = object6;
        }
        if (framework == null) {
            framework = "embedded";
        }
        if (!RunTest.verifyFramework(framework)) {
            framework = "";
        } else {
            driverName = NetServer.getDriverName(framework);
        }
        string8 = properties.getProperty("derbyTesting.xa.single");
        if (string8 != null && string8.equals("true")) {
            junitXASingle = true;
        }
        if ((hostName = properties.getProperty("hostName")) == null) {
            hostName = "localhost";
        }
        if ((string7 = properties.getProperty("generateUTF8Out")) != null && string7.equals("true")) {
            generateUTF8Out = true;
        }
        object5 = framework + ".exclude";
        if (!framework.equals("")) {
            skiptest = SkipTest.skipIt((String)object5, scriptName);
            if (!skiptest && !hostName.equals("localhost")) {
                object5 = framework + "Remote.exclude";
                skiptest = SkipTest.skipIt((String)object5, scriptName);
            }
            if (skiptest) {
                RunTest.addSkiptestReason("Test skipped: listed in " + (String)object5 + " file, skipping test: " + scriptName);
            }
        }
        javaVersion = (jvmName = properties.getProperty("jvm")) == null || jvmName.length() == 0 || jvmName.equals("jview") ? System.getProperty("java.specification.version") : jvmName;
        String string9 = properties.getProperty("java.vm.name").equals("J9") ? properties.getProperty("java.vm.version") : javaVersion;
        JavaVersionHolder javaVersionHolder = new JavaVersionHolder(string9);
        majorVersion = javaVersionHolder.getMajorVersion();
        minorVersion = javaVersionHolder.getMinorVersion();
        iminor = javaVersionHolder.getMinorNumber();
        imajor = javaVersionHolder.getMajorNumber();
        if (jvmName == null || !jvmName.equals("jview")) {
            if (iminor < 2 && imajor < 2) {
                jvmName = "currentjvm";
            } else if (System.getProperty("java.vm.vendor").startsWith("IBM")) {
                if (System.getProperty("java.vm.name").equals("J9")) {
                    if (System.getProperty("com.ibm.oti.configuration").equals("foun10")) {
                        jvmName = "j9_foundation";
                    } else if (System.getProperty("com.ibm.oti.configuration").equals("foun11")) {
                        jvmName = "j9_foundation11";
                    } else if (System.getProperty("com.ibm.oti.configuration").equals("dee")) {
                        jvmName = "j9dee15";
                    } else {
                        javaVersion = javaVersion + " - " + majorVersion + "." + minorVersion;
                        if (imajor <= 2 && iminor < 2) {
                            majorVersion = "1";
                            minorVersion = "3";
                            imajor = 1;
                            iminor = 3;
                        }
                        jvmName = "j9_" + majorVersion + minorVersion;
                    }
                } else {
                    jvmName = "ibm" + majorVersion + minorVersion;
                }
            } else {
                jvmName = "jdk" + majorVersion + minorVersion;
            }
        }
        String string10 = properties.getProperty("java.specification.version");
        JavaVersionHolder javaVersionHolder2 = new JavaVersionHolder(string10);
        testEncoding = properties.getProperty("derbyTesting.encoding");
        upgradejarpath = properties.getProperty("derbyTesting.jar.path");
        if (testEncoding != null && !jvmName.equals("jdk15")) {
            skiptest = true;
            RunTest.addSkiptestReason("derbyTesting.encoding can only be used with jdk15, skipping test");
        }
        replacePolicyFile = (string6 = properties.getProperty("derbyTesting.replacePolicyFile")) != null && string6.equals("true");
        javaCmd = properties.getProperty("javaCmd");
        bootcp = properties.getProperty("bootcp");
        jvmflags = properties.getProperty("jvmflags");
        testJavaFlags = properties.getProperty("testJavaFlags");
        classpath = properties.getProperty("classpath");
        classpathServer = properties.getProperty("classpathServer");
        if (classpathServer == null || classpathServer.startsWith("${")) {
            classpathServer = classpath;
        }
        jarfile = properties.getProperty("jarfile");
        String string11 = properties.getProperty("upgradetest");
        if (string11 != null && (string11 = string11.toLowerCase()).equals("true")) {
            upgradetest = true;
        }
        if (framework.equals("DerbyNet") && !jvmName.startsWith("j9_foundation")) {
            object4 = null;
            object3 = null;
            string5 = null;
            object2 = null;
            try {
                object4 = Class.forName("com.ibm.db2.jcc.DB2Driver");
                string5 = ((Class)object4).getConstructor(new Class[0]).newInstance(new Object[0]);
                object3 = ((Class)object4).getMethod("getMajorVersion", null);
                object2 = (Integer)((Method)object3).invoke((Object)string5, null);
                jccMajor = (Integer)object2;
                object3 = ((Class)object4).getMethod("getMinorVersion", null);
                object2 = (Integer)((Method)object3).invoke((Object)string5, null);
                jccMinor = (Integer)object2;
            }
            catch (ClassNotFoundException classNotFoundException) {
                // empty catch block
            }
            object = properties.getProperty("excludeJCC");
            try {
                RunList.checkClientExclusion((String)object, "JCC", jccMajor, jccMinor, javaVersion);
            }
            catch (Exception exception) {
                skiptest = true;
                RunTest.addSkiptestReason(exception.getMessage());
            }
        }
        if ((object4 = properties.getProperty("systemdiff")) != null && ((String)(object4 = ((String)object4).toLowerCase())).equals("true")) {
            systemdiff = true;
        }
        if ((object3 = properties.getProperty("keepfiles")) != null && ((String)(object3 = ((String)object3).toLowerCase())).equals("true")) {
            keepfiles = true;
        }
        if ((string5 = properties.getProperty("encryption")) != null && string5.equalsIgnoreCase("true")) {
            encryption = true;
        }
        if ((object2 = properties.getProperty("jdk12exttest")) != null && ((String)object2).equalsIgnoreCase("true")) {
            jdk12exttest = true;
        }
        if (encryption || jdk12exttest) {
            if (iminor < 2) {
                skiptest = true;
                RunTest.addSkiptestReason("Test skipped: encryption or jdk12exttest requires jdk12 or higher; this is jdk1" + iminor + ", skipping test: " + scriptFileName);
            } else {
                try {
                    object = Class.forName("javax.transaction.xa.Xid");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    skiptest = true;
                    RunTest.addSkiptestReason("Test skipped: javax.transaction.xa.Xid not found, skipping test: " + scriptFileName);
                }
                try {
                    object = Class.forName("javax.sql.RowSet");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    skiptest = true;
                    RunTest.addSkiptestReason("Test skipped: javax.sql.RowSet not found, skipping test: " + scriptFileName);
                }
            }
        }
        if ((runningdir = properties.getProperty("rundir")) == null) {
            runningdir = "";
        }
        if ((outputdir = properties.getProperty("outputdir")) == null) {
            outputdir = "";
        }
        canondir = properties.getProperty("canondir");
        canonpath = properties.getProperty("canonpath");
        testOutName = properties.getProperty("testoutname");
        useOutput = Boolean.valueOf(properties.getProperty("useoutput", "true"));
        outcopy = Boolean.valueOf(properties.getProperty("outcopy", "false"));
        mtestdir = properties.getProperty("mtestdir");
        if (mtestdir == null) {
            mtestdir = "";
        }
        useprocess = (object = properties.getProperty("useprocess")) != null ? !((String)(object = ((String)object).toLowerCase())).equals("false") : true;
        if (!hostName.equals("localhost")) {
            startServer = false;
        }
        if ((string4 = properties.getProperty("skipsed")) != null && (string4 = string4.toLowerCase()).equals("true")) {
            skipsed = true;
        }
        if ((string3 = properties.getProperty("verbose")) != null && (string3 = string3.toLowerCase()).equals("true")) {
            verbose = true;
        }
        if ((string2 = properties.getProperty("reportstderr")) != null && (string2 = string2.toLowerCase()).equals("false")) {
            reportstderr = false;
        }
        if (timeoutStr == null) {
            timeoutStr = properties.getProperty("timeout", "-1");
        }
        try {
            timeout = Integer.parseInt(timeoutStr);
        }
        catch (NumberFormatException numberFormatException) {
            timeout = -1;
        }
        testSpecialProps = properties.getProperty("testSpecialProps");
        if (useprocess) {
            string = properties.getProperty("ij.defaultResourcePackage");
            if (string != null && !(defaultPackageName = string).endsWith("/")) {
                defaultPackageName = defaultPackageName + "/";
            }
            usesystem = properties.getProperty("usesystem");
        }
        if (!useprocess && !skiptest) {
            string = null;
            string = suiteName != null ? suiteName : properties.getProperty("suitename");
            if (string != null && string.length() > 0) {
                object5 = framework + "Useprocess.exclude";
                if (!framework.equals("") && (skiptest = SkipTest.skipIt((String)object5, scriptName))) {
                    skiptest = true;
                    RunTest.addSkiptestReason("Test " + scriptName + " skipped, listed in " + framework + "Useprocess.exclude file.");
                }
            }
        }
        if (useprocess || suiteName == null) {
            if (useprocess) {
                suiteName = properties.getProperty("suitename");
            }
            if (suiteName != null && suiteName.length() > 0) {
                isSuiteRun = true;
                if (useprocess) {
                    topsuiteName = properties.getProperty("topsuitename");
                }
                topsuitedir = properties.getProperty("topsuitedir");
                topreportdir = properties.getProperty("topreportdir");
            }
        }
        if ((string = properties.getProperty("useCommonDB")) != null && string.equals("true")) {
            useCommonDB = true;
        }
        return javaVersionHolder2;
    }

    private static String createPropString(AppsRequiredPassword appsRequiredPassword) throws ClassNotFoundException, FileNotFoundException, IOException {
        String string;
        String string2;
        Object object;
        Object object2;
        Object object3;
        Object object4;
        Object object5;
        Object object6;
        Object object7;
        String string3 = "";
        Object var2_2 = null;
        BufferedOutputStream bufferedOutputStream = null;
        Object var4_4 = null;
        String string4 = "";
        InputStream inputStream = null;
        InputStream inputStream2 = null;
        InputStream inputStream3 = null;
        InputStream inputStream4 = null;
        String string5 = "tests/" + testDirName + "/default_derby.properties";
        String string6 = null;
        string6 = useCommonDB ? "tests/" + testDirName + "/commonDB_app.properties" : "tests/" + testDirName + "/default_app.properties";
        Properties properties = new Properties();
        Properties properties2 = new Properties();
        Properties properties3 = new Properties();
        Properties properties4 = new Properties();
        if (testSpecialProps != null && testSpecialProps.length() > 0) {
            SpecialFlags.parse(testSpecialProps, properties3, properties4);
        }
        inputStream2 = RunTest.loadTestResource(string5);
        inputStream = RunTest.loadTestResource("tests/" + testDirName + "/" + testBase + "_derby.properties");
        if (inputStream != null) {
            properties.load(inputStream);
            properties.list(System.out);
        } else if (inputStream2 != null) {
            properties.load(inputStream2);
        }
        if (jvmName.startsWith("j9") && !jvmName.equalsIgnoreCase("j9dee15") && properties.getProperty("derby.language.statementCacheSize") == null) {
            properties.put("derby.language.statementCacheSize", J9_STATEMENTCACHESIZE);
        }
        if (properties.isEmpty()) {
            if (!properties4.isEmpty()) {
                properties = properties4;
            }
        } else if (!properties4.isEmpty()) {
            object7 = properties4.propertyNames();
            while (object7.hasMoreElements()) {
                object6 = (String)object7.nextElement();
                object5 = properties4.getProperty((String)object6);
                if (((String)object6).equals("derby.debug.true") && (object4 = properties.getProperty("derby.debug.true")) != null) {
                    object5 = ((String)object4).length() != 0 ? (String)object5 + "," + (String)object4 : "";
                }
                properties.put(object6, object5);
            }
        }
        if (!properties.isEmpty()) {
            try {
                clPropFile = new File(new File(baseDir, "derby.properties").getCanonicalPath());
            }
            catch (IOException iOException) {
                object6 = new File(baseDir, "derby.properties");
                object5 = new FileWriter((File)object6);
                ((OutputStreamWriter)object5).close();
                clPropFile = new File(((File)object6).getCanonicalPath());
            }
            bufferedOutputStream = new BufferedOutputStream(new FileOutputStream(clPropFile));
            properties.store(bufferedOutputStream, "Derby Properties");
            bufferedOutputStream.close();
            object7 = properties.getProperty("derby.connection.requireAuthentication");
            if (object7 != null && ((String)object7).equals("true") && (object6 = properties.getProperty("derby.user.app")) != null) {
                appsRequiredPassword.password = object6;
            }
        }
        isSed = testType.equals("multi") ? RunTest.loadTestResource("multi/stress/" + testBase + "_sed.properties") : RunTest.loadTestResource("tests/" + testDirName + "/" + testBase + "_sed.properties");
        object7 = new Properties();
        object6 = null;
        object5 = null;
        object6 = useCommonDB ? "CDB" + testBase + "_app.properties" : testBase + "_app.properties";
        inputStream4 = RunTest.loadTestResource(string6);
        inputStream3 = testType.equals("multi") ? RunTest.loadTestResource("multi/" + testDirName + "/" + testBase + "_app.properties") : RunTest.loadTestResource("tests/" + testDirName + "/" + testBase + "_app.properties");
        if (inputStream3 != null) {
            properties2.load(inputStream3);
            object4 = properties2.propertyNames();
            while (object4.hasMoreElements()) {
                object3 = (String)object4.nextElement();
                object2 = properties2.getProperty((String)object3);
                if (!((String)object3).equals("usedefaults") || !((String)object2).equals("true") || inputStream4 == null) continue;
                ((Properties)object7).load(inputStream4);
                RunTest.mergeProps(properties2, (Properties)object7);
                break;
            }
        } else if (inputStream4 != null) {
            properties2.load(inputStream4);
        }
        if (properties2.isEmpty()) {
            if (!properties3.isEmpty()) {
                properties2 = properties3;
            }
        } else if (!properties3.isEmpty()) {
            object4 = properties3.propertyNames();
            while (object4.hasMoreElements()) {
                object3 = (String)object4.nextElement();
                object2 = properties3.getProperty((String)object3);
                properties2.put(object3, object2);
            }
        }
        if (!properties2.isEmpty()) {
            try {
                appPropFile = new File(new File(baseDir, (String)object6).getCanonicalPath());
            }
            catch (IOException iOException) {
                object3 = new File(baseDir, (String)object6);
                object2 = new FileWriter((File)object3);
                ((OutputStreamWriter)object2).close();
                appPropFile = new File(((File)object3).getCanonicalPath());
            }
            object4 = System.getProperty("console.encoding");
            object3 = System.getProperty("file.encoding");
            if (properties2.getProperty("derby.ui.codeset") != null) {
                codeset = properties2.getProperty("derby.ui.codeset");
            } else if (isI18N) {
                properties2.put("derby.ui.codeset", "UTF-8");
            } else if (object4 != null && object3 != null && ((String)object4).startsWith("Cp850")) {
                properties2.put("derby.ui.codeset", object3);
            }
            if (verbose) {
                System.out.println("console.encoding:" + (String)object4 + " file.encoding:" + (String)object3 + " derby.ui.codeset: " + properties2.getProperty("derby.ui.codeset"));
            }
            if (System.getProperty("ij.dataSource") != null) {
                properties2.remove("ij.database");
                properties2.remove("ij.protocol");
            }
            bufferedOutputStream = new BufferedOutputStream(new FileOutputStream(appPropFile));
            properties2.store(bufferedOutputStream, "App Properties");
            bufferedOutputStream.close();
            object2 = properties2.getProperty("jvmflags");
            if (object2 != null) {
                jvmflags = jvmflags != null && jvmflags.length() > 0 ? (String)object2 + "^" + jvmflags : object2;
            }
            if (jvmflags != null && jvmflags.length() > 0) {
                object = new StringTokenizer(jvmflags, "^");
                while (((StringTokenizer)object).hasMoreTokens()) {
                    string2 = ((StringTokenizer)object).nextToken();
                    if (string2.indexOf("=") <= 0 || !string2.startsWith("-D")) continue;
                    string = string2.substring(2, string2.indexOf("="));
                    String string7 = string2.substring(string2.indexOf("=") + 1, string2.length());
                    properties2.put(string, string7);
                }
            }
            if (framework.length() > 0 || encryption) {
                try {
                    if (!framework.equals("") && !framework.equals("embedded")) {
                        RunTest.frameworkProtocol(properties2);
                    } else if (encryption) {
                        RunTest.encryptionProtocol(properties2);
                    }
                }
                catch (Exception exception) {
                    System.out.println("Exception: " + exception.getMessage());
                    exception.printStackTrace();
                }
                appPropFile = new File(baseDir, testBase + "_app.properties");
                try {
                    bufferedOutputStream = new BufferedOutputStream(new FileOutputStream(appPropFile));
                    properties2.store(bufferedOutputStream, "Test Properties");
                    bufferedOutputStream.close();
                }
                catch (IOException iOException) {
                    System.out.println("IOException creating prop file: " + iOException.getMessage());
                }
            }
        }
        if (appPropFile != null && appPropFile.exists()) {
            string3 = appPropFile.getPath();
            shutdownurl = properties2.getProperty("shutdown");
            object4 = properties2.getProperty("jdk12test");
            if (object4 != null && ((String)object4).toLowerCase().equals("true")) {
                isjdk12test = true;
                if (jvmName.equals("currentjvm")) {
                    skiptest = true;
                    RunTest.addSkiptestReason("Test skipped: test needs jdk12, jvm is reporting currentjvm; skipping test: " + scriptFileName);
                }
            }
            if ((object3 = System.getProperty("serverJvm")) != null) {
                jvmnet = true;
            }
            object2 = properties2.getProperty("excludeJCC");
            if (framework.equals("DerbyNet")) {
                try {
                    RunList.checkClientExclusion((String)object2, "JCC", jccMajor, jccMinor, javaVersion);
                }
                catch (Exception exception) {
                    skiptest = true;
                    RunTest.addSkiptestReason(exception.getMessage());
                }
            }
            object = jvmName;
            if (jvmName.startsWith("j9")) {
                object = jvmName.equals("j9_foundation") ? "foundation" : (jvmName.equals("j9_foundation11") ? "foundation" : (jvmName.equalsIgnoreCase("j9dee15") ? "j9dee15" : "j9"));
            }
            if ((runwithjvm = properties2.getProperty("runwith" + (String)object)) != null && runwithjvm.equalsIgnoreCase("false")) {
                skiptest = true;
                RunTest.addSkiptestReason("Test skipped: test cannot run with jvm: " + jvmName + ".  " + scriptFileName);
            }
            if ((string2 = properties2.getProperty("startServer")) != null && string2.equalsIgnoreCase("false")) {
                startServer = false;
            }
            if (testEncoding == null) {
                testEncoding = properties2.getProperty("derbyTesting.encoding");
                if (jvmName.equals("jdk15") && testEncoding != null) {
                    jvmflags = (String)(jvmflags == null ? "" : jvmflags + " ") + "-Dfile.encoding=" + testEncoding;
                    properties2.put("file.encoding", testEncoding);
                }
            }
            if (!replacePolicyFile) {
                string = properties2.getProperty("derbyTesting.replacePolicyFile");
                replacePolicyFile = string != null && string.equals("true");
            }
            if (NetServer.isJCCConnection(framework) || "true".equalsIgnoreCase(properties2.getProperty("noSecurityManager"))) {
                runWithoutSecurityManager = true;
            }
            boolean bl = (string = properties2.getProperty("supportfiles")) != null && string.length() > 0;
            boolean bl2 = Boolean.valueOf(properties2.getProperty("useextdirs", "false"));
            if (bl || bl2) {
                File file;
                File file2 = null;
                file2 = testType.equals("sql2") ? (isSuiteRun || framework.length() > 0 ? outDir : (runDir != null && runDir.exists() ? runDir : outDir)) : (testType.equals("multi") ? (isSuiteRun || mtestdir == null || mtestdir.length() == 0 ? outDir : (file = new File(mtestdir))) : (outcopy ? outDir : (runDir != null && runDir.exists() ? runDir : outDir)));
                if (bl2) {
                    extInDir = file2;
                    extInDir = new File(file2, "extin");
                    if (!extInDir.exists()) {
                        extInDir.mkdirs();
                    }
                    if (!(extOutDir = new File(file2, "extout")).exists()) {
                        extOutDir.mkdirs();
                    }
                    if (!(extInOutDir = new File(file2, "extinout")).exists()) {
                        extInOutDir.mkdirs();
                    }
                    file2 = extInDir;
                }
                if (bl) {
                    CopySuppFiles.copyFiles(file2, string);
                }
            } else {
                extInDir = null;
                extOutDir = null;
                extInOutDir = null;
            }
        }
        return string3;
    }

    public static String setTestJavaFlags(String string) {
        StringBuffer stringBuffer = new StringBuffer();
        if (verbose) {
            System.out.println("testJavaflags: " + string);
        }
        String string2 = "-D";
        try {
            string2 = jvm.getJvm(jvmName).getDintro();
        }
        catch (Exception exception) {
            System.out.println("Problem getting jvm " + jvmName + " Dintro: ");
            exception.printStackTrace(System.out);
            System.exit(1);
        }
        StringTokenizer stringTokenizer = new StringTokenizer(string, "^");
        while (stringTokenizer.hasMoreTokens()) {
            String string3 = stringTokenizer.nextToken();
            if (!string3.startsWith("-")) {
                stringBuffer.append(string2);
            }
            stringBuffer.append(string3);
            stringBuffer.append(" ");
        }
        if (verbose) {
            System.out.println("setTestJavaFlags returning: " + stringBuffer.toString());
        }
        return stringBuffer.toString();
    }

    private static void loadProps(Properties properties, File file) throws Exception {
        if (file.canRead()) {
            FileInputStream fileInputStream = new FileInputStream(file);
            properties.load(fileInputStream);
            fileInputStream.close();
        }
    }

    private static void mergeProps(Properties properties, Properties properties2) {
        Enumeration<?> enumeration = properties2.propertyNames();
        while (enumeration.hasMoreElements()) {
            String string = (String)enumeration.nextElement();
            properties.put(string, properties2.getProperty(string));
        }
    }

    private static void frameworkProtocol(Properties properties) throws Exception {
        if (properties == null) {
            return;
        }
        Object object = properties.propertyNames();
        while (object.hasMoreElements()) {
            String string = (String)object.nextElement();
            String string2 = properties.getProperty(string);
            if (string.equals("driver") || string.equals("ij.driver") || string.equals("jdbc.drivers")) {
                properties.put(string, driverName);
                continue;
            }
            if (string.startsWith("ij.protocol") || string.equals("protocol")) {
                string2 = NetServer.alterURL(framework, string2);
                properties.put(string, string2);
                continue;
            }
            if (string.equals("database") || string.equals("ij.database") || string.startsWith("ij.connection") || string.equals("jdbc.url")) {
                dbName = string2.substring(string2.lastIndexOf(58) + 1, string2.length());
                string2 = NetServer.alterURL(framework, string2);
                properties.put(string, string2);
                continue;
            }
            properties.put(string, string2);
        }
        if (NetServer.isJCCConnection(framework)) {
            object = System.getProperty("ij.user");
            if (object == null) {
                object = "APP";
            }
            properties.put("ij.user", object);
        }
        if (NetServer.isClientConnection(framework)) {
            object = System.getProperty("ij.password");
            if (object == null) {
                object = "APP";
            }
            properties.put("ij.password", object);
        }
        if (NetServer.isJCCConnection(framework)) {
            properties.put("ij.retrieveMessagesFromServerOnGetMessage", "true");
        }
        if (driverName != null) {
            properties.put("ij.driver", driverName);
        }
    }

    private static void encryptionProtocol(Properties properties) throws Exception {
        Object object = "dataEncryption=true;bootPassword=Thursday";
        if (properties == null) {
            return;
        }
        String string = properties.getProperty("testEncryptionAlgorithm");
        if (string != null) {
            object = (String)object + ";encryptionAlgorithm=" + string;
        }
        if ((string = properties.getProperty("testEncryptionProvider")) != null) {
            object = (String)object + ";encryptionProvider=" + string;
        }
        Enumeration<?> enumeration = properties.propertyNames();
        while (enumeration.hasMoreElements()) {
            String string2 = (String)enumeration.nextElement();
            Object object2 = properties.getProperty(string2);
            if (string2.equals("database") || string2.equals("ij.database") || string2.startsWith("ij.connection") || string2.equals("jdbc.url")) {
                int n = ((String)object2).indexOf((String)object);
                if (n == -1) {
                    object2 = (String)object2 + ";" + (String)object;
                }
                properties.put(string2, object2);
                continue;
            }
            if (string2.equals("testEncryptionAlgorithm") || string2.equals("testEncryptionProvider")) continue;
            properties.put(string2, object2);
        }
    }

    private static void cleanupBaseDir(File file) {
        boolean bl = false;
        if (usesystem == null || usesystem.length() == 0) {
            bl = true;
        } else if (usesystem.equals("nist")) {
            if (testBase.equals("schema1")) {
                bl = true;
            }
        } else if (usesystem.equals("puzzles") && testBase.equals("puzzleschema")) {
            bl = true;
        }
        if (useCommonDB) {
            bl = false;
        }
        if (bl) {
            RunTest.deleteFile(file);
            if (file.exists()) {
                System.out.println("baseDir did not get deleted which could cause test failures");
            } else {
                file.mkdir();
            }
        }
    }

    private static void doCleanup(String string) throws IOException {
        boolean bl = true;
        if (script != null && script.exists() && !keepfiles) {
            bl = script.delete();
        }
        String string2 = CurrentTime.getTime();
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("*** End:   " + testBase + " jdk" + string + " ");
        if (framework.length() > 0 && !framework.startsWith("embedded")) {
            stringBuffer.append(framework + " ");
        }
        if (suiteName != null && suiteName.length() > 0) {
            stringBuffer.append(suiteName + " ");
        }
        stringBuffer.append(string2 + " ***");
        System.out.println(stringBuffer.toString());
        pwDiff.println(stringBuffer.toString());
        pwDiff.flush();
        pwDiff.close();
        pwDiff = null;
        if (!keepfiles) {
            bl = tmpOutFile.delete();
            if (!bl) {
                tmpOutFile = null;
            }
            bl = finalOutFile.delete();
            if (!skiptest) {
                bl = diffFile.delete();
            }
            tempMasterFile = new File(outDir, tempMasterName);
            bl = tempMasterFile.delete();
            UTF8OutFile = new File(outDir, UTF8OutName);
            bl = UTF8OutFile.delete();
            File file = new File(userdir, "derby_tests.policy");
            if (file.exists()) {
                bl = file.delete();
            }
            if (deleteBaseDir) {
                if (!useCommonDB) {
                    RunTest.deleteFile(baseDir);
                } else {
                    bl = appPropFile.delete();
                }
                if (extInDir != null) {
                    RunTest.deleteFile(extInDir);
                }
                if (extOutDir != null) {
                    RunTest.deleteFile(extOutDir);
                }
                if (extInOutDir != null) {
                    RunTest.deleteFile(extInOutDir);
                }
            }
        }
        keepfiles = false;
    }

    public static void deleteFile(File file) {
        boolean bl = true;
        if (file == null) {
            System.out.println(file.getName() + " is null");
            return;
        }
        if (!file.exists()) {
            System.out.println(file.getName() + " does not exist; harness error");
            return;
        }
        bl = file.delete();
        if (bl) {
            return;
        }
        if (!file.isDirectory()) {
            System.out.println("Could not delete file " + file.getName() + ", going on");
            return;
        }
        String[] stringArray = file.list();
        for (int i = 0; i < stringArray.length; ++i) {
            File file2 = new File(file.getPath(), stringArray[i]);
            if (file2 == null || (bl = file2.delete()) || !file2.isDirectory()) continue;
            RunTest.deleteFile(file2);
            bl = file2.delete();
        }
        bl = file.delete();
        if (!bl) {
            System.out.println("Warning: Cleanup failed on baseDir: " + file.getPath());
        }
    }

    static void addToFailures(String string) throws IOException {
        if (failFileName == null) {
            failFileName = isSuiteRun ? suiteName + ".fail" : testBase + ".fail";
        }
        RunTest.addToListFile(failFileName, string);
    }

    static void addToSuccesses(String string) throws IOException {
        if (passFileName == null) {
            passFileName = isSuiteRun ? suiteName + ".pass" : testBase + ".pass";
        }
        RunTest.addToListFile(passFileName, string);
    }

    static void addToListFile(String string, String string2) throws IOException {
        File file = isSuiteRun ? new File(rsuiteDir, string) : new File(outDir, string);
        PrintStream printStream = null;
        try {
            printStream = new PrintStream(new FileOutputStream(file.getCanonicalPath(), true));
        }
        catch (IOException iOException) {
            FileWriter fileWriter = new FileWriter(file);
            fileWriter.close();
            printStream = new PrintStream(new FileOutputStream(file.getCanonicalPath(), true));
        }
        printStream.println(string2);
        printStream.flush();
        printStream.close();
    }

    static void appendStderr(BufferedOutputStream bufferedOutputStream, InputStream inputStream) throws IOException {
        PrintWriter printWriter = new PrintWriter(bufferedOutputStream);
        BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(inputStream, "UTF-8"));
        String string = null;
        boolean bl = false;
        while ((string = bufferedReader.readLine()) != null) {
            printWriter.println(string);
        }
        bufferedReader.close();
        printWriter.flush();
    }

    static void verifyTestType() throws ClassNotFoundException, FileNotFoundException, IOException {
        InputStream inputStream = RunTest.loadTestResource("harness/testtypes.properties");
        Properties properties = new Properties();
        properties.load(inputStream);
        String string = properties.getProperty("testtypes");
        StringTokenizer stringTokenizer = new StringTokenizer(string, ",");
        String string2 = "";
        while (stringTokenizer.hasMoreTokens()) {
            string2 = stringTokenizer.nextToken();
            if (!testType.equals(string2)) continue;
            return;
        }
        System.out.println("Unknown test type: " + testType);
        System.exit(1);
    }

    public static void addStandardTestJvmProps(Vector<String> vector, String string, String string2, jvm jvm2) {
        if (string == null || string.length() == 0) {
            string = string2;
        }
        vector.addElement("derby.system.home=" + string);
        vector.addElement("derby.infolog.append=true ");
    }

    private static String[] buildTestCommand(String string, String string2, String string3) throws FileNotFoundException, IOException, Exception {
        String[] stringArray;
        Object object;
        Vector<String> vector;
        RunTest.composePolicyFile();
        String string4 = "";
        if (testType.equals("sql")) {
            string4 = "ij";
        }
        jvm jvm2 = null;
        jvm2 = jvm.getJvm(jvmName);
        if (javaCmd != null) {
            jvm2.setJavaCmd(javaCmd);
        }
        if (classpath != null && classpath.length() > 0) {
            jvm2.setClasspath(classpath);
        }
        Vector<String> vector2 = new Vector<String>();
        if (testType.equals("java")) {
            RunTest.addStandardTestJvmProps(vector2, string2, outDir.getCanonicalPath(), null);
        } else if (runDir != null && runDir.exists()) {
            RunTest.addStandardTestJvmProps(vector2, string2, runDir.getCanonicalPath(), jvm2);
        } else {
            RunTest.addStandardTestJvmProps(vector2, string2, outDir.getCanonicalPath(), jvm2);
        }
        if (testJavaFlags != null && testJavaFlags.length() > 0) {
            vector = RunTest.setTestJavaFlags(testJavaFlags);
            object = new StringTokenizer((String)((Object)vector), " ");
            while (((StringTokenizer)object).hasMoreTokens()) {
                jvmflags = (jvmflags == null ? "" : jvmflags) + " " + ((StringTokenizer)object).nextToken();
            }
        }
        if (string4.startsWith("ij")) {
            vector2.addElement("ij.defaultResourcePackage=" + defaultPackageName);
        }
        if (framework != null) {
            vector2.addElement("framework=" + framework);
            if (hostName != null && !hostName.equals("localhost")) {
                vector2.addElement("hostName=" + hostName);
            }
        }
        if (junitXASingle) {
            vector2.addElement("derbyTesting.xa.single=true");
        }
        if (testEncoding != null && jvmName.equals("jdk15")) {
            vector2.addElement("derbyTesting.encoding=" + testEncoding);
            vector2.addElement("file.encoding=" + testEncoding);
            jvmflags = (String)(jvmflags == null ? "" : jvmflags + " ") + "-Dfile.encoding=" + testEncoding;
        } else if (isI18N) {
            vector2.addElement("file.encoding=UTF-8");
            jvmflags = (String)(jvmflags == null ? "" : jvmflags + " ") + "-Dfile.encoding=UTF-8";
        }
        if (upgradejarpath != null) {
            vector2.addElement("derbyTesting.jar.path=" + upgradejarpath);
        }
        if (jvmflags != null && jvmflags.length() > 0) {
            if (jvmflags.indexOf("^") > 0) {
                jvmflags = RunTest.spaceJvmFlags(jvmflags);
            }
            jvm2.setFlags(jvmflags);
        }
        if (testType.equals("multi")) {
            if (jvmflags != null && jvmflags.indexOf("mx") == -1 && jvmflags.indexOf("Xmx") == -1) {
                jvm2.setMx(0x4000000L);
            }
            vector2.addElement("encryption=" + encryption);
            vector = new Properties();
            SpecialFlags.parse(testSpecialProps, vector, new Properties());
            object = ((Properties)((Object)vector)).getProperty("testEncryptionAlgorithm");
            if (object != null) {
                vector2.addElement("encryptionAlgorithm=\"encryptionAlgorithm=" + (String)object + "\"");
            }
        }
        jvm2.setD(vector2);
        if (!runWithoutSecurityManager) {
            jvm2.setSecurityProps();
        } else {
            System.out.println("-- SecurityManager not installed --");
        }
        vector = jvm2.getCommandLine();
        boolean bl = JVMInfo.isModuleAware();
        if (bl) {
            vector.add("-p");
            vector.add(JVMInfo.getSystemModulePath());
            vector.add("--add-modules");
            vector.add("org.apache.derby.tests,org.apache.derby.tools,junit");
        }
        if (string4.startsWith("ij")) {
            stringArray = System.getProperty("platform.notASCII");
            if (isI18N) {
                vector.addElement("-Dconsole.encoding=UTF-8");
            } else if (stringArray == null || stringArray.equals("false")) {
                vector.addElement("-Dconsole.encoding=Cp1252");
            }
            String string5 = "org.apache.derby.tools." + string4;
            if (bl) {
                vector.add("-m");
                vector.add("org.apache.derby.tools/" + string5);
            } else {
                vector.addElement(string5);
            }
            if (string4.equals("ij")) {
                vector.addElement("-f");
                vector.addElement(outDir.toString() + File.separatorChar + scriptFileName);
            }
            vector.addElement("-p");
            vector.addElement(string);
        } else if (testType.equals("java")) {
            String[] stringArray2 = stringArray = javaPath.length() > 0 ? javaPath + "." + testBase : testBase;
            if (bl) {
                vector.add("-m");
                vector.add("org.apache.derby.tests/" + (String)stringArray);
            } else {
                vector.addElement((String)stringArray);
            }
            if (string.length() > 0) {
                vector.addElement("-p");
                vector.addElement(string);
            }
        } else if (testType.equals("unit")) {
            vector.addElement("org.apache.derbyTesting.unitTests.harness.UnitTestMain");
            vector.addElement("-p");
            vector.addElement(string);
        } else if (testType.equals("junit")) {
            vector.addElement("junit.textui.TestRunner");
            if (javaPath.length() > 0) {
                vector.addElement(javaPath + "." + testBase);
            } else {
                vector.addElement(testBase);
            }
        } else if (testType.equals("multi")) {
            System.out.println("scriptiflename is: " + scriptFileName);
            vector.addElement("org.apache.derbyTesting.functionTests.harness.MultiTest");
            vector.addElement(scriptFileName);
            vector.addElement("-i");
            vector.addElement(mtestdir);
            vector.addElement("-o");
            vector.addElement(outDir.getPath());
            vector.addElement("-p");
            vector.addElement(string);
        }
        stringArray = new String[vector.size()];
        for (int i = 0; i < vector.size(); ++i) {
            stringArray[i] = vector.elementAt(i);
        }
        return stringArray;
    }

    public static String spaceJvmFlags(String string) {
        Object object = "";
        StringTokenizer stringTokenizer = new StringTokenizer(jvmflags, "^");
        while (stringTokenizer.hasMoreTokens()) {
            object = (String)object + stringTokenizer.nextToken() + " ";
        }
        object = ((String)object).substring(0, ((String)object).length() - 1);
        return object;
    }

    public static void composePolicyFile() throws ClassNotFoundException {
        try {
            Object object;
            String string = "util/derby_tests.policy";
            if (!replacePolicyFile) {
                object = new File(userdir);
                CopySuppFiles.copyFiles((File)object, string);
            }
            if (isSuiteRun && suiteName != null) {
                object = RunTest.loadTestResource("suites/" + suiteName.substring(0, suiteName.indexOf(58)) + ".policy");
                RunTest.writePolicyFile((InputStream)object);
            }
            if (!useprocess) {
                object = RunTest.loadTestResource("util/useprocessfalse.policy");
                RunTest.writePolicyFile((InputStream)object);
            }
            object = RunTest.loadTestResource("tests/" + testDirName + "/" + testBase + ".policy");
            RunTest.writePolicyFile((InputStream)object);
        }
        catch (IOException iOException) {
            System.out.println("Exception trying to create policy file: ");
            iOException.printStackTrace();
        }
    }

    public static void writePolicyFile(InputStream inputStream) {
        try {
            if (inputStream != null) {
                File file = new File(runDir, "derby_tests.policy");
                if (verbose && file.exists()) {
                    System.out.println("Appending to derby_tests.policy");
                }
                BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(inputStream, "UTF-8"));
                FileWriter fileWriter = new FileWriter(file.getPath(), true);
                PrintWriter printWriter = new PrintWriter((Writer)new BufferedWriter(fileWriter, 10000), true);
                String string = "";
                while ((string = bufferedReader.readLine()) != null) {
                    printWriter.println(string);
                }
                printWriter.close();
                bufferedReader.close();
                printWriter = null;
                inputStream = null;
            }
        }
        catch (IOException iOException) {
            System.out.println("Exception trying to create policy file: ");
            iOException.printStackTrace();
        }
    }

    private static void execTestProcess(String[] stringArray) throws Exception {
        block12: {
            Process process = null;
            try {
                ProcessStreamResult processStreamResult = null;
                ProcessStreamResult processStreamResult2 = null;
                FileOutputStream fileOutputStream = null;
                BufferedOutputStream bufferedOutputStream = null;
                StringBuffer stringBuffer = new StringBuffer();
                for (int i = 0; i < stringArray.length; ++i) {
                    stringBuffer.append(stringArray[i] + " ");
                }
                if (verbose) {
                    System.out.println(stringBuffer.toString());
                }
                process = Runtime.getRuntime().exec(stringArray);
                String string = null;
                String string2 = null;
                if (isI18N) {
                    string2 = string = "UTF-8";
                }
                if (codeset != null) {
                    string = codeset;
                }
                if (testEncoding != null) {
                    string = testEncoding;
                }
                fileOutputStream = useOutput ? new FileOutputStream(tmpOutFile) : new FileOutputStream(stdOutFile);
                bufferedOutputStream = new BufferedOutputStream(fileOutputStream, 1024);
                processStreamResult = new ProcessStreamResult(process.getInputStream(), bufferedOutputStream, timeoutStr, string, string2);
                processStreamResult2 = new ProcessStreamResult(process.getErrorStream(), bufferedOutputStream, timeoutStr, string, string2);
                if (framework != null && !framework.equals("") && verbose) {
                    System.out.println("The test should be running...");
                }
                if (timeout != -1) {
                    TimedProcess timedProcess = new TimedProcess(process);
                    timedProcess.waitFor(timeout * 60);
                    process = null;
                }
                boolean bl = processStreamResult.Wait();
                boolean bl2 = processStreamResult2.Wait();
                if (bl2 || bl) {
                    pwDiff.println("The test timed out...");
                    System.out.println("Test timed out...");
                    process.destroy();
                    process = null;
                }
                fileOutputStream.close();
                bufferedOutputStream.close();
                if (process != null) {
                    process.destroy();
                    process = null;
                }
            }
            catch (IOException iOException) {
                System.out.println("IOException: " + iOException.getMessage());
            }
            catch (Throwable throwable) {
                pwDiff.println("Process exception: " + throwable);
                System.out.println("Process exception: " + throwable.getMessage());
                throwable.printStackTrace();
                if (process == null) break block12;
                process.destroy();
                process = null;
            }
        }
    }

    private static void execTestNoProcess(Properties properties, String string, String string2, String string3) throws Exception {
        Properties properties2 = System.getProperties();
        properties2.put("derby.system.home", string);
        properties2.put("derby.infolog.append", "true");
        if (framework.startsWith("DerbyNet")) {
            properties2.put("hostName=", hostName);
        }
        System.setProperties(properties2);
        String string4 = "";
        try {
            string4 = tmpOutFile.getCanonicalPath().replace(File.separatorChar, fileSep);
        }
        catch (IOException iOException) {
            FileWriter fileWriter = new FileWriter(tmpOutFile);
            fileWriter.close();
            string4 = tmpOutFile.getCanonicalPath().replace(File.separatorChar, fileSep);
        }
        PrintStream printStream = new PrintStream(new FileOutputStream(string4), true);
        RunTest.composePolicyFile();
        boolean bl = RunTest.installSecurityManager();
        if (testType.equals("sql")) {
            String[] stringArray = new String[]{"-p", string2, string3};
            PrintStream printStream2 = System.out;
            PrintStream printStream3 = System.err;
            System.setOut(printStream);
            System.setErr(printStream);
            RunIJ runIJ = new RunIJ(stringArray);
            Thread thread = new Thread(runIJ);
            try {
                thread.start();
                if (timeout < 0) {
                    thread.join();
                } else {
                    thread.join(timeout * 60 * 1000);
                }
            }
            catch (Exception exception) {
                System.out.println("Aiiie! Got some kind of exception " + exception);
            }
            if (shutdownurl != null) {
                String[] stringArray2 = new String[]{string, shutdownurl};
                shutdown.main(stringArray2);
            }
            properties2 = System.getProperties();
            properties2.put("ij.defaultResourcePackage", "/org/apache/derbyTesting/");
            properties2.put("usesystem", "");
            System.setProperties(properties2);
            System.setOut(printStream2);
            System.setErr(printStream3);
        } else if (testType.equals("java")) {
            if (javaPath == null) {
                javaPath = "org.apache.derbyTesting.functionTests.tests." + testDirName;
            }
            String[] stringArray = new String[]{"-p", string2};
            Class[] classArray = new Class[]{stringArray.getClass()};
            String string5 = javaPath + "." + testBase;
            Class<?> clazz = Class.forName(string5);
            PrintStream printStream4 = System.out;
            PrintStream printStream5 = System.err;
            System.setOut(printStream);
            System.setErr(printStream);
            Method method = clazz.getMethod("main", classArray);
            Object[] objectArray = new Object[]{stringArray};
            RunClass runClass = new RunClass(method, objectArray);
            Thread thread = new Thread(runClass);
            try {
                thread.start();
                if (timeout < 0) {
                    thread.join();
                } else {
                    thread.join(timeout * 60 * 1000);
                }
            }
            catch (Exception exception) {
                System.out.println("Exception upon invoking test..." + exception);
                exception.printStackTrace();
            }
            try {
                DriverManager.getConnection("jdbc:derby:;shutdown=true");
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
            System.setOut(printStream4);
            System.setErr(printStream5);
        } else if (testType.equals("multi")) {
            System.out.println("scriptiflename is: later " + scriptFileName);
            String[] stringArray = new String[]{scriptFileName, "-i", mtestdir, "-o", outDir.getPath()};
            System.out.println("Try running MultiTest.main");
            for (int i = 0; i < stringArray.length; ++i) {
                System.out.println("args: " + stringArray[i]);
            }
            System.exit(1);
            MultiTest.main(stringArray);
        } else if (testType.equals("unit")) {
            PrintStream printStream6 = System.out;
            PrintStream printStream7 = System.err;
            System.setOut(printStream);
            System.setErr(printStream);
            System.out.println("Unit tests not implemented yet with useprocess=false");
            System.setOut(printStream6);
            System.setErr(printStream7);
            System.out.println("Unit tests not implemented yet with useprocess=false");
        } else if (testType.equals("junit")) {
            PrintStream printStream8 = System.out;
            PrintStream printStream9 = System.err;
            System.setOut(printStream);
            System.setErr(printStream);
            if (javaPath == null) {
                javaPath = "org.apache.derbyTesting.functionTests.tests." + testDirName;
            }
            String string6 = javaPath + "." + testBase;
            Class<?> clazz = Class.forName(string6);
            BaseTestSuite baseTestSuite = null;
            try {
                Method method = clazz.getMethod("suite", null);
                baseTestSuite = (BaseTestSuite)((Object)method.invoke(null, null));
            }
            catch (Exception exception) {
                baseTestSuite = new BaseTestSuite(clazz);
            }
            if (baseTestSuite != null) {
                TestRunner.run((Test)baseTestSuite);
            } else {
                System.out.println("Not able to extract JUnit BaseTestSuite from test class " + string6);
            }
            System.setOut(printStream8);
            System.setErr(printStream9);
        }
        printStream.close();
        if (bl) {
            System.setSecurityManager(null);
        }
    }

    static void addSkiptestReason(String string) {
        if (skiptestReason.length() > 0) {
            skiptestReason.append(System.getProperty("line.separator", "\n"));
        }
        skiptestReason.append(string);
    }

    static boolean verifyFramework(String string) {
        Object object = "";
        for (int i = 0; i < validFrameworks.length; ++i) {
            object = (String)object + " " + validFrameworks[i];
            if (!validFrameworks[i].equals(string)) continue;
            return true;
        }
        System.err.println("Invalid framework: " + string);
        System.err.println("Valid frameworks are: " + (String)object);
        return false;
    }

    public static InputStream loadTestResource(String string) {
        return RunTest.class.getResourceAsStream(testResourceHome + string);
    }

    private static String convertPathForWin(String string) {
        Object object = "a" + string + "a";
        int n = ((String)object).indexOf(47);
        while (n != -1) {
            object = ((String)object).substring(0, n) + "\\\\" + ((String)object).substring(n + 1);
            n = ((String)object).indexOf(47);
        }
        object = ((String)object).substring(1, ((String)object).length() - 1);
        return object;
    }

    private static boolean installSecurityManager() throws ClassNotFoundException, IOException {
        boolean bl;
        if (jvmName.startsWith("j9") && !jvmName.equals("j9_foundation11")) {
            return false;
        }
        boolean bl2 = false;
        boolean bl3 = bl = System.getSecurityManager() != null;
        if (runWithoutSecurityManager) {
            if (bl) {
                System.out.println("noSecurityManager=true,useProcess=false but SecurityManager installed by previous test");
            } else {
                System.out.println("-- SecurityManager not installed --");
            }
        } else if (!bl) {
            for (String string : jvm.getSecurityProps(null)) {
                if ("java.security.manager".equals(string)) continue;
                int n = string.indexOf("=");
                String string2 = string.substring(0, n);
                String string3 = string.substring(n + 1);
                System.setProperty(string2, string3);
            }
            System.setSecurityManager(new SecurityManager());
            bl2 = true;
        }
        return bl2;
    }

    private static void generateUTF8OutFile(File file) throws IOException {
        if (generateUTF8Out) {
            int n;
            keepfiles = true;
            File file2 = new File(UTF8OutName);
            BufferedReader bufferedReader = new BufferedReader(new FileReader(file));
            FileOutputStream fileOutputStream = new FileOutputStream(file2);
            BufferedWriter bufferedWriter = new BufferedWriter(new OutputStreamWriter((OutputStream)fileOutputStream, "UTF-8"));
            while ((n = bufferedReader.read()) != -1) {
                bufferedWriter.write(n);
            }
            bufferedWriter.flush();
            bufferedWriter.close();
            fileOutputStream.close();
        }
    }

    static {
        serverNeedsStopping = false;
        jvmnet = false;
        jvmName = "currentjvm";
        isjdk12test = false;
        classpath = "";
        classpathServer = "";
        framework = "embedded";
        J9_STATEMENTCACHESIZE = "20";
        usesystem = "";
        searchCP = "";
        useCommonDB = false;
        keepfiles = false;
        useprocess = true;
        systemdiff = false;
        upgradetest = false;
        encryption = false;
        jdk12exttest = false;
        generateUTF8Out = false;
        runningdir = "";
        outputdir = "";
        mtestdir = "";
        testSpecialProps = "";
        testJavaFlags = "";
        reportstderr = true;
        timeout = -1;
        skipsed = false;
        commonDBHome = "testCSHome";
        dbIsNew = true;
        runwithjvm = "true";
        startServer = true;
        replacePolicyFile = false;
        scriptName = "";
        testDirName = "";
        defaultPackageName = "/org/apache/derbyTesting/";
        javaPath = "org.apache.derbyTesting.";
        shutdownurl = "";
        printWriter = null;
        pwDiff = null;
        topsuitedir = "";
        topsuiteName = "";
        topreportdir = "";
        suiteName = "";
        isSuiteRun = false;
        lastTestFailed = false;
        isI18N = false;
        codeset = null;
        junitXASingle = false;
        isSed = null;
    }

    private static class AppsRequiredPassword {
        public String password;

        private AppsRequiredPassword() {
        }
    }
}

