/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derbyTesting.functionTests.tests.store;

import java.io.PrintStream;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.sql.Connection;
import java.sql.SQLException;
import org.apache.derby.tools.JDBCDisplayUtil;
import org.apache.derby.tools.ij;
import org.apache.derbyTesting.functionTests.tests.store.MaxLogNumber;

public class MaxLogNumberRecovery
extends MaxLogNumber {
    MaxLogNumberRecovery() {
    }

    private void runTest(Connection conn) throws SQLException {
        block4: {
            this.logMessage("Begin MaxLogNumberRecovery Test");
            this.verifyData(conn, 100);
            boolean hitMaxLogLimitError = false;
            try {
                this.insert(conn, 110, 1, 11);
                this.update(conn, 110, 2, 5);
                this.update(conn, 110, 3, 5);
                this.verifyData(conn, 210);
            }
            catch (SQLException se) {
                SQLException ose = se;
                while (se != null) {
                    if ("XSLAK".equals(se.getSQLState())) {
                        hitMaxLogLimitError = true;
                        break;
                    }
                    se = se.getNextException();
                }
                if (hitMaxLogLimitError) break block4;
                throw ose;
            }
        }
        this.logMessage("End MaxLogNumberRecovery Test");
    }

    private static void setSystemProperty(final String name, final String value) {
        AccessController.doPrivileged(new PrivilegedAction<Void>(){

            @Override
            public Void run() {
                System.setProperty(name, value);
                return null;
            }
        });
    }

    public static void main(String[] argv) throws Throwable {
        MaxLogNumberRecovery test = new MaxLogNumberRecovery();
        ij.getPropertyArg((String[])argv);
        MaxLogNumberRecovery.setSystemProperty("derby.stream.error.extendedDiagSeverityLevel", "50000");
        Connection conn = ij.startJBMS();
        conn.setAutoCommit(false);
        try {
            test.runTest(conn);
        }
        catch (SQLException sqle) {
            JDBCDisplayUtil.ShowSQLException((PrintStream)System.out, (SQLException)sqle);
            sqle.printStackTrace(System.out);
        }
    }
}

