/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.iapi.types;

import java.sql.Blob;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import org.apache.derby.iapi.error.StandardException;
import org.apache.derby.iapi.services.io.CloneableStream;
import org.apache.derby.iapi.types.DataTypeDescriptor;
import org.apache.derby.iapi.types.DataValueDescriptor;
import org.apache.derby.iapi.types.HarmonySerialBlob;
import org.apache.derby.iapi.types.RawToBinaryFormatStream;
import org.apache.derby.iapi.types.SQLBinary;
import org.apache.derby.shared.common.sanity.SanityManager;

public class SQLBlob
extends SQLBinary {
    public SQLBlob() {
    }

    public SQLBlob(byte[] val) {
        super(val);
    }

    public SQLBlob(Blob val) {
        super(val);
    }

    @Override
    public String getTypeName() {
        return "BLOB";
    }

    @Override
    int getMaxMemoryUsage() {
        return Integer.MAX_VALUE;
    }

    @Override
    public boolean hasStream() {
        return this.stream != null;
    }

    @Override
    public DataValueDescriptor cloneValue(boolean forceMaterialization) {
        SQLBlob clone = new SQLBlob();
        if (this.isNull()) {
            return clone;
        }
        if (!forceMaterialization && this.dataValue == null) {
            if (this.stream != null && this.stream instanceof CloneableStream) {
                clone.setStream(((CloneableStream)((Object)this.stream)).cloneStream());
                if (this.streamValueLength != -1) {
                    clone.streamValueLength = this.streamValueLength;
                }
            } else if (this._blobValue != null) {
                clone.setValue(this._blobValue);
            }
        }
        if (clone.isNull() || forceMaterialization) {
            try {
                clone.setValue(this.getBytes());
            }
            catch (StandardException se) {
                SanityManager.THROWASSERT("Unexpected exception", se);
                return null;
            }
        }
        return clone;
    }

    @Override
    public DataValueDescriptor getNewNull() {
        return new SQLBlob();
    }

    @Override
    public Object getObject() throws StandardException {
        if (this._blobValue != null) {
            return this._blobValue;
        }
        byte[] bytes = this.getBytes();
        if (bytes == null) {
            return null;
        }
        return new HarmonySerialBlob(bytes);
    }

    @Override
    public void normalize(DataTypeDescriptor desiredType, DataValueDescriptor source) throws StandardException {
        this.setValue(source);
        this.setWidth(desiredType.getMaximumWidth(), 0, true);
    }

    @Override
    public void setWidth(int desiredWidth, int desiredScale, boolean errorOnTrunc) throws StandardException {
        if (this.isNull()) {
            return;
        }
        if (this.isLengthLess()) {
            return;
        }
        int sourceWidth = this.getLength();
        if (sourceWidth > desiredWidth) {
            if (errorOnTrunc) {
                throw StandardException.newException("22001", this.getTypeName(), "XXXX", String.valueOf(desiredWidth));
            }
            this.truncate(sourceWidth, desiredWidth, true);
        }
    }

    @Override
    public int getTypeFormatId() {
        return 443;
    }

    @Override
    public void setValueFromResultSet(ResultSet resultSet, int colNumber, boolean isNullable) throws SQLException, StandardException {
        Blob blob = resultSet.getBlob(colNumber);
        if (blob == null) {
            this.setToNull();
        } else {
            this.setObject(blob);
        }
    }

    @Override
    public int typePrecedence() {
        return 170;
    }

    @Override
    public void setInto(PreparedStatement ps, int position) throws SQLException, StandardException {
        if (this.isNull()) {
            ps.setBlob(position, (Blob)null);
            return;
        }
        ps.setBytes(position, this.getBytes());
    }

    @Override
    final void setObject(Object theValue) throws StandardException {
        Blob vb = (Blob)theValue;
        try {
            long vbl = vb.length();
            if (vbl < 0L || vbl > Integer.MAX_VALUE) {
                throw this.outOfRange();
            }
            this.setValue(new RawToBinaryFormatStream(vb.getBinaryStream(), (int)vbl), (int)vbl);
        }
        catch (SQLException e) {
            throw this.dataTypeConversion("DAN-438-tmp");
        }
    }

    private final boolean isLengthLess() {
        return this.stream != null && this.streamValueLength < 0;
    }
}

