/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derbyTesting.functionTests.util;

import java.io.PrintStream;
import java.lang.reflect.Method;
import java.util.Properties;
import junit.extensions.TestSetup;
import junit.framework.Test;
import org.apache.derbyTesting.functionTests.util.CanonTestCase;
import org.apache.derbyTesting.junit.CleanDatabaseTestSetup;
import org.apache.derbyTesting.junit.DatabasePropertyTestSetup;
import org.apache.derbyTesting.junit.JDBC;
import org.apache.derbyTesting.junit.SystemPropertyTestSetup;
import org.apache.derbyTesting.junit.TestConfiguration;

public abstract class HarnessJavaTest
extends CanonTestCase {
    private static final Object[] MAIN_ARG = new Object[]{new String[0]};
    private static final Class[] MAIN_ARG_TYPE = new Class[]{MAIN_ARG[0].getClass()};

    protected HarnessJavaTest(String name) {
        super(name);
    }

    protected abstract String getArea();

    public void runTest() throws Throwable {
        String testClassName = "org.apache.derbyTesting.functionTests.tests." + this.getArea() + "." + this.getName();
        String canon = "org/apache/derbyTesting/functionTests/master/" + this.getName() + ".out";
        PrintStream out = System.out;
        PrintStream testOut = new PrintStream(this.getOutputStream(), false, this.outputEncoding);
        HarnessJavaTest.setSystemOut(testOut);
        Class<?> test = Class.forName(testClassName);
        Method main = test.getDeclaredMethod("main", MAIN_ARG_TYPE);
        main.invoke(null, MAIN_ARG);
        HarnessJavaTest.setSystemOut(out);
        this.compareCanon(canon);
    }

    protected static Test decorate(HarnessJavaTest test) {
        TestSetup dtest = new SystemPropertyTestSetup((Test)test, new Properties()){

            @Override
            protected void setUp() throws Exception {
                TestConfiguration config = TestConfiguration.getCurrent();
                if (JDBC.vmSupportsJDBC3()) {
                    this.newValues.setProperty("ij.database", config.getJDBCUrl());
                }
                super.setUp();
            }
        };
        dtest = DatabasePropertyTestSetup.setLockTimeouts((Test)dtest, 4, 6);
        dtest = new CleanDatabaseTestSetup((Test)dtest);
        return dtest;
    }
}

