/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derbyTesting.functionTests.tests.jdbcapi;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.SQLWarning;
import org.apache.derbyTesting.junit.BaseJDBCTestCase;

public abstract class SURBaseTest
extends BaseJDBCTestCase {
    final int recordCount;
    static final String FOR_UPDATE_NOT_PERMITTED_SQL_STATE = "42Y90";
    static final String CURSOR_NOT_UPDATABLE_SQL_STATE = "42X23";
    static final String RESULTSET_NOT_UPDATABLE_SQL_STATE = "XJ083";
    static final String LOCK_TIMEOUT_SQL_STATE = "40XL1";
    static final String LOCK_TIMEOUT_EXPRESSION_SQL_STATE = "38000";
    static final String INVALID_CURSOR_STATE_NO_CURRENT_ROW = "24000";
    static final String CURSOR_OPERATION_CONFLICT = "01001";
    static final String QUERY_NOT_QUALIFIED_FOR_UPDATABLE_RESULTSET = "01J06";
    static final String CURSOR_NOT_POSITIONED_ON_INSERT_ROW = "XJ086";

    public SURBaseTest(String name) {
        super(name);
        this.recordCount = 10;
    }

    public SURBaseTest(String name, int records) {
        super(name);
        this.recordCount = records;
    }

    @Override
    protected void initializeConnection(Connection conn) throws SQLException {
        conn.setAutoCommit(false);
        conn.setTransactionIsolation(4);
    }

    protected void verifyTuple(ResultSet rs) throws SQLException {
        int id = rs.getInt(1);
        int a = rs.getInt(2);
        int b = rs.getInt(3);
        int sum = a + id + 17;
        SURBaseTest.println("Reading tuple:(" + id + "," + a + "," + b + ",'" + rs.getString(4) + "', '" + rs.getString(5) + "'");
        SURBaseTest.assertEquals((String)"Expecting b==id+a+17", (int)sum, (int)b);
    }

    protected void updateTuple(ResultSet rs) throws SQLException {
        int id = rs.getInt(1);
        int a = rs.getInt(2);
        int b = rs.getInt(3);
        int newA = a * 2 + id + 37;
        int newB = newA + id + 17;
        SURBaseTest.println("Updating record (" + id + "," + newA + "," + newB + ")");
        rs.updateInt(2, newA);
        rs.updateInt(3, newB);
        rs.updateRow();
    }

    protected void updateTuplePositioned(ResultSet rs) throws SQLException {
        int id = rs.getInt(1);
        int a = rs.getInt(2);
        int b = rs.getInt(3);
        int newA = a * 2 + id + 37;
        int newB = newA + id + 17;
        PreparedStatement ps = this.prepareStatement("update T1 set a=?,b=? where current of " + rs.getCursorName());
        ps.setInt(1, newA);
        ps.setInt(2, newB);
        SURBaseTest.assertEquals((String)"Expected one tuple to be updated", (int)1, (int)ps.executeUpdate());
        ps.close();
    }

    protected void scrollForward(ResultSet rs) throws SQLException {
        boolean ignoreCount = rs.getType() == 1003 || !rs.isBeforeFirst();
        int nRecords = 0;
        while (rs.next()) {
            ++nRecords;
            this.verifyTuple(rs);
        }
        if (!ignoreCount) {
            SURBaseTest.assertEquals((String)"Record Count", (int)this.recordCount, (int)nRecords);
        }
    }

    protected void scrollBackward(ResultSet rs) throws SQLException {
        boolean ignoreCount = rs.getType() == 1003 || !rs.isAfterLast();
        int nRecords = 0;
        while (rs.previous()) {
            ++nRecords;
            this.verifyTuple(rs);
        }
        if (!ignoreCount) {
            SURBaseTest.assertEquals((String)"Record Count", (int)this.recordCount, (int)nRecords);
        }
    }

    protected void scrollForwardAndUpdate(ResultSet rs) throws SQLException {
        boolean ignoreCount;
        int nRecords = 0;
        boolean bl = ignoreCount = rs.getType() == 1003 || !rs.isBeforeFirst();
        while (rs.next()) {
            ++nRecords;
            this.verifyTuple(rs);
            this.updateTuple(rs);
        }
        if (!ignoreCount) {
            SURBaseTest.assertEquals((String)"Record Count", (int)this.recordCount, (int)nRecords);
        }
        SURBaseTest.assertNotNull((String)"rs.getCursorName()", (Object)rs.getCursorName());
    }

    protected void scrollForwardAndUpdatePositioned(ResultSet rs) throws SQLException {
        boolean ignoreCount;
        int nRecords = 0;
        boolean bl = ignoreCount = rs.getType() == 1003 || !rs.isBeforeFirst();
        while (rs.next()) {
            ++nRecords;
            this.verifyTuple(rs);
            this.updateTuplePositioned(rs);
        }
        if (!ignoreCount) {
            SURBaseTest.assertEquals((String)"Record Count", (int)this.recordCount, (int)nRecords);
        }
        SURBaseTest.assertNotNull((String)"rs.getCursorName()", (Object)rs.getCursorName());
    }

    protected void scrollBackwardAndUpdate(ResultSet rs) throws SQLException {
        boolean ignoreCount;
        int nRecords = 0;
        boolean bl = ignoreCount = rs.getType() == 1003 || !rs.isAfterLast();
        while (rs.previous()) {
            ++nRecords;
            this.verifyTuple(rs);
            this.updateTuple(rs);
        }
        if (!ignoreCount) {
            SURBaseTest.assertEquals((String)"Record Count", (int)this.recordCount, (int)nRecords);
        }
        SURBaseTest.assertNotNull((String)"rs.getCursorName()", (Object)rs.getCursorName());
    }

    protected void scrollBackwardAndUpdatePositioned(ResultSet rs) throws SQLException {
        boolean ignoreCount;
        int nRecords = 0;
        boolean bl = ignoreCount = rs.getType() == 1003 || !rs.isAfterLast();
        while (rs.previous()) {
            ++nRecords;
            this.verifyTuple(rs);
            this.updateTuplePositioned(rs);
        }
        if (!ignoreCount) {
            SURBaseTest.assertEquals((String)"Record Count", (int)this.recordCount, (int)nRecords);
        }
        SURBaseTest.assertNotNull((String)"rs.getCursorName()", (Object)rs.getCursorName());
    }

    protected void assertFailOnUpdate(ResultSet rs) throws SQLException {
        boolean failedCorrect = false;
        try {
            this.updateTuple(rs);
        }
        catch (SQLException e) {
            failedCorrect = true;
            SURBaseTest.assertEquals((String)"Unexpected SQL state", (String)RESULTSET_NOT_UPDATABLE_SQL_STATE, (String)e.getSQLState());
        }
        SURBaseTest.assertTrue((String)"Expected cursor to fail on update, since it is read only", (boolean)failedCorrect);
    }

    protected void assertWarning(SQLWarning warn, String sqlState) throws SQLException {
        if (warn != null || SURBaseTest.usingEmbedded()) {
            SURBaseTest.assertEquals((String)"Unexpected SQL state", (String)sqlState, (String)warn.getSQLState());
        } else {
            SURBaseTest.println("Expected warning with SQLState = '" + sqlState + "', however warning not propagated to client driver");
        }
    }
}

