/*
 * Decompiled with CFR 0.152.
 */
package org.junit.vintage.engine.discovery;

import java.lang.reflect.Method;
import java.util.function.Predicate;
import org.junit.Ignore;
import org.junit.internal.builders.AllDefaultPossibilitiesBuilder;
import org.junit.internal.builders.AnnotatedBuilder;
import org.junit.internal.builders.IgnoredBuilder;
import org.junit.internal.builders.IgnoredClassRunner;
import org.junit.internal.builders.JUnit4Builder;
import org.junit.platform.commons.logging.Logger;
import org.junit.platform.commons.logging.LoggerFactory;
import org.junit.platform.commons.util.ReflectionUtils;
import org.junit.runner.Runner;
import org.junit.runner.manipulation.Filterable;
import org.junit.runners.model.RunnerBuilder;
import org.junit.vintage.engine.discovery.FilterableIgnoringRunnerDecorator;
import org.junit.vintage.engine.discovery.IgnoringRunnerDecorator;
import org.junit.vintage.engine.discovery.IsPotentialJUnit4TestMethod;

class DefensiveAllDefaultPossibilitiesBuilder
extends AllDefaultPossibilitiesBuilder {
    private static final Logger logger = LoggerFactory.getLogger(DefensiveAllDefaultPossibilitiesBuilder.class);
    private final AnnotatedBuilder annotatedBuilder = new DefensiveAnnotatedBuilder(this);
    private final JUnit4Builder junit4Builder = new DefensiveJUnit4Builder();
    private final IgnoredBuilder ignoredBuilder = new NullIgnoredBuilder();

    DefensiveAllDefaultPossibilitiesBuilder() {
        super(true);
    }

    @Override
    public Runner runnerForClass(Class<?> testClass) throws Throwable {
        Runner runner = super.runnerForClass(testClass);
        if (testClass.getAnnotation(Ignore.class) != null) {
            if (runner == null) {
                return new IgnoredClassRunner(testClass);
            }
            return this.decorateIgnoredTestClass(runner);
        }
        return runner;
    }

    boolean isIgnored(Runner runner) {
        return runner instanceof IgnoredClassRunner || runner instanceof IgnoringRunnerDecorator;
    }

    private IgnoringRunnerDecorator decorateIgnoredTestClass(Runner runner) {
        if (runner instanceof Filterable) {
            return new FilterableIgnoringRunnerDecorator(runner);
        }
        return new IgnoringRunnerDecorator(runner);
    }

    @Override
    protected AnnotatedBuilder annotatedBuilder() {
        return this.annotatedBuilder;
    }

    @Override
    protected JUnit4Builder junit4Builder() {
        return this.junit4Builder;
    }

    @Override
    protected IgnoredBuilder ignoredBuilder() {
        return this.ignoredBuilder;
    }

    private static class DefensiveAnnotatedBuilder
    extends AnnotatedBuilder {
        DefensiveAnnotatedBuilder(RunnerBuilder suiteBuilder) {
            super(suiteBuilder);
        }

        @Override
        public Runner buildRunner(Class<? extends Runner> runnerClass, Class<?> testClass) throws Exception {
            if ("org.junit.platform.runner.JUnitPlatform".equals(runnerClass.getName())) {
                logger.warn(() -> "Ignoring test class using JUnitPlatform runner: " + testClass.getName());
                return null;
            }
            return super.buildRunner(runnerClass, testClass);
        }
    }

    private static class DefensiveJUnit4Builder
    extends JUnit4Builder {
        private static final Predicate<Method> isPotentialJUnit4TestMethod = new IsPotentialJUnit4TestMethod();

        private DefensiveJUnit4Builder() {
        }

        @Override
        public Runner runnerForClass(Class<?> testClass) throws Throwable {
            if (this.containsTestMethods(testClass)) {
                return super.runnerForClass(testClass);
            }
            return null;
        }

        private boolean containsTestMethods(Class<?> testClass) {
            return ReflectionUtils.isMethodPresent(testClass, isPotentialJUnit4TestMethod);
        }
    }

    private static class NullIgnoredBuilder
    extends IgnoredBuilder {
        private NullIgnoredBuilder() {
        }

        @Override
        public Runner runnerForClass(Class<?> testClass) {
            return null;
        }
    }
}

