/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.configuration2.io;

import java.net.URL;
import org.apache.commons.configuration2.ConfigurationAssert;
import org.apache.commons.configuration2.ImmutableConfiguration;
import org.apache.commons.configuration2.XMLConfiguration;
import org.apache.commons.configuration2.builder.fluent.Configurations;
import org.apache.commons.configuration2.ex.ConfigurationException;
import org.apache.commons.configuration2.io.ClasspathLocationStrategy;
import org.apache.commons.configuration2.io.FileLocator;
import org.apache.commons.configuration2.io.FileLocatorUtils;
import org.apache.commons.configuration2.io.FileSystem;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.mockito.Mockito;

public class TestClasspathLocationStrategy {
    private static final String FILE_NAME = "test.xml";
    private FileSystem fileSystem;
    private ClasspathLocationStrategy strategy;

    @BeforeEach
    public void setUp() throws Exception {
        this.fileSystem = (FileSystem)Mockito.mock(FileSystem.class);
        this.strategy = new ClasspathLocationStrategy();
    }

    @Test
    void testLocateFailed() {
        FileLocator locator = FileLocatorUtils.fileLocator().fileName("non existing resource name!").create();
        Assertions.assertNull((Object)this.strategy.locate(this.fileSystem, locator));
    }

    @Test
    void testLocateNoFileName() {
        FileLocator locator = FileLocatorUtils.fileLocator().fileName("").create();
        Assertions.assertNull((Object)this.strategy.locate(this.fileSystem, locator));
    }

    @Test
    void testLocateSuccess() throws ConfigurationException {
        FileLocator locator = FileLocatorUtils.fileLocator().fileName(FILE_NAME).basePath("somePath").create();
        URL url = this.strategy.locate(this.fileSystem, locator);
        Configurations configurations = new Configurations();
        XMLConfiguration config1 = configurations.xml(url);
        XMLConfiguration config2 = configurations.xml(ConfigurationAssert.getTestURL(FILE_NAME));
        ConfigurationAssert.assertConfigurationEquals((ImmutableConfiguration)config1, (ImmutableConfiguration)config2);
    }
}

