/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.project.validation;

import java.util.function.Supplier;
import org.apache.cayenne.map.DbAttribute;
import org.apache.cayenne.project.validation.ConfigurationNodeValidator;
import org.apache.cayenne.project.validation.Inspection;
import org.apache.cayenne.project.validation.NameValidationHelper;
import org.apache.cayenne.project.validation.ValidationConfig;
import org.apache.cayenne.util.Util;
import org.apache.cayenne.validation.ValidationResult;

class DbAttributeValidator
extends ConfigurationNodeValidator<DbAttribute> {
    public DbAttributeValidator(Supplier<ValidationConfig> configSupplier) {
        super(configSupplier);
    }

    @Override
    public void validate(DbAttribute node, ValidationResult validationResult) {
        this.on(node, validationResult).performIfEnabled(Inspection.DB_ATTRIBUTE_NO_NAME, this::checkForName).performIfEnabled(Inspection.DB_ATTRIBUTE_INVALID_NAME, this::validateName).performIfEnabled(Inspection.DB_ATTRIBUTE_NO_TYPE, this::checkForType).performIfEnabled(Inspection.DB_ATTRIBUTE_NO_LENGTH, this::checkForLength);
    }

    private void checkForName(DbAttribute attribute, ValidationResult validationResult) {
        if (Util.isEmptyString(attribute.getName())) {
            this.addFailure(validationResult, attribute, "Unnamed DbAttribute", new Object[0]);
        }
    }

    private void validateName(DbAttribute attribute, ValidationResult validationResult) {
        NameValidationHelper helper = NameValidationHelper.getInstance();
        String name = attribute.getName();
        String invalidChars = helper.invalidCharsInDbPathComponent(name);
        if (Util.isEmptyString(name)) {
            return;
        }
        if (invalidChars != null) {
            this.addFailure(validationResult, attribute, "DbAttribute name '%s' contains invalid characters: %s", name, invalidChars);
        }
    }

    private void checkForType(DbAttribute attribute, ValidationResult validationResult) {
        if (attribute.getType() == Integer.MAX_VALUE) {
            this.addFailure(validationResult, attribute, "DbAttribute has no type", new Object[0]);
        }
    }

    private void checkForLength(DbAttribute attribute, ValidationResult validationResult) {
        if (attribute.getMaxLength() < 0 && (attribute.getType() == 12 || attribute.getType() == -9 || attribute.getType() == 1 || attribute.getType() == -15)) {
            this.addFailure(validationResult, attribute, "Character DbAttribute '%s' doesn't have max length", attribute.getName());
        }
    }
}

