/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.modeler.undo;

import java.util.List;
import javax.swing.undo.AbstractUndoableEdit;
import javax.swing.undo.CannotRedoException;
import javax.swing.undo.CannotUndoException;
import org.apache.cayenne.dbsync.reverse.dbimport.ReverseEngineering;
import org.apache.cayenne.modeler.ProjectController;
import org.apache.cayenne.modeler.dialog.db.load.DbImportTreeNode;
import org.apache.cayenne.modeler.editor.dbimport.DbImportTree;

public class DbImportTreeUndoableEdit
extends AbstractUndoableEdit {
    private ReverseEngineering previousReverseEngineering;
    private ReverseEngineering nextReverseEngineering;
    private DbImportTree tree;
    private ProjectController projectController;

    public DbImportTreeUndoableEdit(ReverseEngineering previousReverseEngineering, ReverseEngineering nextReverseEngineering, DbImportTree tree, ProjectController projectController) {
        this.tree = tree;
        this.previousReverseEngineering = previousReverseEngineering;
        this.nextReverseEngineering = nextReverseEngineering;
        this.projectController = projectController;
    }

    @Override
    public boolean canRedo() {
        return true;
    }

    @Override
    public void redo() throws CannotRedoException {
        this.tree.stopEditing();
        this.tree.setReverseEngineering(this.nextReverseEngineering);
        List<DbImportTreeNode> list = this.tree.getTreeExpandList();
        this.projectController.getApplication().getMetaData().add(this.projectController.getCurrentDataMap(), this.tree.getReverseEngineering());
        this.projectController.setDirty(true);
        this.tree.translateReverseEngineeringToTree(this.tree.getReverseEngineering(), false);
        this.tree.expandTree(list);
    }

    @Override
    public void undo() throws CannotUndoException {
        this.tree.stopEditing();
        this.tree.setReverseEngineering(this.previousReverseEngineering);
        List<DbImportTreeNode> list = this.tree.getTreeExpandList();
        this.projectController.getApplication().getMetaData().add(this.projectController.getCurrentDataMap(), this.tree.getReverseEngineering());
        this.projectController.setDirty(true);
        this.tree.translateReverseEngineeringToTree(this.tree.getReverseEngineering(), false);
        this.tree.expandTree(list);
    }
}

