/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.modeler.graph;

import com.jgraph.layout.JGraphFacade;
import com.jgraph.layout.organic.JGraphOrganicLayout;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Point;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.JPopupMenu;
import javax.swing.border.LineBorder;
import javax.swing.event.UndoableEditEvent;
import org.apache.cayenne.configuration.ConfigurationNodeVisitor;
import org.apache.cayenne.configuration.DataChannelDescriptor;
import org.apache.cayenne.configuration.event.DataMapEvent;
import org.apache.cayenne.configuration.event.DataMapListener;
import org.apache.cayenne.map.Attribute;
import org.apache.cayenne.map.DataMap;
import org.apache.cayenne.map.Entity;
import org.apache.cayenne.map.Relationship;
import org.apache.cayenne.map.event.EntityEvent;
import org.apache.cayenne.map.event.RelationshipEvent;
import org.apache.cayenne.modeler.Application;
import org.apache.cayenne.modeler.ProjectController;
import org.apache.cayenne.modeler.action.ActionManager;
import org.apache.cayenne.modeler.action.CreateAttributeAction;
import org.apache.cayenne.modeler.action.CreateRelationshipAction;
import org.apache.cayenne.modeler.graph.EntityCellMetadata;
import org.apache.cayenne.modeler.graph.GraphBuilder;
import org.apache.cayenne.modeler.graph.action.EntityDisplayAction;
import org.apache.cayenne.modeler.graph.action.RemoveEntityAction;
import org.apache.cayenne.util.XMLEncoder;
import org.jgraph.JGraph;
import org.jgraph.graph.AttributeMap;
import org.jgraph.graph.DefaultCellViewFactory;
import org.jgraph.graph.DefaultEdge;
import org.jgraph.graph.DefaultGraphCell;
import org.jgraph.graph.DefaultGraphModel;
import org.jgraph.graph.GraphConstants;
import org.jgraph.graph.GraphLayoutCache;

abstract class BaseGraphBuilder<E extends Entity<E, A, R>, A extends Attribute<E, A, R>, R extends Relationship<E, A, R>>
implements GraphBuilder<E, A, R>,
DataMapListener {
    static final Font EDGE_FONT = new Font("Verdana", 0, 10);
    protected JGraph graph;
    protected transient DataChannelDescriptor domain;
    protected Map<String, DefaultGraphCell> entityCells;
    protected Map<String, DefaultEdge> relCells;
    protected List<DefaultGraphCell> createdObjects;
    protected transient ProjectController mediator;
    protected transient Entity<E, A, R> selectedEntity;
    transient JPopupMenu popup;
    boolean undoEventsDisabled;

    BaseGraphBuilder() {
    }

    @Override
    public void buildGraph(ProjectController mediator, DataChannelDescriptor domain, boolean doLayout) {
        if (this.graph != null) {
            return;
        }
        this.graph = new JGraph();
        DefaultGraphModel model = new DefaultGraphModel();
        this.graph.setModel(model);
        this.setProjectController(mediator);
        this.setDataDomain(domain);
        GraphLayoutCache view = new GraphLayoutCache(model, new DefaultCellViewFactory());
        this.graph.setGraphLayoutCache(view);
        this.addMouseListeners();
        this.entityCells = new HashMap<String, DefaultGraphCell>();
        this.createdObjects = new ArrayList<DefaultGraphCell>();
        this.relCells = new HashMap<String, DefaultEdge>();
        ArrayList<DefaultGraphCell> isolatedObjects = new ArrayList<DefaultGraphCell>();
        for (DataMap map : domain.getDataMaps()) {
            DefaultGraphCell mapCell = new DefaultGraphCell();
            this.createdObjects.add(mapCell);
            for (Entity entity : this.getEntities(map)) {
                DefaultGraphCell cell = this.createEntityCell(entity);
                List<DefaultGraphCell> array = !this.isIsolated(domain, entity) ? this.createdObjects : isolatedObjects;
                array.add(cell);
                array.add((DefaultGraphCell)cell.getChildAt(0));
            }
        }
        for (DataMap map : domain.getDataMaps()) {
            for (Entity entity : this.getEntities(map)) {
                DefaultGraphCell sourceCell = this.entityCells.get(entity.getName());
                this.postProcessEntity(entity, sourceCell);
            }
        }
        view.insert(this.createdObjects.toArray());
        this.setLayout(doLayout);
        this.addIsolatedObjects(isolatedObjects);
        view.insert(isolatedObjects.toArray());
        this.graph.getModel().addUndoableEditListener(this);
    }

    private void setLayout(boolean doLayout) {
        if (doLayout) {
            JGraphFacade facade = new JGraphFacade(this.graph);
            JGraphOrganicLayout layout = new JGraphOrganicLayout();
            layout.setNodeDistributionCostFactor(5.0E12);
            layout.setEdgeLengthCostFactor(1000.0);
            layout.setEdgeCrossingCostFactor(1000000.0);
            layout.setOptimizeBorderLine(false);
            layout.setOptimizeEdgeDistance(false);
            layout.run(facade);
            Map nested = facade.createNestedMap(true, true);
            this.edit(nested);
        }
    }

    private void addMouseListeners() {
        this.graph.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseReleased(MouseEvent e) {
                Object userObject;
                Object selected;
                if (e.isPopupTrigger() && (selected = BaseGraphBuilder.this.graph.getSelectionCell()) instanceof DefaultGraphCell && (userObject = ((DefaultGraphCell)selected).getUserObject()) instanceof EntityCellMetadata) {
                    BaseGraphBuilder.this.showPopup(e.getPoint(), ((EntityCellMetadata)userObject).fetchEntity());
                }
            }
        });
        this.graph.addMouseWheelListener(e -> {
            double scale = this.graph.getScale() / Math.pow(1.3, e.getWheelRotation());
            scale = Math.max(scale, 0.1);
            scale = Math.min(scale, 3.0);
            this.graph.setScale(scale);
        });
    }

    private void addIsolatedObjects(List<DefaultGraphCell> isolatedObjects) {
        if (isolatedObjects.size() > 0) {
            int n = isolatedObjects.size() / 2;
            int x = (int)Math.ceil((Math.sqrt(1 + 8 * n) - 1.0) / 2.0);
            Dimension pref = this.graph.getPreferredSize();
            int dx = pref.width / 2 / x;
            int dy = pref.height / 2 / x;
            int posX = dx / 2;
            int posY = dy / 2;
            int row = 0;
            int isolatedIndex = 0;
            while (isolatedIndex < isolatedObjects.size()) {
                for (int i = 0; isolatedIndex < isolatedObjects.size() && i < x - row; ++i) {
                    GraphConstants.setBounds(isolatedObjects.get(isolatedIndex).getAttributes(), new Rectangle2D.Double(pref.width - posX, (double)pref.height - 3.0 * (double)posY / 2.0, 10.0, 10.0));
                    isolatedIndex += 2;
                    posX += dx;
                }
                posX = dx / 2;
                posY += dy / 2;
                ++row;
            }
        }
    }

    protected DefaultGraphCell createEntityCell(E entity) {
        DefaultGraphCell cell = new DefaultGraphCell(this.getCellMetadata(entity));
        GraphConstants.setResize(cell.getAttributes(), true);
        GraphConstants.setBorder(cell.getAttributes(), new LineBorder(Color.BLACK));
        GraphConstants.setEditable(cell.getAttributes(), false);
        this.entityCells.put(((Entity)entity).getName(), cell);
        cell.addPort();
        return cell;
    }

    @Override
    public DefaultGraphCell getEntityCell(String entityName) {
        return this.entityCells.get(entityName);
    }

    protected void postProcessEntity(E entity, DefaultGraphCell cell) {
        for (Relationship rel : ((Entity)entity).getRelationships()) {
            DefaultEdge edge;
            if (rel.getSourceEntity() == null || rel.getTargetEntity() == null || (edge = this.createRelationshipCell(rel)) == null) continue;
            this.createdObjects.add(edge);
        }
    }

    protected boolean isIsolated(DataChannelDescriptor domain, E entity) {
        if (((Entity)entity).getRelationships().size() == 0) {
            for (DataMap map : domain.getDataMaps()) {
                for (Entity source : this.getEntities(map)) {
                    if (source.getAnyRelationship(entity) == null) continue;
                    return false;
                }
            }
            return true;
        }
        return false;
    }

    protected abstract Collection<E> getEntities(DataMap var1);

    private static <E extends Entity<E, A, R>, A extends Attribute<E, A, R>, R extends Relationship<E, A, R>> String getRelationshipLabel(Relationship<E, A, R> rel) {
        if (rel == null) {
            return null;
        }
        if (rel.isToMany()) {
            return "0..*";
        }
        return rel.isMandatory() ? "1" : "0..1";
    }

    protected abstract EntityCellMetadata<E, A, R> getCellMetadata(E var1);

    protected void showPopup(Point p, Entity<E, A, R> entity) {
        this.selectedEntity = entity;
        if (this.popup == null) {
            this.popup = this.createPopupMenu();
        }
        this.popup.show(this.graph, p.x, p.y);
    }

    @Override
    public Entity<E, A, R> getSelectedEntity() {
        return this.selectedEntity;
    }

    protected JPopupMenu createPopupMenu() {
        ActionManager actionManager = Application.getInstance().getActionManager();
        JPopupMenu menu = new JPopupMenu();
        menu.add(new EntityDisplayAction(this).buildMenu());
        menu.addSeparator();
        menu.add(new EntityDisplayAction(this, actionManager.getAction(CreateAttributeAction.class)).buildMenu());
        menu.add(new EntityDisplayAction(this, actionManager.getAction(CreateRelationshipAction.class)).buildMenu());
        menu.addSeparator();
        menu.add(new RemoveEntityAction(this));
        return menu;
    }

    protected void updateEntityCell(E e) {
        DefaultGraphCell cell = this.entityCells.get(((Entity)e).getName());
        if (cell != null) {
            GraphConstants.setValue(cell.getAttributes(), this.getCellMetadata(e));
            GraphConstants.setResize(cell.getAttributes(), true);
            HashMap<DefaultGraphCell, AttributeMap> nested = new HashMap<DefaultGraphCell, AttributeMap>();
            nested.put(cell, cell.getAttributes());
            this.edit(nested);
        }
    }

    protected void updateRelationshipCell(R rel) {
        if (((Relationship)rel).getSourceEntity() != null && ((Relationship)rel).getTargetEntity() != null) {
            DefaultEdge edge = this.relCells.get(BaseGraphBuilder.getQualifiedName(rel));
            if (edge != null) {
                this.updateRelationshipLabels(edge, (Relationship<E, A, R>)rel, ((Relationship)rel).getReverseRelationship());
                HashMap<DefaultEdge, AttributeMap> nested = new HashMap<DefaultEdge, AttributeMap>();
                nested.put(edge, edge.getAttributes());
                this.edit(nested);
            } else {
                this.insertRelationshipCell(rel);
            }
        }
    }

    protected void removeEntityCell(E e) {
        DefaultGraphCell cell = this.entityCells.get(((Entity)e).getName());
        if (cell != null) {
            this.runWithUndoDisabled(() -> this.graph.getGraphLayoutCache().remove(new Object[]{cell}, true, true));
            this.entityCells.remove(((Entity)e).getName());
        }
    }

    protected void removeRelationshipCell(R rel) {
        DefaultEdge edge = this.relCells.get(BaseGraphBuilder.getQualifiedName(rel));
        if (edge != null) {
            this.runWithUndoDisabled(() -> this.graph.getGraphLayoutCache().remove(new Object[]{edge}));
            this.relCells.remove(BaseGraphBuilder.getQualifiedName(rel));
        }
    }

    protected DefaultEdge createRelationshipCell(R rel) {
        if (!this.relCells.containsKey(BaseGraphBuilder.getQualifiedName(rel))) {
            Relationship reverse = ((Relationship)rel).getReverseRelationship();
            DefaultEdge edge = new DefaultEdge();
            GraphConstants.setEditable(edge.getAttributes(), false);
            GraphConstants.setLabelAlongEdge(edge.getAttributes(), true);
            GraphConstants.setSelectable(edge.getAttributes(), false);
            GraphConstants.setFont(edge.getAttributes(), EDGE_FONT);
            this.updateRelationshipLabels(edge, (Relationship<E, A, R>)rel, reverse);
            this.relCells.put(BaseGraphBuilder.getQualifiedName(rel), edge);
            if (reverse != null) {
                this.relCells.put(BaseGraphBuilder.getQualifiedName(reverse), edge);
            }
            return edge;
        }
        return null;
    }

    protected void insertRelationshipCell(R rel) {
        DefaultEdge edge = this.createRelationshipCell(rel);
        this.insert(edge);
    }

    protected void insertEntityCell(E entity) {
        DefaultGraphCell cell = this.createEntityCell(entity);
        GraphConstants.setBounds(cell.getAttributes(), new Rectangle2D.Double(Math.random() * (double)this.graph.getWidth(), Math.random() * (double)this.graph.getHeight(), 10.0, 10.0));
        this.postProcessEntity(entity, cell);
        this.insert(cell);
    }

    protected void updateRelationshipLabels(DefaultEdge edge, Relationship<E, A, R> rel, Relationship<E, A, R> reverse) {
        DefaultGraphCell sourceCell = this.entityCells.get(((Entity)rel.getSourceEntity()).getName());
        DefaultGraphCell targetCell = this.entityCells.get(((Entity)rel.getTargetEntity()).getName());
        edge.setSource(sourceCell != null ? sourceCell.getChildAt(0) : null);
        edge.setTarget(targetCell != null ? targetCell.getChildAt(0) : null);
        Object[] labels = new Object[]{rel.getName() + " " + BaseGraphBuilder.getRelationshipLabel(rel), reverse == null ? "" : reverse.getName() + " " + BaseGraphBuilder.getRelationshipLabel(reverse)};
        GraphConstants.setExtraLabels(edge.getAttributes(), labels);
        Point2D[] labelPositions = new Point2D[]{new Point2D.Double(1000.0 * (0.1 + 0.2 * Math.random()), 10.0), new Point2D.Double(1000.0 * (0.9 - 0.2 * Math.random()), -10.0)};
        GraphConstants.setExtraLabelPositions(edge.getAttributes(), labelPositions);
    }

    @Override
    public JGraph getGraph() {
        return this.graph;
    }

    @Override
    public void dataMapAdded(DataMapEvent e) {
    }

    @Override
    public void dataMapChanged(DataMapEvent e) {
    }

    @Override
    public void dataMapRemoved(DataMapEvent e) {
        for (Entity entity : this.getEntities(e.getDataMap())) {
            this.removeEntityCell(entity);
        }
    }

    public void setProjectController(ProjectController mediator) {
        this.mediator = mediator;
        mediator.addDataMapListener(this);
    }

    public void setDataDomain(DataChannelDescriptor domain) {
        this.domain = domain;
    }

    @Override
    public DataChannelDescriptor getDataDomain() {
        return this.domain;
    }

    @Override
    public void destroy() {
        this.mediator.removeDataMapListener(this);
    }

    protected void remapEntity(EntityEvent e) {
        if (e.isNameChange()) {
            this.entityCells.put(e.getNewName(), this.entityCells.remove(e.getOldName()));
        }
    }

    protected void remapRelationship(RelationshipEvent e) {
        if (e.isNameChange()) {
            this.relCells.put(BaseGraphBuilder.getQualifiedName(e.getRelationship()), this.relCells.remove(e.getEntity().getName() + "." + e.getOldName()));
        }
    }

    static <E extends Entity<E, A, R>, A extends Attribute<E, A, R>, R extends Relationship<E, A, R>> String getQualifiedName(Relationship<E, A, R> rel) {
        return ((Entity)rel.getSourceEntity()).getName() + "." + rel.getName();
    }

    public void encodeAsXML(XMLEncoder encoder, ConfigurationNodeVisitor delegate) {
        encoder.start("graph").attribute("type", this.getType().toString()).attribute("scale", String.valueOf(this.graph.getScale()));
        for (Map.Entry<String, DefaultGraphCell> entry : this.entityCells.entrySet()) {
            Rectangle2D rect = this.graph.getCellBounds(entry.getValue());
            encoder.start("entity").attribute("name", entry.getKey()).attribute("x", String.valueOf((double)Math.round(100.0 * rect.getX()) / 100.0)).attribute("y", String.valueOf((double)Math.round(100.0 * rect.getY()) / 100.0)).attribute("width", String.valueOf(rect.getWidth())).attribute("height", String.valueOf(rect.getHeight())).end();
        }
        encoder.end();
    }

    private void edit(Map<?, ?> map) {
        this.runWithUndoDisabled(() -> this.graph.getGraphLayoutCache().edit(map));
    }

    private void insert(Object cell) {
        this.runWithUndoDisabled(() -> this.graph.getGraphLayoutCache().insert(cell));
    }

    private void runWithUndoDisabled(Runnable r) {
        this.undoEventsDisabled = true;
        try {
            r.run();
        }
        finally {
            this.undoEventsDisabled = false;
        }
    }

    @Override
    public void undoableEditHappened(UndoableEditEvent e) {
        if (!this.undoEventsDisabled) {
            this.mediator.setDirty(true);
            Application.getInstance().getUndoManager().undoableEditHappened(e);
        }
    }
}

