/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.modeler;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Toolkit;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.util.List;
import java.util.Vector;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JPanel;
import javax.swing.JSplitPane;
import javax.swing.JTextField;
import org.apache.cayenne.modeler.Application;
import org.apache.cayenne.modeler.action.AboutAction;
import org.apache.cayenne.modeler.action.ActionManager;
import org.apache.cayenne.modeler.action.ConfigurePreferencesAction;
import org.apache.cayenne.modeler.action.CopyAction;
import org.apache.cayenne.modeler.action.CreateDataMapAction;
import org.apache.cayenne.modeler.action.CreateDbEntityAction;
import org.apache.cayenne.modeler.action.CreateEmbeddableAction;
import org.apache.cayenne.modeler.action.CreateNodeAction;
import org.apache.cayenne.modeler.action.CreateObjEntityAction;
import org.apache.cayenne.modeler.action.CreateProcedureAction;
import org.apache.cayenne.modeler.action.CreateQueryAction;
import org.apache.cayenne.modeler.action.CutAction;
import org.apache.cayenne.modeler.action.DbEntitySyncAction;
import org.apache.cayenne.modeler.action.DocumentationAction;
import org.apache.cayenne.modeler.action.ExitAction;
import org.apache.cayenne.modeler.action.FindAction;
import org.apache.cayenne.modeler.action.GenerateCodeAction;
import org.apache.cayenne.modeler.action.GenerateDBAction;
import org.apache.cayenne.modeler.action.ImportDataMapAction;
import org.apache.cayenne.modeler.action.ImportEOModelAction;
import org.apache.cayenne.modeler.action.InferRelationshipsAction;
import org.apache.cayenne.modeler.action.MigrateAction;
import org.apache.cayenne.modeler.action.NavigateBackwardAction;
import org.apache.cayenne.modeler.action.NavigateForwardAction;
import org.apache.cayenne.modeler.action.NewProjectAction;
import org.apache.cayenne.modeler.action.ObjEntitySyncAction;
import org.apache.cayenne.modeler.action.OpenProjectAction;
import org.apache.cayenne.modeler.action.PasteAction;
import org.apache.cayenne.modeler.action.ProjectAction;
import org.apache.cayenne.modeler.action.RedoAction;
import org.apache.cayenne.modeler.action.RemoveAction;
import org.apache.cayenne.modeler.action.RevertAction;
import org.apache.cayenne.modeler.action.SaveAction;
import org.apache.cayenne.modeler.action.SaveAsAction;
import org.apache.cayenne.modeler.action.ShowLogConsoleAction;
import org.apache.cayenne.modeler.action.ShowValidationConfigAction;
import org.apache.cayenne.modeler.action.UndoAction;
import org.apache.cayenne.modeler.action.ValidateAction;
import org.apache.cayenne.modeler.action.dbimport.ReverseEngineeringToolMenuAction;
import org.apache.cayenne.modeler.dialog.LogConsole;
import org.apache.cayenne.modeler.dialog.welcome.WelcomeScreen;
import org.apache.cayenne.modeler.editor.EditorView;
import org.apache.cayenne.modeler.event.DataMapDisplayEvent;
import org.apache.cayenne.modeler.event.DataMapDisplayListener;
import org.apache.cayenne.modeler.event.DataNodeDisplayEvent;
import org.apache.cayenne.modeler.event.DataNodeDisplayListener;
import org.apache.cayenne.modeler.event.DbEntityDisplayListener;
import org.apache.cayenne.modeler.event.EmbeddableDisplayEvent;
import org.apache.cayenne.modeler.event.EmbeddableDisplayListener;
import org.apache.cayenne.modeler.event.EntityDisplayEvent;
import org.apache.cayenne.modeler.event.MultipleObjectsDisplayEvent;
import org.apache.cayenne.modeler.event.MultipleObjectsDisplayListener;
import org.apache.cayenne.modeler.event.ObjEntityDisplayListener;
import org.apache.cayenne.modeler.event.ProcedureDisplayEvent;
import org.apache.cayenne.modeler.event.ProcedureDisplayListener;
import org.apache.cayenne.modeler.event.QueryDisplayEvent;
import org.apache.cayenne.modeler.event.QueryDisplayListener;
import org.apache.cayenne.modeler.event.RecentFileListListener;
import org.apache.cayenne.modeler.pref.ComponentGeometry;
import org.apache.cayenne.modeler.util.ModelerUtil;
import org.apache.cayenne.modeler.util.RecentFileMenu;
import org.apache.cayenne.swing.components.MainToolBar;
import org.apache.cayenne.swing.components.TopBorder;
import org.slf4j.LoggerFactory;

public class CayenneModelerFrame
extends JFrame
implements DataNodeDisplayListener,
DataMapDisplayListener,
ObjEntityDisplayListener,
DbEntityDisplayListener,
QueryDisplayListener,
ProcedureDisplayListener,
MultipleObjectsDisplayListener,
EmbeddableDisplayListener {
    protected EditorView view;
    protected RecentFileMenu recentFileMenu;
    protected ActionManager actionManager;
    protected JLabel status;
    protected JCheckBoxMenuItem logMenu;
    protected JSplitPane splitPane;
    protected Component dockComponent;
    protected List<RecentFileListListener> recentFileListeners;
    protected WelcomeScreen welcomeScreen;

    public CayenneModelerFrame(ActionManager actionManager) {
        this.actionManager = actionManager;
        this.recentFileListeners = new Vector<RecentFileListListener>();
        this.setIconImage(ModelerUtil.buildIcon("CayenneModeler.png").getImage());
        this.initMenus();
        this.initToolbar();
        this.initStatusBar();
        this.initWelcome();
        this.fireRecentFileListChanged();
        this.setView(null);
    }

    private <T extends Action> T getAction(Class<T> type) {
        return this.actionManager.getAction(type);
    }

    protected void initMenus() {
        this.getContentPane().setLayout(new BorderLayout());
        JMenu fileMenu = new JMenu("File");
        JMenu editMenu = new JMenu("Edit");
        JMenu projectMenu = new JMenu("Project");
        JMenu toolMenu = new JMenu("Tools");
        JMenu helpMenu = new JMenu("Help");
        fileMenu.setMnemonic(70);
        editMenu.setMnemonic(69);
        projectMenu.setMnemonic(80);
        toolMenu.setMnemonic(84);
        helpMenu.setMnemonic(72);
        fileMenu.add(this.getAction(NewProjectAction.class).buildMenu());
        fileMenu.add(this.getAction(OpenProjectAction.class).buildMenu());
        fileMenu.add(this.getAction(ProjectAction.class).buildMenu());
        fileMenu.add(this.getAction(ImportDataMapAction.class).buildMenu());
        fileMenu.addSeparator();
        fileMenu.add(this.getAction(SaveAction.class).buildMenu());
        fileMenu.add(this.getAction(SaveAsAction.class).buildMenu());
        fileMenu.add(this.getAction(RevertAction.class).buildMenu());
        fileMenu.addSeparator();
        editMenu.add(this.getAction(UndoAction.class).buildMenu());
        editMenu.add(this.getAction(RedoAction.class).buildMenu());
        editMenu.add(this.getAction(CutAction.class).buildMenu());
        editMenu.add(this.getAction(CopyAction.class).buildMenu());
        editMenu.add(this.getAction(PasteAction.class).buildMenu());
        this.recentFileMenu = new RecentFileMenu("Recent Projects");
        this.addRecentFileListListener(this.recentFileMenu);
        fileMenu.add(this.recentFileMenu);
        fileMenu.addSeparator();
        fileMenu.add(this.getAction(ExitAction.class).buildMenu());
        projectMenu.add(this.getAction(ValidateAction.class).buildMenu());
        projectMenu.add(this.getAction(ShowValidationConfigAction.class).buildMenu());
        projectMenu.addSeparator();
        projectMenu.add(this.getAction(CreateNodeAction.class).buildMenu());
        projectMenu.add(this.getAction(CreateDataMapAction.class).buildMenu());
        projectMenu.add(this.getAction(CreateObjEntityAction.class).buildMenu());
        projectMenu.add(this.getAction(CreateEmbeddableAction.class).buildMenu());
        projectMenu.add(this.getAction(CreateDbEntityAction.class).buildMenu());
        projectMenu.add(this.getAction(CreateProcedureAction.class).buildMenu());
        projectMenu.add(this.getAction(CreateQueryAction.class).buildMenu());
        projectMenu.addSeparator();
        projectMenu.add(this.getAction(ObjEntitySyncAction.class).buildMenu());
        projectMenu.add(this.getAction(DbEntitySyncAction.class).buildMenu());
        projectMenu.addSeparator();
        projectMenu.add(this.getAction(RemoveAction.class).buildMenu());
        toolMenu.add(this.getAction(ReverseEngineeringToolMenuAction.class).buildMenu());
        toolMenu.add(this.getAction(InferRelationshipsAction.class).buildMenu());
        toolMenu.add(this.getAction(ImportEOModelAction.class).buildMenu());
        toolMenu.addSeparator();
        toolMenu.add(this.getAction(GenerateCodeAction.class).buildMenu());
        toolMenu.add(this.getAction(GenerateDBAction.class).buildMenu());
        toolMenu.add(this.getAction(MigrateAction.class).buildMenu());
        toolMenu.addSeparator();
        this.logMenu = this.getAction(ShowLogConsoleAction.class).buildCheckBoxMenu();
        if (!LogConsole.getInstance().getConsoleProperty("log.console.docked") && LogConsole.getInstance().getConsoleProperty("show.log.console")) {
            LogConsole.getInstance().setConsoleProperty("show.log.console", false);
        }
        this.updateLogConsoleMenu();
        toolMenu.add(this.logMenu);
        toolMenu.addSeparator();
        toolMenu.add(this.getAction(ConfigurePreferencesAction.class).buildMenu());
        helpMenu.add(this.getAction(AboutAction.class).buildMenu());
        helpMenu.add(this.getAction(DocumentationAction.class).buildMenu());
        JMenuBar menuBar = new JMenuBar();
        menuBar.add(fileMenu);
        menuBar.add(editMenu);
        menuBar.add(projectMenu);
        menuBar.add(toolMenu);
        menuBar.add(helpMenu);
        this.setJMenuBar(menuBar);
    }

    public void updateLogConsoleMenu() {
        this.logMenu.setSelected(LogConsole.getInstance().getConsoleProperty("show.log.console"));
    }

    protected void initStatusBar() {
        this.status = new JLabel();
        this.status.setFont(this.status.getFont().deriveFont(0, 10.0f));
        this.splitPane = new JSplitPane(0);
        this.splitPane.setBorder(TopBorder.create());
        this.splitPane.getInsets().left = 5;
        this.splitPane.getInsets().right = 5;
        this.splitPane.setResizeWeight(0.7);
        try {
            ComponentGeometry geometry = new ComponentGeometry(this.getClass(), "splitPane/divider");
            geometry.bindIntProperty(this.splitPane, "dividerLocation", 400);
        }
        catch (Exception ex) {
            LoggerFactory.getLogger(this.getClass()).error("Cannot bind divider property", ex);
        }
        JPanel statusBar = new JPanel(new FlowLayout(0, 3, 1));
        statusBar.setBorder(TopBorder.create());
        statusBar.add(Box.createVerticalStrut(16));
        statusBar.add(this.status);
        if (this.getContentPane() instanceof JPanel) {
            ((JPanel)this.getContentPane()).setBorder(BorderFactory.createEmptyBorder());
        }
        this.getContentPane().add((Component)this.splitPane, "Center");
        this.getContentPane().add((Component)statusBar, "South");
    }

    protected void initWelcome() {
        this.welcomeScreen = new WelcomeScreen();
        this.addRecentFileListListener(this.welcomeScreen);
    }

    public void setDockComponent(Component c) {
        if (this.dockComponent == c) {
            return;
        }
        if (this.dockComponent != null) {
            this.splitPane.setBottomComponent(null);
        }
        this.dockComponent = c;
        if (this.dockComponent != null) {
            this.splitPane.setBottomComponent(this.dockComponent);
        }
        this.splitPane.validate();
    }

    public Component getDockComponent() {
        return this.dockComponent;
    }

    protected void initToolbar() {
        final MainToolBar toolBar = new MainToolBar();
        Dimension smallBtnDim = new Dimension(30, 30);
        JButton backButton = this.getAction(NavigateBackwardAction.class).buildButton(1);
        backButton.setMinimumSize(smallBtnDim);
        backButton.setPreferredSize(smallBtnDim);
        toolBar.add(backButton);
        JButton forwardButton = this.getAction(NavigateForwardAction.class).buildButton(3);
        forwardButton.setMinimumSize(smallBtnDim);
        forwardButton.setPreferredSize(smallBtnDim);
        toolBar.add(forwardButton);
        toolBar.addSeparator(new Dimension(30, 0));
        toolBar.add(this.getAction(NewProjectAction.class).buildButton(1));
        toolBar.add(this.getAction(OpenProjectAction.class).buildButton(2));
        toolBar.add(this.getAction(SaveAction.class).buildButton(3));
        toolBar.addSeparator();
        JButton removeButton = this.getAction(RemoveAction.class).buildButton();
        toolBar.add(removeButton);
        toolBar.addSeparator();
        toolBar.add(this.getAction(CutAction.class).buildButton(1));
        toolBar.add(this.getAction(CopyAction.class).buildButton(2));
        toolBar.add(this.getAction(PasteAction.class).buildButton(3));
        toolBar.addSeparator();
        toolBar.add(this.getAction(UndoAction.class).buildButton(1));
        toolBar.add(this.getAction(RedoAction.class).buildButton(3));
        toolBar.addSeparator();
        toolBar.add(this.getAction(CreateNodeAction.class).buildButton(1));
        toolBar.add(this.getAction(CreateDataMapAction.class).buildButton(3));
        toolBar.addSeparator();
        toolBar.add(this.getAction(CreateDbEntityAction.class).buildButton(1));
        toolBar.add(this.getAction(CreateProcedureAction.class).buildButton(3));
        toolBar.addSeparator();
        toolBar.add(this.getAction(CreateObjEntityAction.class).buildButton(1));
        toolBar.add(this.getAction(CreateEmbeddableAction.class).buildButton(2));
        toolBar.add(this.getAction(CreateQueryAction.class).buildButton(3));
        toolBar.add(new SearchPanel());
        this.getContentPane().add((Component)toolBar, "North");
        final int defaultBtnWidth = removeButton.getUI().getPreferredSize((JComponent)backButton).width;
        this.addComponentListener(new ComponentAdapter(){
            private final int[] empty = new int[0];
            private final int[] all = new int[]{6, 7, 8, 9, 10, 11, 12, 13, 14};
            private final int[] remove = new int[]{6, 7};
            private final int[] removeAndCopy = new int[]{6, 7, 8, 9, 10, 11};
            private final int[] undo = new int[]{12, 13, 14};
            private final int[] undoAndCopy = new int[]{8, 9, 10, 11, 12, 13, 14};

            @Override
            public void componentResized(ComponentEvent e) {
                int[] shown;
                int[] hidden;
                if (CayenneModelerFrame.this.getSize().width < 13 * defaultBtnWidth + 300) {
                    hidden = this.all;
                    shown = this.empty;
                } else if (CayenneModelerFrame.this.getSize().width < 16 * defaultBtnWidth + 300) {
                    hidden = this.removeAndCopy;
                    shown = this.undo;
                } else if (CayenneModelerFrame.this.getSize().width < 18 * defaultBtnWidth + 300) {
                    hidden = this.remove;
                    shown = this.undoAndCopy;
                } else {
                    hidden = this.empty;
                    shown = this.all;
                }
                for (int i : hidden) {
                    toolBar.getComponentAtIndex(i).setVisible(false);
                }
                for (int i : shown) {
                    toolBar.getComponentAtIndex(i).setVisible(true);
                }
            }
        });
    }

    @Override
    public void currentDataNodeChanged(DataNodeDisplayEvent e) {
        this.actionManager.dataNodeSelected();
    }

    @Override
    public void currentDataMapChanged(DataMapDisplayEvent e) {
        this.actionManager.dataMapSelected();
    }

    @Override
    public void currentObjEntityChanged(EntityDisplayEvent e) {
        this.actionManager.objEntitySelected();
    }

    @Override
    public void currentDbEntityChanged(EntityDisplayEvent e) {
        this.actionManager.dbEntitySelected();
    }

    @Override
    public void currentQueryChanged(QueryDisplayEvent e) {
        this.actionManager.querySelected();
    }

    @Override
    public void currentProcedureChanged(ProcedureDisplayEvent e) {
        this.actionManager.procedureSelected();
    }

    @Override
    public void currentObjectsChanged(MultipleObjectsDisplayEvent e, Application application) {
        this.actionManager.multipleObjectsSelected(e.getNodes(), application);
    }

    @Override
    public void currentEmbeddableChanged(EmbeddableDisplayEvent e) {
        this.actionManager.embeddableSelected();
    }

    public EditorView getView() {
        return this.view;
    }

    public JLabel getStatus() {
        return this.status;
    }

    public RecentFileMenu getRecentFileMenu() {
        return this.recentFileMenu;
    }

    public void setView(EditorView view) {
        int oldLocation = this.splitPane.getDividerLocation();
        this.view = view;
        if (view != null) {
            this.splitPane.setTopComponent(view);
        } else {
            this.splitPane.setTopComponent(this.welcomeScreen);
        }
        this.validate();
        this.splitPane.setDividerLocation(oldLocation);
    }

    public void addRecentFileListListener(RecentFileListListener listener) {
        this.recentFileListeners.add(listener);
    }

    public void fireRecentFileListChanged() {
        for (RecentFileListListener recentFileListener : this.recentFileListeners) {
            recentFileListener.recentFileListChanged();
        }
    }

    public class SearchPanel
    extends JPanel {
        private JLabel searchLabel;
        private JPanel box;
        private JTextField findField;

        SearchPanel() {
            super(new BorderLayout());
            this.searchLabel = new JLabel("Search: ");
            this.box = new JPanel();
            this.initView();
        }

        void initView() {
            this.findField = new JTextField(10);
            this.findField.putClientProperty("JTextField.variant", "search");
            this.findField.setMaximumSize(new Dimension(100, 22));
            this.findField.setPreferredSize(new Dimension(100, 22));
            this.findField.addKeyListener(new KeyListener(){

                @Override
                public void keyPressed(KeyEvent e) {
                    if (e.getKeyCode() != 10) {
                        SearchPanel.this.findField.setBackground(Color.white);
                    }
                }

                @Override
                public void keyReleased(KeyEvent e) {
                }

                @Override
                public void keyTyped(KeyEvent e) {
                }
            });
            this.findField.setAction(CayenneModelerFrame.this.getAction(FindAction.class));
            Toolkit.getDefaultToolkit().addAWTEventListener(event -> {
                if (event instanceof KeyEvent && ((KeyEvent)event).getModifiersEx() == Toolkit.getDefaultToolkit().getMenuShortcutKeyMaskEx() && ((KeyEvent)event).getKeyCode() == 70) {
                    this.findField.requestFocus();
                }
            }, 8L);
            this.searchLabel.setLabelFor(this.findField);
            this.box.setLayout(new BoxLayout(this.box, 0));
            this.box.add(this.searchLabel);
            this.box.add(this.findField);
            this.add((Component)this.box, "East");
        }

        public void hideSearchLabel() {
            this.searchLabel.setVisible(false);
            this.findField.setMaximumSize(null);
            this.findField.setPreferredSize(new Dimension(100, 40));
            this.findField.setToolTipText("Search");
            this.box.setOpaque(false);
            this.box.setBackground(null);
        }
    }
}

