/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.dbsync.merge.token.db;

import java.util.Collections;
import java.util.List;
import org.apache.cayenne.dba.DbAdapter;
import org.apache.cayenne.dbsync.merge.factory.MergerTokenFactory;
import org.apache.cayenne.dbsync.merge.token.MergerToken;
import org.apache.cayenne.dbsync.merge.token.db.AbstractToDbToken;
import org.apache.cayenne.map.DbEntity;
import org.apache.cayenne.map.DbRelationship;

public class AddRelationshipToDb
extends AbstractToDbToken.Entity {
    private DbRelationship relationship;

    public AddRelationshipToDb(DbEntity entity, DbRelationship relationship) {
        super("Add foreign key", 120, entity);
        this.relationship = relationship;
    }

    @Override
    public List<String> createSql(DbAdapter adapter) {
        String fksql;
        if (!this.isEmpty() && (fksql = adapter.createFkConstraint(this.relationship)) != null) {
            return Collections.singletonList(fksql);
        }
        return Collections.emptyList();
    }

    @Override
    public MergerToken createReverse(MergerTokenFactory factory) {
        return factory.createDropRelationshipToModel(this.getEntity(), this.relationship);
    }

    @Override
    public String getTokenValue() {
        if (!this.isEmpty()) {
            return ((DbEntity)this.relationship.getSourceEntity()).getName() + "->" + this.relationship.getTargetEntityName();
        }
        return "Skip. No sql representation.";
    }

    @Override
    public boolean isEmpty() {
        return this.relationship.isSourceIndependentFromTargetChange();
    }
}

