/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.project.validation;

import java.util.List;
import java.util.function.Supplier;
import org.apache.cayenne.map.DataMap;
import org.apache.cayenne.map.Procedure;
import org.apache.cayenne.project.validation.ConfigurationNodeValidator;
import org.apache.cayenne.project.validation.Inspection;
import org.apache.cayenne.project.validation.ValidationConfig;
import org.apache.cayenne.util.Util;
import org.apache.cayenne.validation.ValidationResult;

class ProcedureValidator
extends ConfigurationNodeValidator<Procedure> {
    public ProcedureValidator(Supplier<ValidationConfig> configSupplier) {
        super(configSupplier);
    }

    @Override
    public void validate(Procedure node, ValidationResult validationResult) {
        this.on(node, validationResult).performIfEnabled(Inspection.PROCEDURE_NO_NAME, this::checkForName).performIfEnabled(Inspection.PROCEDURE_NAME_DUPLICATE, this::checkForDuplicateName).performIfEnabled(Inspection.PROCEDURE_NO_PARAMS, this::checkForParams);
    }

    private void checkForName(Procedure procedure, ValidationResult validationResult) {
        String name = procedure.getName();
        if (Util.isEmptyString((CharSequence)name)) {
            this.addFailure(validationResult, procedure, "Unnamed Procedure", new Object[0]);
        }
    }

    private void checkForDuplicateName(Procedure procedure, ValidationResult validationResult) {
        String name = procedure.getName();
        DataMap map = procedure.getDataMap();
        if (map == null || Util.isEmptyString((CharSequence)name)) {
            return;
        }
        for (Procedure otherProcedure : map.getProcedures()) {
            if (otherProcedure == procedure || !name.equals(otherProcedure.getName())) continue;
            this.addFailure(validationResult, procedure, "Duplicate Procedure name: %s", procedure.getName());
            return;
        }
    }

    private void checkForParams(Procedure procedure, ValidationResult validationResult) {
        if (!procedure.isReturningValue()) {
            return;
        }
        List parameters = procedure.getCallParameters();
        if (parameters.isEmpty()) {
            this.addFailure(validationResult, procedure, "Procedure '%s' returns a value, but has no parameters", procedure.getName());
        }
    }
}

