/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.dba.sybase;

import java.sql.CallableStatement;
import java.sql.Connection;
import java.sql.ResultSet;
import java.util.ArrayList;
import java.util.List;
import org.apache.cayenne.CayenneRuntimeException;
import org.apache.cayenne.access.DataNode;
import org.apache.cayenne.dba.JdbcAdapter;
import org.apache.cayenne.dba.JdbcPkGenerator;
import org.apache.cayenne.map.DbEntity;
import org.apache.cayenne.tx.BaseTransaction;
import org.apache.cayenne.tx.Transaction;

public class SybasePkGenerator
extends JdbcPkGenerator {
    public SybasePkGenerator() {
    }

    protected SybasePkGenerator(JdbcAdapter adapter) {
        super(adapter);
    }

    @Override
    protected String pkTableCreateString() {
        return "CREATE TABLE AUTO_PK_SUPPORT (TABLE_NAME CHAR(100) NOT NULL, NEXT_ID DECIMAL(19,0) NOT NULL, PRIMARY KEY(TABLE_NAME))";
    }

    @Override
    public void createAutoPk(DataNode node, List<DbEntity> dbEntities) throws Exception {
        super.createAutoPk(node, dbEntities);
        this.runUpdate(node, this.safePkProcDrop());
        this.runUpdate(node, this.unsafePkProcCreate());
    }

    @Override
    public List<String> createAutoPkStatements(List<DbEntity> dbEntities) {
        List<String> list = super.createAutoPkStatements(dbEntities);
        list.add(this.safePkProcDrop());
        list.add(this.unsafePkProcCreate());
        return list;
    }

    @Override
    public void dropAutoPk(DataNode node, List<DbEntity> dbEntities) throws Exception {
        this.runUpdate(node, this.safePkProcDrop());
        this.runUpdate(node, this.safePkTableDrop());
    }

    @Override
    public List<String> dropAutoPkStatements(List<DbEntity> dbEntities) {
        ArrayList<String> list = new ArrayList<String>();
        list.add(this.safePkProcDrop());
        list.add(this.safePkTableDrop());
        return list;
    }

    @Override
    protected long longPkFromDatabase(DataNode node, DbEntity entity) throws Exception {
        Transaction transaction = BaseTransaction.getThreadTransaction();
        BaseTransaction.bindThreadTransaction(null);
        try (Connection connection = node.getDataSource().getConnection();
             CallableStatement statement = connection.prepareCall("{call auto_pk_for_table(?, ?)}");){
            statement.setString(1, entity.getName());
            statement.setInt(2, this.getPkCacheSize());
            statement.execute();
            if (statement.getMoreResults()) {
                try (ResultSet rs = statement.getResultSet();){
                    if (rs.next()) {
                        long l = rs.getLong(1);
                        return l;
                    }
                    throw new CayenneRuntimeException("Error generating pk for DbEntity %s", entity.getName());
                }
            }
            throw new CayenneRuntimeException("Error generating pk for DbEntity %s, no result set from stored procedure.", entity.getName());
        }
        finally {
            BaseTransaction.bindThreadTransaction(transaction);
        }
    }

    private String safePkTableDrop() {
        return "if exists (SELECT * FROM sysobjects WHERE name = 'AUTO_PK_SUPPORT') BEGIN  DROP TABLE AUTO_PK_SUPPORT END";
    }

    private String unsafePkProcCreate() {
        return " CREATE PROCEDURE auto_pk_for_table @tname VARCHAR(32), @pkbatchsize INT AS BEGIN BEGIN TRANSACTION UPDATE AUTO_PK_SUPPORT set NEXT_ID = NEXT_ID + @pkbatchsize WHERE TABLE_NAME = @tname SELECT NEXT_ID FROM AUTO_PK_SUPPORT WHERE TABLE_NAME = @tname COMMIT END";
    }

    private String safePkProcDrop() {
        return "if exists (SELECT * FROM sysobjects WHERE name = 'auto_pk_for_table') BEGIN DROP PROCEDURE auto_pk_for_table END";
    }
}

