/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.configuration.xml;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URL;
import java.util.Arrays;
import org.apache.cayenne.ConfigurationException;
import org.apache.cayenne.configuration.ConfigurationNameMapper;
import org.apache.cayenne.configuration.ConfigurationTree;
import org.apache.cayenne.configuration.DataChannelDescriptor;
import org.apache.cayenne.configuration.DataChannelDescriptorLoader;
import org.apache.cayenne.configuration.DataMapLoader;
import org.apache.cayenne.configuration.xml.DataChannelHandler;
import org.apache.cayenne.configuration.xml.HandlerFactory;
import org.apache.cayenne.configuration.xml.LoaderContext;
import org.apache.cayenne.di.AdhocObjectFactory;
import org.apache.cayenne.di.Inject;
import org.apache.cayenne.di.Provider;
import org.apache.cayenne.resource.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xml.sax.InputSource;
import org.xml.sax.XMLReader;

public class XMLDataChannelDescriptorLoader
implements DataChannelDescriptorLoader {
    private static final Logger logger = LoggerFactory.getLogger(XMLDataChannelDescriptorLoader.class);
    static final String[] SUPPORTED_PROJECT_VERSIONS = new String[]{"10"};
    @Inject
    protected Provider<XMLReader> xmlReaderProvider;
    @Inject
    protected DataMapLoader dataMapLoader;
    @Inject
    protected ConfigurationNameMapper nameMapper;
    @Inject
    protected AdhocObjectFactory objectFactory;
    @Inject
    protected HandlerFactory handlerFactory;

    @Deprecated
    static String passwordFromURL(URL url) {
        String password = null;
        try {
            InputStream inputStream = url.openStream();
            password = XMLDataChannelDescriptorLoader.passwordFromInputStream(inputStream);
        }
        catch (IOException exception) {
            logger.warn(exception.getMessage(), exception);
        }
        return password;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Deprecated
    static String passwordFromInputStream(InputStream inputStream) {
        String password = null;
        try (BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(inputStream));){
            password = bufferedReader.readLine();
        }
        catch (IOException exception) {
            logger.warn(exception.getMessage(), exception);
        }
        finally {
            try {
                inputStream.close();
            }
            catch (IOException iOException) {}
        }
        return password;
    }

    @Override
    public ConfigurationTree<DataChannelDescriptor> load(Resource configurationResource) throws ConfigurationException {
        if (configurationResource == null) {
            throw new NullPointerException("Null configurationResource");
        }
        URL configurationURL = configurationResource.getURL();
        logger.info("Loading XML configuration resource from " + configurationURL);
        DataChannelDescriptor descriptor = new DataChannelDescriptor();
        descriptor.setConfigurationSource(configurationResource);
        descriptor.setName(this.nameMapper.configurationNodeName(DataChannelDescriptor.class, configurationResource));
        try (InputStream in = configurationURL.openStream();){
            XMLReader parser = this.xmlReaderProvider.get();
            LoaderContext loaderContext = new LoaderContext(parser, this.handlerFactory);
            loaderContext.addDataMapListener(dataMap -> descriptor.getDataMaps().add(dataMap));
            DataChannelHandler rootHandler = new DataChannelHandler(this, descriptor, loaderContext);
            parser.setContentHandler(rootHandler);
            parser.setErrorHandler(rootHandler);
            InputSource input = new InputSource(in);
            input.setSystemId(configurationURL.toString());
            parser.parse(input);
            loaderContext.dataChannelLoaded(descriptor);
        }
        catch (Exception e) {
            throw new ConfigurationException("Error loading configuration from %s", (Throwable)e, configurationURL);
        }
        return new ConfigurationTree<DataChannelDescriptor>(descriptor, null);
    }

    static {
        Arrays.sort(SUPPORTED_PROJECT_VERSIONS);
    }
}

