/*
 * Decompiled with CFR 0.152.
 */
package org.openjdk.tools.javac.util;

import java.util.EnumSet;
import org.openjdk.tools.javac.code.Lint;
import org.openjdk.tools.javac.util.JCDiagnostic;

public class Warner {
    private JCDiagnostic.DiagnosticPosition pos = null;
    protected boolean warned = false;
    private EnumSet<Lint.LintCategory> nonSilentLintSet = EnumSet.noneOf(Lint.LintCategory.class);
    private EnumSet<Lint.LintCategory> silentLintSet = EnumSet.noneOf(Lint.LintCategory.class);

    public JCDiagnostic.DiagnosticPosition pos() {
        return this.pos;
    }

    public void warn(Lint.LintCategory lintCategory) {
        this.nonSilentLintSet.add(lintCategory);
    }

    public void silentWarn(Lint.LintCategory lintCategory) {
        this.silentLintSet.add(lintCategory);
    }

    public Warner(JCDiagnostic.DiagnosticPosition diagnosticPosition) {
        this.pos = diagnosticPosition;
    }

    public boolean hasSilentLint(Lint.LintCategory lintCategory) {
        return this.silentLintSet.contains((Object)lintCategory);
    }

    public boolean hasNonSilentLint(Lint.LintCategory lintCategory) {
        return this.nonSilentLintSet.contains((Object)lintCategory);
    }

    public boolean hasLint(Lint.LintCategory lintCategory) {
        return this.hasSilentLint(lintCategory) || this.hasNonSilentLint(lintCategory);
    }

    public void clear() {
        this.nonSilentLintSet.clear();
        this.silentLintSet.clear();
        this.warned = false;
    }

    public Warner() {
        this(null);
    }
}

