/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axis2.transport.base;

import org.apache.axis2.AxisFault;
import org.apache.axis2.description.AxisService;
import org.apache.axis2.description.Parameter;
import org.apache.axis2.description.ParameterInclude;
import org.apache.axis2.description.TransportInDescription;
import org.apache.axis2.description.TransportOutDescription;
import org.apache.axis2.util.JavaUtils;

public class ParamUtils {
    private ParamUtils() {
    }

    public static String getRequiredParam(ParameterInclude paramInclude, String paramName) throws AxisFault {
        Parameter param = paramInclude.getParameter(paramName);
        if (param != null && param.getValue() != null && param.getValue() instanceof String) {
            return (String)param.getValue();
        }
        throw new AxisFault("Cannot find parameter '" + paramName + "' for " + ParamUtils.getDescriptionFor(paramInclude));
    }

    public static String getOptionalParam(ParameterInclude paramInclude, String paramName) throws AxisFault {
        Parameter param = paramInclude.getParameter(paramName);
        if (param != null && param.getValue() != null && param.getValue() instanceof String) {
            return (String)param.getValue();
        }
        return null;
    }

    public static Integer getOptionalParamInt(ParameterInclude paramInclude, String paramName) throws AxisFault {
        Parameter param = paramInclude.getParameter(paramName);
        if (param == null || param.getValue() == null) {
            return null;
        }
        Object paramValue = param.getValue();
        if (paramValue instanceof Integer) {
            return (Integer)paramValue;
        }
        if (paramValue instanceof String) {
            try {
                return Integer.valueOf((String)paramValue);
            }
            catch (NumberFormatException ex) {
                throw new AxisFault("Invalid value '" + String.valueOf(paramValue) + "' for parameter '" + paramName + "' for " + ParamUtils.getDescriptionFor(paramInclude));
            }
        }
        throw new AxisFault("Invalid type for parameter '" + paramName + "' for " + ParamUtils.getDescriptionFor(paramInclude));
    }

    public static int getOptionalParamInt(ParameterInclude paramInclude, String paramName, int defaultValue) throws AxisFault {
        Integer value = ParamUtils.getOptionalParamInt(paramInclude, paramName);
        return value == null ? defaultValue : value;
    }

    public static boolean getOptionalParamBoolean(ParameterInclude paramInclude, String paramName, boolean defaultValue) throws AxisFault {
        Parameter param = paramInclude.getParameter(paramName);
        return param == null ? defaultValue : JavaUtils.isTrueExplicitly((Object)param.getValue(), (boolean)defaultValue);
    }

    public static int getRequiredParamInt(ParameterInclude paramInclude, String paramName) throws AxisFault {
        Integer value = ParamUtils.getOptionalParamInt(paramInclude, paramName);
        if (value == null) {
            throw new AxisFault("Cannot find parameter '" + paramName + "' for " + ParamUtils.getDescriptionFor(paramInclude));
        }
        return value;
    }

    private static String getDescriptionFor(ParameterInclude paramInclude) {
        if (paramInclude instanceof AxisService) {
            return "service '" + ((AxisService)paramInclude).getName() + "'";
        }
        if (paramInclude instanceof TransportInDescription) {
            return "transport receiver '" + ((TransportInDescription)paramInclude).getName() + "'";
        }
        if (paramInclude instanceof TransportOutDescription) {
            return "transport sender '" + ((TransportOutDescription)paramInclude).getName() + "'";
        }
        return paramInclude.getClass().getName();
    }
}

