/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axis2.jaxws.addressing.util;

import javax.xml.namespace.QName;

public class EndpointKey {
    private final QName service;
    private final QName endpoint;

    public EndpointKey(QName service, QName endpoint) {
        if (service == null) {
            throw new IllegalArgumentException("The service qname cannot be null.");
        }
        if (endpoint == null) {
            throw new IllegalArgumentException("The endpoint qname cannot be null.");
        }
        this.service = service;
        this.endpoint = endpoint;
    }

    public QName getEndpoint() {
        return this.endpoint;
    }

    public QName getService() {
        return this.service;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        EndpointKey other = (EndpointKey)obj;
        if (this.endpoint == null ? other.endpoint != null : !this.endpoint.equals(other.endpoint)) {
            return false;
        }
        return !(this.service == null ? other.service != null : !this.service.equals(other.service));
    }

    public int hashCode() {
        int PRIME = 31;
        int result = 1;
        result = 31 * result + (this.endpoint == null ? 0 : this.endpoint.hashCode());
        result = 31 * result + (this.service == null ? 0 : this.service.hashCode());
        return result;
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer();
        buffer.append("Service: ");
        buffer.append(this.service);
        buffer.append(", Port: ");
        buffer.append(this.endpoint);
        return buffer.toString();
    }
}

