/*
 * Decompiled with CFR 0.152.
 */
package org.opensaml.core.metrics;

import com.codahale.metrics.Metric;
import com.codahale.metrics.MetricFilter;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.shibboleth.shared.annotation.ParameterName;
import net.shibboleth.shared.annotation.constraint.NotEmpty;
import net.shibboleth.shared.collection.CollectionSupport;
import net.shibboleth.shared.logic.Constraint;
import net.shibboleth.shared.primitive.StringSupport;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LoggerDrivenMetricFilter
implements MetricFilter {
    @Nonnull
    @NotEmpty
    private final String loggerPrefix;
    @Nonnull
    private final Map<String, Level> levelMap;

    public LoggerDrivenMetricFilter(@Nonnull @ParameterName(name="prefix") @NotEmpty String prefix) {
        this(prefix, CollectionSupport.emptyMap());
    }

    public LoggerDrivenMetricFilter(@Nonnull @ParameterName(name="prefix") @NotEmpty String prefix, @Nullable @ParameterName(name="map") Map<String, Level> map) {
        this.loggerPrefix = Constraint.isNotNull(StringSupport.trimOrNull(prefix), "Prefix cannot be null or empty.");
        if (map == null || map.isEmpty()) {
            this.levelMap = CollectionSupport.emptyMap();
        } else {
            this.levelMap = new HashMap<String, Level>(map.size());
            for (Map.Entry<String, Level> entry : map.entrySet()) {
                String trimmed = StringSupport.trimOrNull(entry.getKey());
                if (trimmed == null || entry.getValue() == null) continue;
                this.levelMap.put(trimmed, entry.getValue());
            }
        }
    }

    public boolean matches(String name, Metric metric) {
        Logger logger = LoggerFactory.getLogger((String)(this.loggerPrefix + name));
        Level level = this.levelMap.get(logger.getName());
        if (level == null) {
            return logger.isInfoEnabled();
        }
        switch (level) {
            case TRACE: {
                return logger.isTraceEnabled();
            }
            case DEBUG: {
                return logger.isDebugEnabled();
            }
            case INFO: {
                return logger.isInfoEnabled();
            }
            case WARN: {
                return logger.isWarnEnabled();
            }
            case ERROR: {
                return logger.isErrorEnabled();
            }
        }
        return logger.isInfoEnabled();
    }

    public static enum Level {
        TRACE,
        DEBUG,
        INFO,
        WARN,
        ERROR;

    }
}

