/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.client.opensearch._types.aggregations;

import jakarta.json.stream.JsonGenerator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.opensearch.client.json.JsonpDeserializable;
import org.opensearch.client.json.JsonpDeserializer;
import org.opensearch.client.json.JsonpMapper;
import org.opensearch.client.json.ObjectBuilderDeserializer;
import org.opensearch.client.json.ObjectDeserializer;
import org.opensearch.client.opensearch._types.FieldValue;
import org.opensearch.client.opensearch._types.aggregations.Aggregation;
import org.opensearch.client.opensearch._types.aggregations.AggregationVariant;
import org.opensearch.client.opensearch._types.aggregations.BucketAggregationBase;
import org.opensearch.client.opensearch._types.aggregations.CompositeAggregationSource;
import org.opensearch.client.util.ApiTypeHelper;
import org.opensearch.client.util.CopyableBuilder;
import org.opensearch.client.util.ObjectBuilder;
import org.opensearch.client.util.ToCopyableBuilder;

@JsonpDeserializable
public class CompositeAggregation
extends BucketAggregationBase
implements AggregationVariant,
ToCopyableBuilder<Builder, CompositeAggregation> {
    @Nonnull
    private final Map<String, FieldValue> after;
    @Nullable
    private final Integer size;
    @Nonnull
    private final List<Map<String, CompositeAggregationSource>> sources;
    public static final JsonpDeserializer<CompositeAggregation> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, CompositeAggregation::setupCompositeAggregationDeserializer);

    private CompositeAggregation(Builder builder) {
        super(builder);
        this.after = ApiTypeHelper.unmodifiable(builder.after);
        this.size = builder.size;
        this.sources = ApiTypeHelper.unmodifiable(builder.sources);
    }

    public static CompositeAggregation of(Function<Builder, ObjectBuilder<CompositeAggregation>> fn) {
        return fn.apply(new Builder()).build();
    }

    @Override
    public Aggregation.Kind _aggregationKind() {
        return Aggregation.Kind.Composite;
    }

    @Nonnull
    public final Map<String, FieldValue> after() {
        return this.after;
    }

    @Nullable
    public final Integer size() {
        return this.size;
    }

    @Nonnull
    public final List<Map<String, CompositeAggregationSource>> sources() {
        return this.sources;
    }

    @Override
    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        super.serializeInternal(generator, mapper);
        if (ApiTypeHelper.isDefined(this.after)) {
            generator.writeKey("after");
            generator.writeStartObject();
            for (Map.Entry<String, FieldValue> entry : this.after.entrySet()) {
                generator.writeKey(entry.getKey());
                entry.getValue().serialize(generator, mapper);
            }
            generator.writeEnd();
        }
        if (this.size != null) {
            generator.writeKey("size");
            generator.write(this.size.intValue());
        }
        if (ApiTypeHelper.isDefined(this.sources)) {
            generator.writeKey("sources");
            generator.writeStartArray();
            for (Map map : this.sources) {
                generator.writeStartObject();
                if (map != null) {
                    for (Map.Entry item1 : map.entrySet()) {
                        generator.writeKey((String)item1.getKey());
                        ((CompositeAggregationSource)item1.getValue()).serialize(generator, mapper);
                    }
                }
                generator.writeEnd();
            }
            generator.writeEnd();
        }
    }

    @Override
    @Nonnull
    public Builder toBuilder() {
        return new Builder(this);
    }

    @Nonnull
    public static Builder builder() {
        return new Builder();
    }

    protected static void setupCompositeAggregationDeserializer(ObjectDeserializer<Builder> op) {
        CompositeAggregation.setupBucketAggregationBaseDeserializer(op);
        op.add(Builder::after, JsonpDeserializer.stringMapDeserializer(FieldValue._DESERIALIZER), "after");
        op.add(Builder::size, JsonpDeserializer.integerDeserializer(), "size");
        op.add(Builder::sources, JsonpDeserializer.arrayDeserializer(JsonpDeserializer.stringMapDeserializer(CompositeAggregationSource._DESERIALIZER)), "sources");
    }

    @Override
    public int hashCode() {
        int result = super.hashCode();
        result = 31 * result + Objects.hashCode(this.after);
        result = 31 * result + Objects.hashCode(this.size);
        result = 31 * result + Objects.hashCode(this.sources);
        return result;
    }

    @Override
    public boolean equals(Object o) {
        if (!super.equals(o)) {
            return false;
        }
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CompositeAggregation other = (CompositeAggregation)o;
        return Objects.equals(this.after, other.after) && Objects.equals(this.size, other.size) && Objects.equals(this.sources, other.sources);
    }

    public static class Builder
    extends BucketAggregationBase.AbstractBuilder<Builder>
    implements CopyableBuilder<Builder, CompositeAggregation> {
        @Nullable
        private Map<String, FieldValue> after;
        @Nullable
        private Integer size;
        @Nullable
        private List<Map<String, CompositeAggregationSource>> sources;

        public Builder() {
        }

        private Builder(CompositeAggregation o) {
            super(o);
            this.after = Builder._mapCopy(o.after);
            this.size = o.size;
            this.sources = Builder._listCopy(o.sources);
        }

        private Builder(Builder o) {
            super(o);
            this.after = Builder._mapCopy(o.after);
            this.size = o.size;
            this.sources = Builder._listCopy(o.sources);
        }

        @Override
        @Nonnull
        public Builder copy() {
            return new Builder(this);
        }

        @Override
        @Nonnull
        protected Builder self() {
            return this;
        }

        @Nonnull
        public final Builder after(Map<String, FieldValue> map) {
            this.after = Builder._mapPutAll(this.after, map);
            return this;
        }

        @Nonnull
        public final Builder after(String key, FieldValue value) {
            this.after = Builder._mapPut(this.after, key, value);
            return this;
        }

        @Nonnull
        public final Builder after(String key, Function<FieldValue.Builder, ObjectBuilder<FieldValue>> fn) {
            return this.after(key, fn.apply(new FieldValue.Builder()).build());
        }

        @Nonnull
        public final Builder size(@Nullable Integer value) {
            this.size = value;
            return this;
        }

        @Nonnull
        public final Builder sources(List<Map<String, CompositeAggregationSource>> list) {
            this.sources = Builder._listAddAll(this.sources, list);
            return this;
        }

        @Nonnull
        public final Builder sources(Map<String, CompositeAggregationSource> value, Map<String, CompositeAggregationSource> ... values) {
            this.sources = Builder._listAdd(this.sources, value, values);
            return this;
        }

        @Override
        @Nonnull
        public CompositeAggregation build() {
            this._checkSingleUse();
            return new CompositeAggregation(this);
        }
    }
}

