/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tika.parser.txt;

import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.tika.config.Field;
import org.apache.tika.detect.EncodingDetector;
import org.apache.tika.metadata.Metadata;
import org.apache.tika.mime.MediaType;
import org.apache.tika.parser.txt.CharsetDetector;
import org.apache.tika.parser.txt.CharsetMatch;
import org.apache.tika.utils.CharsetUtils;

public class Icu4jEncodingDetector
implements EncodingDetector {
    @Field
    private boolean stripMarkup = false;
    @Field
    private int markLimit = 12000;
    private Set<String> ignoreCharsets = new HashSet<String>();

    public Charset detect(InputStream input, Metadata metadata) throws IOException {
        String cleaned;
        MediaType mt;
        if (input == null) {
            return null;
        }
        CharsetDetector detector = new CharsetDetector(this.markLimit);
        String incomingCharset = metadata.get("Content-Encoding");
        String incomingType = metadata.get("Content-Type");
        if (incomingCharset == null && incomingType != null && (mt = MediaType.parse((String)incomingType)) != null) {
            incomingCharset = (String)mt.getParameters().get("charset");
        }
        if (incomingCharset != null && (cleaned = CharsetUtils.clean((String)incomingCharset)) != null) {
            detector.setDeclaredEncoding(cleaned);
        }
        detector.enableInputFilter(true);
        detector.setText(input);
        for (CharsetMatch match : detector.detectAll()) {
            try {
                String n = match.getNormalizedName();
                if (this.ignoreCharsets.contains(n)) continue;
                return CharsetUtils.forName((String)match.getNormalizedName());
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
        }
        return null;
    }

    public boolean isStripMarkup() {
        return this.stripMarkup;
    }

    @Field
    public void setStripMarkup(boolean stripMarkup) {
        this.stripMarkup = stripMarkup;
    }

    public int getMarkLimit() {
        return this.markLimit;
    }

    @Field
    public void setMarkLimit(int markLimit) {
        this.markLimit = markLimit;
    }

    public int getMarkLimt() {
        return this.markLimit;
    }

    @Field
    public void setIgnoreCharsets(List<String> charsetsToIgnore) {
        this.ignoreCharsets.addAll(charsetsToIgnore);
    }

    public List<String> getIgnoreCharsets() {
        ArrayList<String> ret = new ArrayList<String>(this.ignoreCharsets);
        Collections.sort(ret);
        return ret;
    }
}

