/*
 * Decompiled with CFR 0.152.
 */
package org.musicbrainz.search.index;

import com.google.common.base.Strings;
import java.io.IOException;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.document.Document;
import org.apache.lucene.index.IndexWriter;
import org.apache.lucene.search.similarities.Similarity;
import org.musicbrainz.mmd2.Alias;
import org.musicbrainz.mmd2.ObjectFactory;
import org.musicbrainz.mmd2.Series;
import org.musicbrainz.mmd2.Tag;
import org.musicbrainz.mmd2.TagList;
import org.musicbrainz.search.MbDocument;
import org.musicbrainz.search.analysis.MusicbrainzSimilarity;
import org.musicbrainz.search.helper.AliasHelper;
import org.musicbrainz.search.helper.TagHelper;
import org.musicbrainz.search.index.DatabaseIndex;
import org.musicbrainz.search.index.EventIndexField;
import org.musicbrainz.search.index.IndexField;
import org.musicbrainz.search.index.MMDSerializer;
import org.musicbrainz.search.index.SeriesIndexField;

public class SeriesIndex
extends DatabaseIndex {
    public static final String INDEX_NAME = "series";

    public SeriesIndex(Connection dbConnection) {
        super(dbConnection);
    }

    public SeriesIndex() {
    }

    @Override
    public String getName() {
        return INDEX_NAME;
    }

    @Override
    public Analyzer getAnalyzer() {
        return DatabaseIndex.getAnalyzer(SeriesIndexField.class);
    }

    @Override
    public IndexField getIdentifierField() {
        return SeriesIndexField.ID;
    }

    @Override
    public int getMaxId() throws SQLException {
        Statement st = this.dbConnection.createStatement();
        ResultSet rs = st.executeQuery("SELECT MAX(id) FROM series");
        rs.next();
        return rs.getInt(1);
    }

    @Override
    public int getNoOfRows(int maxId) throws SQLException {
        PreparedStatement st = this.dbConnection.prepareStatement("SELECT count(*) FROM series WHERE id <= ?");
        st.setInt(1, maxId);
        ResultSet rs = st.executeQuery();
        rs.next();
        return rs.getInt(1);
    }

    @Override
    public Similarity getSimilarity() {
        return new MusicbrainzSimilarity();
    }

    @Override
    public void init(IndexWriter indexWriter, boolean isUpdater) throws SQLException {
        this.addPreparedStatement("SERIES", "SELECT series.id, series.gid, series.name as name,  series_type.name as type,   series.comment,    lat.name as ordering_attribute FROM series   INNER JOIN link_attribute_type lat on series.ordering_attribute=lat.id  LEFT JOIN series_type ON series.type = series_type.id  WHERE series.id BETWEEN ? AND ?");
        this.addPreparedStatement("TAGS", TagHelper.constructTagQuery("series_tag", INDEX_NAME));
        this.addPreparedStatement("ALIASES", AliasHelper.constructAliasQuery(INDEX_NAME));
    }

    @Override
    public void indexData(IndexWriter indexWriter, int min, int max) throws SQLException, IOException {
        Map<Integer, Set<Alias>> aliases = AliasHelper.completeFromDbResults(min, max, this.getPreparedStatement("ALIASES"));
        Map<Integer, List<Tag>> tags = TagHelper.loadTags(min, max, this.getPreparedStatement("TAGS"), INDEX_NAME);
        PreparedStatement st = this.getPreparedStatement("SERIES");
        st.setInt(1, min);
        st.setInt(2, max);
        ResultSet rs = st.executeQuery();
        while (rs.next()) {
            indexWriter.addDocument(this.documentFromResultSet(rs, tags, aliases));
        }
        rs.close();
    }

    public Document documentFromResultSet(ResultSet rs, Map<Integer, List<Tag>> tags, Map<Integer, Set<Alias>> aliases) throws SQLException {
        MbDocument doc = new MbDocument();
        ObjectFactory of = new ObjectFactory();
        Series series = of.createSeries();
        int seriesId = rs.getInt("id");
        doc.addField((IndexField)SeriesIndexField.ID, seriesId);
        String seriesGuid = rs.getString("gid");
        doc.addField((IndexField)SeriesIndexField.SERIES_ID, seriesGuid);
        series.setId(seriesGuid);
        String name = rs.getString("name");
        doc.addField((IndexField)SeriesIndexField.SERIES, name);
        series.setName(name);
        String type = rs.getString("type");
        doc.addFieldOrUnknown(SeriesIndexField.TYPE, type);
        if (!Strings.isNullOrEmpty(type)) {
            series.setType(type);
        }
        String comment = rs.getString("comment");
        doc.addFieldOrNoValue(SeriesIndexField.COMMENT, comment);
        if (!Strings.isNullOrEmpty(comment)) {
            series.setDisambiguation(comment);
        }
        String orderAttr = rs.getString("ordering_attribute");
        doc.addFieldOrNoValue(SeriesIndexField.ORDERING_ATTRIBUTE, orderAttr);
        if (aliases.containsKey(seriesId)) {
            series.setAliasList(AliasHelper.addAliasesToDocAndConstructAliasList(of, doc, aliases, seriesId, EventIndexField.ALIAS));
        }
        if (tags.containsKey(seriesId)) {
            TagList tagList = TagHelper.addTagsToDocAndConstructTagList(of, doc, tags, seriesId, SeriesIndexField.TAG);
            series.setTagList(tagList);
        }
        String store = MMDSerializer.serialize(series);
        doc.addField((IndexField)SeriesIndexField.SERIES_STORE, store);
        return doc.getLuceneDocument();
    }
}

