/*
 * Decompiled with CFR 0.152.
 */
package org.musicbrainz.search.index;

import com.google.common.base.CharMatcher;
import com.google.common.base.Strings;
import java.util.Comparator;
import org.musicbrainz.mmd2.DefAreaElementInner;
import org.musicbrainz.mmd2.ReleaseEvent;

public class ReleaseEventComparator
implements Comparator<ReleaseEvent> {
    private static CharMatcher hyphenMatcher = CharMatcher.anyOf("-");

    @Override
    public int compare(ReleaseEvent releaseEvent1, ReleaseEvent releaseEvent2) {
        String date1 = this.padDate(Strings.nullToEmpty(releaseEvent1.getDate()));
        String date2 = this.padDate(Strings.nullToEmpty(releaseEvent2.getDate()));
        try {
            Integer date1Number = Integer.parseInt(date1);
            Integer date2Number = Integer.parseInt(date2);
            int result = date1Number.compareTo(date2Number);
            if (result != 0) {
                return result;
            }
            DefAreaElementInner a1 = releaseEvent1.getArea();
            DefAreaElementInner a2 = releaseEvent2.getArea();
            if (a1 != null && a2 != null) {
                return Strings.nullToEmpty(a1.getName()).compareTo(Strings.nullToEmpty(a2.getName()));
            }
            return 0;
        }
        catch (NumberFormatException nfe) {
            return 0;
        }
    }

    private String padDate(String origDate) {
        String date = hyphenMatcher.removeFrom(origDate);
        if (date.length() == 0) {
            return "99999999";
        }
        if (date.length() == 4) {
            return date + "0000";
        }
        if (date.length() == 6) {
            return date + "00";
        }
        return date;
    }
}

