/*
 * Decompiled with CFR 0.152.
 */
package org.musicbrainz.search.helper;

import com.google.common.base.Strings;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.musicbrainz.mmd2.DefAreaElementInner;
import org.musicbrainz.mmd2.Iso31661CodeList;
import org.musicbrainz.mmd2.ObjectFactory;
import org.musicbrainz.mmd2.ReleaseEvent;
import org.musicbrainz.search.index.Utils;

public class ReleaseEventHelper {
    public static Map<Integer, List<ReleaseEvent>> completeReleaseEventsFromDbResults(ResultSet rs, String entityKey) throws SQLException {
        HashMap<Integer, List<ReleaseEvent>> releaseEvents = new HashMap<Integer, List<ReleaseEvent>>();
        ObjectFactory of = new ObjectFactory();
        while (rs.next()) {
            String name;
            List<ReleaseEvent> releaseEventList;
            int entityId = rs.getInt(entityKey);
            if (!releaseEvents.containsKey(entityId)) {
                releaseEventList = new ArrayList();
                releaseEvents.put(entityId, releaseEventList);
            } else {
                releaseEventList = (List)releaseEvents.get(entityId);
            }
            String iso_code = rs.getString("country");
            String gid = rs.getString("gid");
            String sort_name = name = rs.getString("name");
            ReleaseEvent releaseEvent = of.createReleaseEvent();
            if (iso_code != null) {
                Iso31661CodeList isoList = of.createIso31661CodeList();
                isoList.getIso31661Code().add(iso_code);
                DefAreaElementInner area = of.createDefAreaElementInner();
                area.setIso31661CodeList(isoList);
                area.setId(gid);
                area.setName(name);
                area.setSortName(sort_name);
                releaseEvent.setArea(area);
            }
            releaseEvent.setDate(Strings.emptyToNull(Utils.formatDate(rs.getInt("date_year"), rs.getInt("date_month"), rs.getInt("date_day"))));
            releaseEventList.add(releaseEvent);
        }
        return releaseEvents;
    }
}

