/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.util.packed;

import java.io.IOException;
import java.util.Arrays;
import org.apache.lucene.store.DataOutput;
import org.apache.lucene.util.packed.PackedInts;

public final class BlockPackedWriter {
    static final int MAX_BLOCK_SIZE = 0x8000000;
    static final int MIN_VALUE_EQUALS_0 = 1;
    static final int BPV_SHIFT = 1;
    final DataOutput out;
    final long[] values;
    byte[] blocks;
    int off;
    long ord;
    boolean finished;

    static void checkBlockSize(int blockSize) {
        if (blockSize <= 0 || blockSize > 0x8000000) {
            throw new IllegalArgumentException("blockSize must be > 0 and < 134217728, got " + blockSize);
        }
        if (blockSize % 64 != 0) {
            throw new IllegalArgumentException("blockSize must be a multiple of 64, got " + blockSize);
        }
    }

    static long zigZagEncode(long n) {
        return n >> 63 ^ n << 1;
    }

    static void writeVLong(DataOutput out, long i) throws IOException {
        int k = 0;
        while ((i & 0xFFFFFFFFFFFFFF80L) != 0L && k++ < 8) {
            out.writeByte((byte)(i & 0x7FL | 0x80L));
            i >>>= 7;
        }
        out.writeByte((byte)i);
    }

    public BlockPackedWriter(DataOutput out, int blockSize) {
        BlockPackedWriter.checkBlockSize(blockSize);
        this.out = out;
        this.values = new long[blockSize];
        this.off = 0;
        this.ord = 0L;
        this.finished = false;
    }

    private void checkNotFinished() {
        if (this.finished) {
            throw new IllegalStateException("Already finished");
        }
    }

    public void add(long l) throws IOException {
        this.checkNotFinished();
        if (this.off == this.values.length) {
            this.flush();
        }
        this.values[this.off++] = l;
        ++this.ord;
    }

    public void finish() throws IOException {
        this.checkNotFinished();
        if (this.off > 0) {
            this.flush();
        }
        this.finished = true;
    }

    private void flush() throws IOException {
        int bitsRequired;
        assert (this.off > 0);
        long min = Long.MAX_VALUE;
        long max = Long.MIN_VALUE;
        for (int i = 0; i < this.off; ++i) {
            min = Math.min(this.values[i], min);
            max = Math.max(this.values[i], max);
        }
        long delta = max - min;
        int n = delta < 0L ? 64 : (bitsRequired = delta == 0L ? 0 : PackedInts.bitsRequired(delta));
        if (bitsRequired == 64) {
            min = 0L;
        } else if (min > 0L) {
            min = Math.max(0L, max - PackedInts.maxValue(bitsRequired));
        }
        int token = bitsRequired << 1 | (min == 0L ? 1 : 0);
        this.out.writeByte((byte)token);
        if (min != 0L) {
            BlockPackedWriter.writeVLong(this.out, BlockPackedWriter.zigZagEncode(min) - 1L);
        }
        if (bitsRequired > 0) {
            if (min != 0L) {
                int i = 0;
                while (i < this.off) {
                    int n2 = i++;
                    this.values[n2] = this.values[n2] - min;
                }
            }
            PackedInts.Encoder encoder = PackedInts.getEncoder(PackedInts.Format.PACKED, 1, bitsRequired);
            int iterations = this.values.length / encoder.valueCount();
            int blockSize = encoder.blockCount() * 8 * iterations;
            if (this.blocks == null || this.blocks.length < blockSize) {
                this.blocks = new byte[blockSize];
            }
            if (this.off < this.values.length) {
                Arrays.fill(this.values, this.off, this.values.length, 0L);
            }
            encoder.encode(this.values, 0, this.blocks, 0, iterations);
            int blockCount = (int)PackedInts.Format.PACKED.byteCount(1, this.off, bitsRequired);
            this.out.writeBytes(this.blocks, blockCount);
        }
        this.off = 0;
    }

    public long ord() {
        return this.ord;
    }
}

