/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.codecs.lucene40.values;

import java.io.IOException;
import org.apache.lucene.index.DocValues;
import org.apache.lucene.store.IndexInput;
import org.apache.lucene.util.BytesRef;

abstract class DirectSource
extends DocValues.Source {
    protected final IndexInput data;
    private final ToNumeric toNumeric;
    protected final long baseOffset;

    public DirectSource(IndexInput input, DocValues.Type type) {
        super(type);
        this.data = input;
        this.baseOffset = input.getFilePointer();
        switch (type) {
            case FIXED_INTS_16: {
                this.toNumeric = new ShortToLong();
                break;
            }
            case FLOAT_32: {
                this.toNumeric = new BytesToFloat();
                break;
            }
            case FLOAT_64: {
                this.toNumeric = new BytesToDouble();
                break;
            }
            case FIXED_INTS_32: {
                this.toNumeric = new IntToLong();
                break;
            }
            case FIXED_INTS_8: {
                this.toNumeric = new ByteToLong();
                break;
            }
            default: {
                this.toNumeric = new LongToLong();
            }
        }
    }

    @Override
    public BytesRef getBytes(int docID, BytesRef ref) {
        try {
            int sizeToRead = this.position(docID);
            ref.offset = 0;
            ref.grow(sizeToRead);
            this.data.readBytes(ref.bytes, 0, sizeToRead);
            ref.length = sizeToRead;
            return ref;
        }
        catch (IOException ex) {
            throw new IllegalStateException("failed to get value for docID: " + docID, ex);
        }
    }

    @Override
    public long getInt(int docID) {
        try {
            this.position(docID);
            return this.toNumeric.toLong(this.data);
        }
        catch (IOException ex) {
            throw new IllegalStateException("failed to get value for docID: " + docID, ex);
        }
    }

    @Override
    public double getFloat(int docID) {
        try {
            this.position(docID);
            return this.toNumeric.toDouble(this.data);
        }
        catch (IOException ex) {
            throw new IllegalStateException("failed to get value for docID: " + docID, ex);
        }
    }

    protected abstract int position(int var1) throws IOException;

    private static final class LongToLong
    extends ToNumeric {
        private LongToLong() {
        }

        @Override
        long toLong(IndexInput input) throws IOException {
            return input.readLong();
        }

        @Override
        double toDouble(IndexInput input) {
            throw new UnsupportedOperationException("doubles are not supported");
        }
    }

    private static final class BytesToDouble
    extends ToNumeric {
        private BytesToDouble() {
        }

        @Override
        long toLong(IndexInput input) {
            throw new UnsupportedOperationException("ints are not supported");
        }

        @Override
        double toDouble(IndexInput input) throws IOException {
            return Double.longBitsToDouble(input.readLong());
        }
    }

    private static final class BytesToFloat
    extends ToNumeric {
        private BytesToFloat() {
        }

        @Override
        long toLong(IndexInput input) {
            throw new UnsupportedOperationException("ints are not supported");
        }

        @Override
        double toDouble(IndexInput input) throws IOException {
            return Float.intBitsToFloat(input.readInt());
        }
    }

    private static final class IntToLong
    extends ToNumeric {
        private IntToLong() {
        }

        @Override
        long toLong(IndexInput input) throws IOException {
            return input.readInt();
        }
    }

    private static final class ShortToLong
    extends ToNumeric {
        private ShortToLong() {
        }

        @Override
        long toLong(IndexInput input) throws IOException {
            return input.readShort();
        }
    }

    private static final class ByteToLong
    extends ToNumeric {
        private ByteToLong() {
        }

        @Override
        long toLong(IndexInput input) throws IOException {
            return input.readByte();
        }
    }

    private static abstract class ToNumeric {
        private ToNumeric() {
        }

        abstract long toLong(IndexInput var1) throws IOException;

        double toDouble(IndexInput input) throws IOException {
            return this.toLong(input);
        }
    }
}

