/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.analysis.snowball;

import java.io.IOException;
import org.apache.lucene.analysis.TokenFilter;
import org.apache.lucene.analysis.TokenStream;
import org.apache.lucene.analysis.miscellaneous.KeywordMarkerFilter;
import org.apache.lucene.analysis.snowball.SnowballFilter;
import org.apache.lucene.analysis.util.CharArraySet;
import org.apache.lucene.analysis.util.ResourceLoader;
import org.apache.lucene.analysis.util.ResourceLoaderAware;
import org.apache.lucene.analysis.util.TokenFilterFactory;
import org.tartarus.snowball.SnowballProgram;

public class SnowballPorterFilterFactory
extends TokenFilterFactory
implements ResourceLoaderAware {
    public static final String PROTECTED_TOKENS = "protected";
    private String language = "English";
    private Class<? extends SnowballProgram> stemClass;
    private CharArraySet protectedWords = null;

    @Override
    public void inform(ResourceLoader loader) throws IOException {
        String cfgLanguage = (String)this.args.get("language");
        if (cfgLanguage != null) {
            this.language = cfgLanguage;
        }
        String className = "org.tartarus.snowball.ext." + this.language + "Stemmer";
        this.stemClass = loader.newInstance(className, SnowballProgram.class).getClass();
        String wordFiles = (String)this.args.get(PROTECTED_TOKENS);
        if (wordFiles != null) {
            this.protectedWords = this.getWordSet(loader, wordFiles, false);
        }
    }

    @Override
    public TokenFilter create(TokenStream input) {
        SnowballProgram program;
        try {
            program = this.stemClass.newInstance();
        }
        catch (Exception e) {
            throw new RuntimeException("Error instantiating stemmer for language " + this.language + "from class " + this.stemClass, e);
        }
        if (this.protectedWords != null) {
            input = new KeywordMarkerFilter(input, this.protectedWords);
        }
        return new SnowballFilter(input, program);
    }
}

