/*
 * Decompiled with CFR 0.152.
 */
package org.musicbrainz.search.index;

import java.io.IOException;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.document.Document;
import org.apache.lucene.index.IndexWriter;
import org.apache.lucene.index.IndexWriterConfig;
import org.apache.lucene.index.Term;
import org.apache.lucene.store.Directory;

public class ThreadedIndexWriter
extends IndexWriter {
    private ExecutorService threadPool;

    public ThreadedIndexWriter(Directory dir, IndexWriterConfig config, int numThreads, int maxQueueSize) throws IOException {
        super(dir, config);
        this.threadPool = new ThreadPoolExecutor(numThreads, numThreads, 0L, TimeUnit.SECONDS, new ArrayBlockingQueue<Runnable>(maxQueueSize, false), new ThreadPoolExecutor.CallerRunsPolicy());
    }

    public void addDocument(Document doc) {
        this.threadPool.execute(new Job(doc));
    }

    public void addDocument(Document doc, Analyzer a) {
        throw new UnsupportedOperationException();
    }

    public void updateDocument(Term term, Document doc) {
        throw new UnsupportedOperationException();
    }

    public void updateDocument(Term term, Document doc, Analyzer a) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void close() throws IOException {
        this.finish();
        super.close();
    }

    @Override
    public void rollback() throws IOException {
        this.finish();
        super.rollback();
    }

    private void finish() {
        this.threadPool.shutdown();
        try {
            while (!this.threadPool.awaitTermination(Long.MAX_VALUE, TimeUnit.SECONDS)) {
            }
        }
        catch (InterruptedException ie) {
            Thread.currentThread().interrupt();
            throw new RuntimeException(ie);
        }
    }

    private class Job
    implements Runnable {
        Document doc;

        public Job(Document doc) {
            this.doc = doc;
        }

        @Override
        public void run() {
            try {
                ThreadedIndexWriter.super.addDocument(this.doc);
            }
            catch (IOException ioe) {
                ioe.printStackTrace(System.err);
            }
        }
    }
}

