/*
 * Decompiled with CFR 0.152.
 */
package org.musicbrainz.search.analysis;

import java.io.IOException;
import org.apache.lucene.analysis.Tokenizer;
import org.apache.lucene.analysis.tokenattributes.CharTermAttribute;
import org.apache.lucene.analysis.tokenattributes.OffsetAttribute;
import org.apache.lucene.analysis.tokenattributes.PositionIncrementAttribute;
import org.apache.lucene.analysis.tokenattributes.TypeAttribute;
import org.apache.lucene.util.Version;
import org.musicbrainz.search.analysis.MusicbrainzTokenizerImpl;

public final class MusicbrainzTokenizer
extends Tokenizer {
    private final MusicbrainzTokenizerImpl scanner = new MusicbrainzTokenizerImpl(this.input);
    public static final int ALPHANUM = 0;
    public static final int APOSTROPHE = 1;
    public static final int ACRONYM = 2;
    public static final int CONTROLANDPUNCTUATION = 3;
    public static final int ALPHANUMANDPUNCTUATION = 4;
    public static final int HOST = 5;
    public static final int NUM = 6;
    public static final int CJ = 7;
    public static final String[] TOKEN_TYPES = new String[]{"<ALPHANUM>", "<APOSTROPHE>", "<ACRONYM>", "<CONTROLANDPUNCTUATION>", "<ALPHANUMANDPUNCTUATION>", "<HOST>", "<NUM>", "<CJ>"};
    private int maxTokenLength = 255;
    private CharTermAttribute termAtt;
    private OffsetAttribute offsetAtt;
    private PositionIncrementAttribute posIncrAtt;
    private TypeAttribute typeAtt;

    public void setMaxTokenLength(int length) {
        this.maxTokenLength = length;
    }

    public int getMaxTokenLength() {
        return this.maxTokenLength;
    }

    public MusicbrainzTokenizer(Version matchVersion) {
        this.init();
    }

    private void init() {
        this.termAtt = this.addAttribute(CharTermAttribute.class);
        this.offsetAtt = this.addAttribute(OffsetAttribute.class);
        this.posIncrAtt = this.addAttribute(PositionIncrementAttribute.class);
        this.typeAtt = this.addAttribute(TypeAttribute.class);
    }

    @Override
    public final boolean incrementToken() throws IOException {
        this.clearAttributes();
        int posIncr = 1;
        int tokenType;
        while ((tokenType = this.scanner.getNextToken()) != -1) {
            if (this.scanner.yylength() <= this.maxTokenLength) {
                this.posIncrAtt.setPositionIncrement(posIncr);
                this.scanner.getText(this.termAtt);
                int start = this.scanner.yychar();
                this.offsetAtt.setOffset(this.correctOffset(start), this.correctOffset(start + this.termAtt.length()));
                this.typeAtt.setType(MusicbrainzTokenizerImpl.TOKEN_TYPES[tokenType]);
                return true;
            }
            ++posIncr;
        }
        return false;
    }

    @Override
    public final void end() {
        int finalOffset = this.correctOffset(this.scanner.yychar() + this.scanner.yylength());
        this.offsetAtt.setOffset(finalOffset, finalOffset);
    }

    @Override
    public void reset() throws IOException {
        super.reset();
        this.scanner.yyreset(this.input);
    }
}

