/*
 * Decompiled with CFR 0.152.
 */
package org.musicbrainz.search.analysis;

import com.ibm.icu.text.Transliterator;
import java.io.Reader;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.analysis.TokenFilter;
import org.apache.lucene.analysis.charfilter.MappingCharFilter;
import org.apache.lucene.analysis.charfilter.NormalizeCharMap;
import org.apache.lucene.analysis.cjk.CJKBigramFilter;
import org.apache.lucene.analysis.icu.ICUTransformFilter;
import org.musicbrainz.search.LuceneVersion;
import org.musicbrainz.search.analysis.AmpersandToAndMappingHelper;
import org.musicbrainz.search.analysis.CharEquivToCharHelper;
import org.musicbrainz.search.analysis.HebrewCharMappingHelper;
import org.musicbrainz.search.analysis.LowercaseFilter;
import org.musicbrainz.search.analysis.MusicbrainzTokenizer;
import org.musicbrainz.search.analysis.MusicbrainzTokenizerFilter;
import org.musicbrainz.search.analysis.MusicbrainzWordDelimiterFilter;
import org.musicbrainz.search.analysis.WordDelimiterIterator;

public class MusicbrainzKeepAccentsAnalyzer
extends Analyzer {
    protected NormalizeCharMap charConvertMap;

    protected void setCharConvertMap() {
        NormalizeCharMap.Builder builder = new NormalizeCharMap.Builder();
        AmpersandToAndMappingHelper.addToMap(builder);
        CharEquivToCharHelper.addToMap(builder);
        HebrewCharMappingHelper.addToMap(builder);
        this.charConvertMap = builder.build();
    }

    public MusicbrainzKeepAccentsAnalyzer() {
        this.setCharConvertMap();
    }

    @Override
    protected Analyzer.TokenStreamComponents createComponents(String fieldName) {
        MusicbrainzTokenizer source = new MusicbrainzTokenizer(LuceneVersion.LUCENE_VERSION);
        TokenFilter filter = new ICUTransformFilter(source, Transliterator.getInstance("[\u30fc[:Script=Katakana:]]Katakana-Hiragana"));
        filter = new ICUTransformFilter(filter, Transliterator.getInstance("Traditional-Simplified"));
        filter = new MusicbrainzTokenizerFilter(filter);
        filter = new CJKBigramFilter(filter);
        filter = new LowercaseFilter(filter);
        filter = new MusicbrainzWordDelimiterFilter(filter, WordDelimiterIterator.DEFAULT_WORD_DELIM_TABLE, 1, 0, 0, 6, 0, 0, 0, 0, 0, null);
        return new Analyzer.TokenStreamComponents(source, filter);
    }

    @Override
    protected Reader initReader(String fieldName, Reader reader) {
        return new MappingCharFilter(this.charConvertMap, reader);
    }
}

