/*
 * Decompiled with CFR 0.152.
 */
package org.musicbrainz.search.index;

import com.google.common.base.Strings;
import java.io.IOException;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.document.Document;
import org.apache.lucene.index.IndexWriter;
import org.musicbrainz.mmd2.Alias;
import org.musicbrainz.mmd2.Coordinates;
import org.musicbrainz.mmd2.DefAreaElementInner;
import org.musicbrainz.mmd2.LifeSpan;
import org.musicbrainz.mmd2.ObjectFactory;
import org.musicbrainz.mmd2.Place;
import org.musicbrainz.mmd2.Tag;
import org.musicbrainz.search.MbDocument;
import org.musicbrainz.search.helper.AliasHelper;
import org.musicbrainz.search.helper.TagHelper;
import org.musicbrainz.search.index.ArtistIndexField;
import org.musicbrainz.search.index.DatabaseIndex;
import org.musicbrainz.search.index.IndexField;
import org.musicbrainz.search.index.MMDSerializer;
import org.musicbrainz.search.index.PlaceIndexField;
import org.musicbrainz.search.index.SeriesIndexField;
import org.musicbrainz.search.index.Utils;
import org.postgresql.geometric.PGpoint;

public class PlaceIndex
extends DatabaseIndex {
    public static final String INDEX_NAME = "place";
    public static boolean isUsingH2Db = false;

    public PlaceIndex(Connection dbConnection) {
        super(dbConnection);
    }

    public PlaceIndex() {
    }

    @Override
    public String getName() {
        return INDEX_NAME;
    }

    @Override
    public IndexField getIdentifierField() {
        return PlaceIndexField.ID;
    }

    @Override
    public Analyzer getAnalyzer() {
        return DatabaseIndex.getAnalyzer(PlaceIndexField.class);
    }

    @Override
    public int getMaxId() throws SQLException {
        Statement st = this.dbConnection.createStatement();
        ResultSet rs = st.executeQuery("SELECT MAX(id) FROM place");
        rs.next();
        return rs.getInt(1);
    }

    @Override
    public int getNoOfRows(int maxId) throws SQLException {
        Statement st = this.dbConnection.createStatement();
        ResultSet rs = st.executeQuery("SELECT count(*) FROM place WHERE id<=" + maxId);
        rs.next();
        return rs.getInt(1);
    }

    @Override
    public void init(IndexWriter indexWriter, boolean isUpdater) throws SQLException {
        this.addPreparedStatement("PLACE", "SELECT p.coordinates, p.id, p.gid, p.name, p.address, pt.name as type,   p.begin_date_year, p.begin_date_month, p.begin_date_day,   p.end_date_year, p.end_date_month, p.end_date_day, p.ended, p.comment,   a1.gid as area_gid, a1.name as area_name  FROM place p  LEFT JOIN place_type pt ON p.type = pt.id   LEFT JOIN area a1 on p.area = a1.id WHERE p.id BETWEEN ? AND ?  ORDER BY p.id");
        this.addPreparedStatement("ALIASES", AliasHelper.constructAliasQuery(INDEX_NAME));
        this.addPreparedStatement("TAGS", TagHelper.constructTagQuery("place_tag", INDEX_NAME));
    }

    @Override
    public void indexData(IndexWriter indexWriter, int min, int max) throws SQLException, IOException {
        Map<Integer, Set<Alias>> aliases = AliasHelper.completeFromDbResults(min, max, this.getPreparedStatement("ALIASES"));
        Map<Integer, List<Tag>> tags = TagHelper.loadTags(min, max, this.getPreparedStatement("TAGS"), INDEX_NAME);
        PreparedStatement st = this.getPreparedStatement("PLACE");
        st.setInt(1, min);
        st.setInt(2, max);
        ResultSet rs = st.executeQuery();
        while (rs.next()) {
            indexWriter.addDocument(this.documentFromResultSet(rs, tags, aliases));
        }
        rs.close();
    }

    public Document documentFromResultSet(ResultSet rs, Map<Integer, List<Tag>> tags, Map<Integer, Set<Alias>> aliases) throws SQLException {
        String areaId;
        String address;
        MbDocument doc = new MbDocument();
        ObjectFactory of = new ObjectFactory();
        Place place = of.createPlace();
        int placeId = rs.getInt("id");
        doc.addField((IndexField)PlaceIndexField.ID, placeId);
        String guid = rs.getString("gid");
        doc.addField((IndexField)PlaceIndexField.PLACE_ID, guid);
        place.setId(guid);
        String name = rs.getString("name");
        doc.addField((IndexField)PlaceIndexField.PLACE, name);
        place.setName(name);
        String comment = rs.getString("comment");
        if (!Strings.isNullOrEmpty(comment)) {
            doc.addField((IndexField)PlaceIndexField.COMMENT, comment);
            place.setDisambiguation(comment);
        }
        String type = rs.getString("type");
        doc.addFieldOrUnknown(PlaceIndexField.TYPE, type);
        if (!Strings.isNullOrEmpty(type)) {
            place.setType(type);
        }
        float latitude = 0.0f;
        float longitude = 0.0f;
        boolean isCoordinates = false;
        if (!isUsingH2Db) {
            PGpoint pgPoint = (PGpoint)rs.getObject("coordinates");
            if (pgPoint != null) {
                latitude = (float)pgPoint.x;
                longitude = (float)pgPoint.y;
                isCoordinates = true;
            }
        } else {
            Object[] coords = (Object[])rs.getObject("coordinates");
            if (coords != null) {
                latitude = Float.valueOf(coords[0].toString()).floatValue();
                longitude = Float.valueOf(coords[1].toString()).floatValue();
                isCoordinates = true;
            }
        }
        if (isCoordinates) {
            Coordinates coordinates = of.createCoordinates();
            coordinates.setLatitude(String.valueOf(latitude));
            coordinates.setLongitude(String.valueOf(longitude));
            place.setCoordinates(coordinates);
            doc.addNumericField((IndexField)PlaceIndexField.LAT, Float.valueOf(latitude));
            doc.addNumericField((IndexField)PlaceIndexField.LONG, Float.valueOf(longitude));
        }
        if (!Strings.isNullOrEmpty(address = rs.getString("address"))) {
            doc.addField((IndexField)PlaceIndexField.ADDRESS, address);
            place.setAddress(address);
        }
        if ((areaId = rs.getString("area_gid")) != null) {
            DefAreaElementInner area = of.createDefAreaElementInner();
            area.setId(areaId);
            String areaName = rs.getString("area_name");
            area.setName(areaName);
            doc.addFieldOrNoValue(ArtistIndexField.AREA, areaName);
            area.setSortName(areaName);
            place.setArea(area);
        } else {
            doc.addField((IndexField)ArtistIndexField.AREA, "-");
        }
        boolean ended = rs.getBoolean("ended");
        doc.addFieldOrUnknown(ArtistIndexField.ENDED, Boolean.toString(ended));
        String begin = Utils.formatDate(rs.getInt("begin_date_year"), rs.getInt("begin_date_month"), rs.getInt("begin_date_day"));
        doc.addNonEmptyField(ArtistIndexField.BEGIN, begin);
        String end = Utils.formatDate(rs.getInt("end_date_year"), rs.getInt("end_date_month"), rs.getInt("end_date_day"));
        doc.addNonEmptyField(ArtistIndexField.END, end);
        LifeSpan lifespan = of.createLifeSpan();
        place.setLifeSpan(lifespan);
        if (!Strings.isNullOrEmpty(begin)) {
            lifespan.setBegin(begin);
        }
        if (!Strings.isNullOrEmpty(end)) {
            lifespan.setEnd(end);
        }
        lifespan.setEnded(Boolean.toString(ended));
        if (aliases.containsKey(placeId)) {
            place.setAliasList(AliasHelper.addAliasesToDocAndConstructAliasList(of, doc, aliases, placeId, SeriesIndexField.ALIAS));
        }
        if (tags.containsKey(placeId)) {
            place.setTagList(TagHelper.addTagsToDocAndConstructTagList(of, doc, tags, placeId, PlaceIndexField.TAG));
        }
        String store = MMDSerializer.serialize(place);
        doc.addField((IndexField)PlaceIndexField.PLACE_STORE, store);
        return doc.getLuceneDocument();
    }
}

