/*
 * Decompiled with CFR 0.152.
 */
package org.musicbrainz.search.index;

import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.analysis.core.KeywordAnalyzer;
import org.apache.lucene.document.FieldType;
import org.musicbrainz.search.analysis.CaseInsensitiveKeywordAnalyzer;
import org.musicbrainz.search.analysis.MusicbrainzAnalyzer;
import org.musicbrainz.search.analysis.MusicbrainzWithPosGapAnalyzer;
import org.musicbrainz.search.index.IndexField;
import org.musicbrainz.search.index.MusicBrainzFieldTypes;

public enum SeriesIndexField implements IndexField
{
    ID("_id", MusicBrainzFieldTypes.TEXT_STORED_ANALYZED_NO_NORMS, new KeywordAnalyzer()),
    SERIES_ID("sid", MusicBrainzFieldTypes.TEXT_STORED_NOT_ANALYZED_NO_NORMS, new KeywordAnalyzer()),
    ALIAS("alias", MusicBrainzFieldTypes.TEXT_NOT_STORED_ANALYZED, new MusicbrainzWithPosGapAnalyzer()),
    SERIES("series", MusicBrainzFieldTypes.TEXT_STORED_ANALYZED, new MusicbrainzAnalyzer()),
    COMMENT("comment", MusicBrainzFieldTypes.TEXT_NOT_STORED_ANALYZED),
    ORDERING_ATTRIBUTE("orderingattribute", MusicBrainzFieldTypes.TEXT_NOT_STORED_ANALYZED, new CaseInsensitiveKeywordAnalyzer()),
    SERIES_STORE("seriesstore", MusicBrainzFieldTypes.TEXT_STORED_NOT_INDEXED),
    TYPE("type", MusicBrainzFieldTypes.TEXT_NOT_STORED_ANALYZED_NO_NORMS, new CaseInsensitiveKeywordAnalyzer());

    private String name;
    private Analyzer analyzer;
    private FieldType fieldType;

    private SeriesIndexField(String name, FieldType fieldType) {
        this.name = name;
        this.fieldType = fieldType;
    }

    private SeriesIndexField(String name, FieldType fieldType, Analyzer analyzer) {
        this(name, fieldType);
        this.analyzer = analyzer;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public Analyzer getAnalyzer() {
        return this.analyzer;
    }

    @Override
    public FieldType getFieldType() {
        return this.fieldType;
    }
}

