/*
 * Decompiled with CFR 0.152.
 */
package org.musicbrainz.search.index;

import com.google.common.base.Strings;
import java.io.IOException;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.document.Document;
import org.apache.lucene.index.IndexWriter;
import org.apache.lucene.search.similarities.Similarity;
import org.musicbrainz.mmd2.Alias;
import org.musicbrainz.mmd2.AliasList;
import org.musicbrainz.mmd2.ObjectFactory;
import org.musicbrainz.mmd2.Series;
import org.musicbrainz.search.MbDocument;
import org.musicbrainz.search.analysis.MusicbrainzSimilarity;
import org.musicbrainz.search.index.DatabaseIndex;
import org.musicbrainz.search.index.IndexField;
import org.musicbrainz.search.index.MMDSerializer;
import org.musicbrainz.search.index.SeriesIndexField;
import org.musicbrainz.search.index.Utils;

public class SeriesIndex
extends DatabaseIndex {
    public static final String INDEX_NAME = "series";

    public SeriesIndex(Connection dbConnection) {
        super(dbConnection);
    }

    public SeriesIndex() {
    }

    @Override
    public String getName() {
        return INDEX_NAME;
    }

    @Override
    public Analyzer getAnalyzer() {
        return DatabaseIndex.getAnalyzer(SeriesIndexField.class);
    }

    @Override
    public IndexField getIdentifierField() {
        return SeriesIndexField.ID;
    }

    @Override
    public int getMaxId() throws SQLException {
        Statement st = this.dbConnection.createStatement();
        ResultSet rs = st.executeQuery("SELECT MAX(id) FROM series");
        rs.next();
        return rs.getInt(1);
    }

    @Override
    public int getNoOfRows(int maxId) throws SQLException {
        PreparedStatement st = this.dbConnection.prepareStatement("SELECT count(*) FROM series WHERE id <= ?");
        st.setInt(1, maxId);
        ResultSet rs = st.executeQuery();
        rs.next();
        return rs.getInt(1);
    }

    @Override
    public Similarity getSimilarity() {
        return new MusicbrainzSimilarity();
    }

    @Override
    public void init(IndexWriter indexWriter, boolean isUpdater) throws SQLException {
        this.addPreparedStatement("ALIASES", "SELECT a.series as series, a.name as alias, a.sort_name as alias_sortname, a.primary_for_locale, a.locale, att.name as type,a.begin_date_year, a.begin_date_month, a.begin_date_day, a.end_date_year, a.end_date_month, a.end_date_day FROM series_alias a  LEFT JOIN series_alias_type att on (a.type=att.id) WHERE series BETWEEN ? AND ? ORDER BY series, alias, alias_sortname");
        this.addPreparedStatement("SERIES", "SELECT series.id, series.gid, series.name as name,  series_type.name as type,   series.comment,    lat.name as ordering_attribute FROM series   INNER JOIN link_attribute_type lat on series.ordering_attribute=lat.id  LEFT JOIN series_type ON series.type = series_type.id  WHERE series.id BETWEEN ? AND ?");
    }

    @Override
    public void indexData(IndexWriter indexWriter, int min, int max) throws SQLException, IOException {
        ObjectFactory of = new ObjectFactory();
        HashMap<Integer, Set<Alias>> aliases = new HashMap<Integer, Set<Alias>>();
        PreparedStatement st = this.getPreparedStatement("ALIASES");
        st.setInt(1, min);
        st.setInt(2, max);
        ResultSet rs = st.executeQuery();
        while (rs.next()) {
            String end;
            String begin;
            String type;
            String locale;
            Set<Alias> list;
            int artistId = rs.getInt(INDEX_NAME);
            if (!aliases.containsKey(artistId)) {
                list = new LinkedHashSet();
                aliases.put(artistId, list);
            } else {
                list = (Set)aliases.get(artistId);
            }
            Alias alias = of.createAlias();
            alias.setContent(rs.getString("alias"));
            alias.setSortName(rs.getString("alias_sortname"));
            boolean isPrimary = rs.getBoolean("primary_for_locale");
            if (isPrimary) {
                alias.setPrimary("primary");
            }
            if ((locale = rs.getString("locale")) != null) {
                alias.setLocale(locale);
            }
            if ((type = rs.getString("type")) != null) {
                alias.setType(type);
            }
            if (!Strings.isNullOrEmpty(begin = Utils.formatDate(rs.getInt("begin_date_year"), rs.getInt("begin_date_month"), rs.getInt("begin_date_day")))) {
                alias.setBeginDate(begin);
            }
            if (!Strings.isNullOrEmpty(end = Utils.formatDate(rs.getInt("end_date_year"), rs.getInt("end_date_month"), rs.getInt("end_date_day")))) {
                alias.setEndDate(end);
            }
            list.add(alias);
        }
        rs.close();
        st = this.getPreparedStatement("SERIES");
        st.setInt(1, min);
        st.setInt(2, max);
        rs = st.executeQuery();
        while (rs.next()) {
            indexWriter.addDocument(this.documentFromResultSet(rs, aliases));
        }
        rs.close();
    }

    public Document documentFromResultSet(ResultSet rs, Map<Integer, Set<Alias>> aliases) throws SQLException {
        MbDocument doc = new MbDocument();
        ObjectFactory of = new ObjectFactory();
        Series series = of.createSeries();
        int seriesId = rs.getInt("id");
        doc.addField((IndexField)SeriesIndexField.ID, seriesId);
        String seriesGuid = rs.getString("gid");
        doc.addField((IndexField)SeriesIndexField.SERIES_ID, seriesGuid);
        series.setId(seriesGuid);
        String name = rs.getString("name");
        doc.addField((IndexField)SeriesIndexField.SERIES, name);
        series.setName(name);
        String type = rs.getString("type");
        doc.addFieldOrUnknown(SeriesIndexField.TYPE, type);
        if (!Strings.isNullOrEmpty(type)) {
            series.setType(type);
        }
        String comment = rs.getString("comment");
        doc.addFieldOrNoValue(SeriesIndexField.COMMENT, comment);
        if (!Strings.isNullOrEmpty(comment)) {
            series.setDisambiguation(comment);
        }
        String orderAttr = rs.getString("ordering_attribute");
        doc.addFieldOrNoValue(SeriesIndexField.ORDERING_ATTRIBUTE, orderAttr);
        if (aliases.containsKey(seriesId)) {
            AliasList aliasList = of.createAliasList();
            for (Alias nextAlias : aliases.get(seriesId)) {
                doc.addField((IndexField)SeriesIndexField.ALIAS, nextAlias.getContent());
                if (!Strings.isNullOrEmpty(nextAlias.getSortName()) && !nextAlias.getSortName().equals(nextAlias.getContent())) {
                    doc.addField((IndexField)SeriesIndexField.ALIAS, nextAlias.getSortName());
                }
                aliasList.getAlias().add(nextAlias);
            }
            series.setAliasList(aliasList);
        }
        String store = MMDSerializer.serialize(series);
        doc.addField((IndexField)SeriesIndexField.SERIES_STORE, store);
        return doc.getLuceneDocument();
    }
}

