/*
 * Decompiled with CFR 0.152.
 */
package org.musicbrainz.search.index;

import java.io.IOException;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.EnumMap;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.document.Document;
import org.apache.lucene.index.IndexWriter;
import org.musicbrainz.search.MbDocument;
import org.musicbrainz.search.index.AnnotationIndexField;
import org.musicbrainz.search.index.AnnotationType;
import org.musicbrainz.search.index.DatabaseIndex;
import org.musicbrainz.search.index.IndexField;

public class AnnotationIndex
extends DatabaseIndex {
    public static final String INDEX_NAME = "annotation";
    protected EnumMap<AnnotationType, AnnotationTypeInfo> annotationTypeInfos;

    public AnnotationIndex(Connection dbConnection) {
        super(dbConnection);
    }

    public AnnotationIndex() {
    }

    @Override
    public String getName() {
        return INDEX_NAME;
    }

    @Override
    public Analyzer getAnalyzer() {
        return DatabaseIndex.getAnalyzer(AnnotationIndexField.class);
    }

    @Override
    public IndexField getIdentifierField() {
        return AnnotationIndexField.ID;
    }

    @Override
    public int getMaxId() throws SQLException {
        Statement st = this.dbConnection.createStatement();
        ResultSet rs = st.executeQuery("SELECT MAX(id) FROM annotation");
        rs.next();
        return rs.getInt(1);
    }

    @Override
    public void init(IndexWriter indexWriter, boolean isUpdater) throws SQLException {
        this.annotationTypeInfos = new EnumMap(AnnotationType.class);
        this.annotationTypeInfos.put(AnnotationType.ARTIST, new AnnotationTypeInfo("artist"));
        this.annotationTypeInfos.put(AnnotationType.LABEL, new AnnotationTypeInfo("label"));
        this.annotationTypeInfos.put(AnnotationType.RECORDING, new AnnotationTypeInfo("recording"));
        this.annotationTypeInfos.put(AnnotationType.RELEASE, new AnnotationTypeInfo("release"));
        this.annotationTypeInfos.put(AnnotationType.RELEASE_GROUP, new AnnotationTypeInfo("release_group"));
        this.annotationTypeInfos.put(AnnotationType.WORK, new AnnotationTypeInfo("work"));
        for (AnnotationType type : this.annotationTypeInfos.keySet()) {
            AnnotationTypeInfo info = this.annotationTypeInfos.get((Object)type);
            this.addPreparedStatement(type.getName(), "SELECT a.id, e.gid, a.text, e.name, e.comment  FROM annotation a   INNER JOIN " + info.entityDbName + "_annotation ea ON a.id=ea.annotation " + "  INNER JOIN (SELECT DISTINCT ea2." + info.entityDbName + " as id, max(created) as created_date " + "               FROM annotation a2 " + "                INNER JOIN " + info.entityDbName + "_annotation ea2 on a2.id=ea2.annotation GROUP BY ea2." + info.entityDbName + "              ) AS last_ann ON ea." + info.entityDbName + "=last_ann.id AND a.created=last_ann.created_date " + "  INNER JOIN " + info.entityDbName + " e ON ea." + info.entityDbName + "=e.id " + " WHERE a.id BETWEEN ? and ? AND length(a.text) > 0");
        }
    }

    @Override
    public int getNoOfRows(int maxId) throws SQLException {
        Statement st = this.dbConnection.createStatement();
        ResultSet rs = st.executeQuery("SELECT count(*) FROM annotation WHERE id<=" + maxId);
        rs.next();
        return rs.getInt(1);
    }

    @Override
    public void indexData(IndexWriter indexWriter, int min, int max) throws SQLException, IOException {
        for (AnnotationType type : this.annotationTypeInfos.keySet()) {
            this.indexAnnotation(indexWriter, type, min, max);
        }
    }

    protected void indexAnnotation(IndexWriter indexWriter, AnnotationType type, int min, int max) throws SQLException, IOException {
        PreparedStatement st = this.getPreparedStatement(type.getName());
        st.setInt(1, min);
        st.setInt(2, max);
        ResultSet rs = st.executeQuery();
        while (rs.next()) {
            indexWriter.addDocument(this.documentFromResultSet(rs, type));
        }
        rs.close();
    }

    public Document documentFromResultSet(ResultSet rs, AnnotationType type) throws SQLException {
        MbDocument doc = new MbDocument();
        doc.addField((IndexField)AnnotationIndexField.ID, rs.getString("id"));
        doc.addField((IndexField)AnnotationIndexField.ENTITY, rs.getString("gid"));
        doc.addField((IndexField)AnnotationIndexField.NAME, rs.getString("name"));
        doc.addField((IndexField)AnnotationIndexField.TYPE, type.getName());
        doc.addNonEmptyField(AnnotationIndexField.TEXT, rs.getString("text"));
        return doc.getLuceneDocument();
    }

    private class AnnotationTypeInfo {
        public String entityDbName;

        public AnnotationTypeInfo(String entityDbName) {
            this.entityDbName = entityDbName;
        }
    }
}

