/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.queryparser.analyzing;

import java.io.IOException;
import java.io.StringReader;
import java.util.ArrayList;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.analysis.TokenStream;
import org.apache.lucene.analysis.tokenattributes.CharTermAttribute;
import org.apache.lucene.queryparser.classic.ParseException;
import org.apache.lucene.queryparser.classic.QueryParser;
import org.apache.lucene.search.Query;
import org.apache.lucene.util.Version;

public class AnalyzingQueryParser
extends QueryParser {
    public AnalyzingQueryParser(Version matchVersion, String field, Analyzer analyzer) {
        super(matchVersion, field, analyzer);
        this.setAnalyzeRangeTerms(true);
    }

    @Override
    protected Query getWildcardQuery(String field, String termStr) throws ParseException {
        TokenStream source;
        ArrayList<String> tlist = new ArrayList<String>();
        ArrayList<String> wlist = new ArrayList<String>();
        boolean isWithinToken = !termStr.startsWith("?") && !termStr.startsWith("*");
        StringBuilder tmpBuffer = new StringBuilder();
        char[] chars = termStr.toCharArray();
        for (int i = 0; i < termStr.length(); ++i) {
            if (chars[i] == '?' || chars[i] == '*') {
                if (isWithinToken) {
                    tlist.add(tmpBuffer.toString());
                    tmpBuffer.setLength(0);
                }
                isWithinToken = false;
            } else {
                if (!isWithinToken) {
                    wlist.add(tmpBuffer.toString());
                    tmpBuffer.setLength(0);
                }
                isWithinToken = true;
            }
            tmpBuffer.append(chars[i]);
        }
        if (isWithinToken) {
            tlist.add(tmpBuffer.toString());
        } else {
            wlist.add(tmpBuffer.toString());
        }
        int countTokens = 0;
        try {
            source = this.getAnalyzer().tokenStream(field, new StringReader(termStr));
            source.reset();
        }
        catch (IOException e1) {
            throw new RuntimeException(e1);
        }
        CharTermAttribute termAtt = source.addAttribute(CharTermAttribute.class);
        while (true) {
            try {
                if (!source.incrementToken()) {
                }
            }
            catch (IOException e) {}
            break;
            String term = termAtt.toString();
            if ("".equals(term)) continue;
            try {
                tlist.set(countTokens++, term);
            }
            catch (IndexOutOfBoundsException ioobe) {
                countTokens = -1;
            }
        }
        try {
            source.end();
            source.close();
        }
        catch (IOException e) {
            // empty catch block
        }
        if (countTokens != tlist.size()) {
            throw new ParseException("Cannot build WildcardQuery with analyzer " + this.getAnalyzer().getClass() + " - tokens added or lost");
        }
        if (tlist.size() == 0) {
            return null;
        }
        if (tlist.size() == 1) {
            if (wlist != null && wlist.size() == 1) {
                return super.getWildcardQuery(field, (String)tlist.get(0) + ((String)wlist.get(0)).toString());
            }
            throw new IllegalArgumentException("getWildcardQuery called without wildcard");
        }
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < tlist.size(); ++i) {
            sb.append((String)tlist.get(i));
            if (wlist == null || wlist.size() <= i) continue;
            sb.append((String)wlist.get(i));
        }
        return super.getWildcardQuery(field, sb.toString());
    }

    @Override
    protected Query getPrefixQuery(String field, String termStr) throws ParseException {
        TokenStream source;
        ArrayList<String> tlist = new ArrayList<String>();
        try {
            source = this.getAnalyzer().tokenStream(field, new StringReader(termStr));
            source.reset();
        }
        catch (IOException e1) {
            throw new RuntimeException(e1);
        }
        CharTermAttribute termAtt = source.addAttribute(CharTermAttribute.class);
        while (true) {
            try {
                if (!source.incrementToken()) {
                }
            }
            catch (IOException e) {}
            break;
            tlist.add(termAtt.toString());
        }
        try {
            source.end();
            source.close();
        }
        catch (IOException e) {
            // empty catch block
        }
        if (tlist.size() == 1) {
            return super.getPrefixQuery(field, (String)tlist.get(0));
        }
        throw new ParseException("Cannot build PrefixQuery with analyzer " + this.getAnalyzer().getClass() + (tlist.size() > 1 ? " - token(s) added" : " - token consumed"));
    }

    @Override
    protected Query getFuzzyQuery(String field, String termStr, float minSimilarity) throws ParseException {
        TokenStream source = null;
        String nextToken = null;
        boolean multipleTokens = false;
        try {
            source = this.getAnalyzer().tokenStream(field, new StringReader(termStr));
            CharTermAttribute termAtt = source.addAttribute(CharTermAttribute.class);
            source.reset();
            if (source.incrementToken()) {
                nextToken = termAtt.toString();
            }
            multipleTokens = source.incrementToken();
        }
        catch (IOException e) {
            nextToken = null;
        }
        try {
            source.end();
            source.close();
        }
        catch (IOException e) {
            // empty catch block
        }
        if (multipleTokens) {
            throw new ParseException("Cannot build FuzzyQuery with analyzer " + this.getAnalyzer().getClass() + " - tokens were added");
        }
        return nextToken == null ? null : super.getFuzzyQuery(field, nextToken, minSimilarity);
    }
}

