/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.index;

import java.io.IOException;
import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import org.apache.lucene.index.AtomicReader;
import org.apache.lucene.index.AtomicReaderContext;
import org.apache.lucene.index.CompositeReader;
import org.apache.lucene.index.DocValues;
import org.apache.lucene.index.FieldInfo;
import org.apache.lucene.index.FieldInfos;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.MergeState;
import org.apache.lucene.index.ReaderUtil;
import org.apache.lucene.index.SortedBytesMergeUtils;
import org.apache.lucene.index.TypePromoter;
import org.apache.lucene.util.ArrayUtil;
import org.apache.lucene.util.BytesRef;
import org.apache.lucene.util.PagedBytes;
import org.apache.lucene.util.packed.PackedInts;

class MultiDocValues
extends DocValues {
    private static DocValuesPuller DEFAULT_PULLER = new DocValuesPuller();
    private static final DocValuesPuller NORMS_PULLER = new DocValuesPuller(){

        @Override
        public DocValues pull(AtomicReader reader, String field) throws IOException {
            return reader.normValues(field);
        }

        @Override
        public boolean stopLoadingOnNull(AtomicReader reader, String field) {
            FieldInfos fieldInfos = reader.getFieldInfos();
            FieldInfo fieldInfo = fieldInfos.fieldInfo(field);
            return fieldInfo != null && fieldInfo.omitsNorms();
        }
    };
    private DocValuesSlice[] slices;
    private int[] starts;
    private DocValues.Type type;
    private int valueSize;

    private MultiDocValues(DocValuesSlice[] slices, int[] starts, TypePromoter promotedType) {
        this.starts = starts;
        this.slices = slices;
        this.type = promotedType.type();
        this.valueSize = promotedType.getValueSize();
    }

    public static DocValues getDocValues(IndexReader r, String field) throws IOException {
        return MultiDocValues.getDocValues(r, field, DEFAULT_PULLER);
    }

    public static DocValues getNormDocValues(IndexReader r, String field) throws IOException {
        return MultiDocValues.getDocValues(r, field, NORMS_PULLER);
    }

    private static DocValues getDocValues(IndexReader reader, String field, DocValuesPuller puller) throws IOException {
        if (reader instanceof AtomicReader) {
            return puller.pull((AtomicReader)reader, field);
        }
        assert (reader instanceof CompositeReader);
        List<AtomicReaderContext> leaves = reader.leaves();
        switch (leaves.size()) {
            case 0: {
                return null;
            }
            case 1: {
                return MultiDocValues.getDocValues(leaves.get(0).reader(), field, puller);
            }
        }
        ArrayList<DocValuesSlice> slices = new ArrayList<DocValuesSlice>();
        TypePromoter promotedType = TypePromoter.getIdentityPromoter();
        for (AtomicReaderContext ctx : leaves) {
            AtomicReader r = ctx.reader();
            DocValues d = puller.pull(r, field);
            if (d != null) {
                TypePromoter incoming = TypePromoter.create(d.getType(), d.getValueSize());
                promotedType = promotedType.promote(incoming);
            } else if (puller.stopLoadingOnNull(r, field)) {
                return null;
            }
            slices.add(new DocValuesSlice(d, ctx.docBase, r.maxDoc()));
        }
        if (promotedType == TypePromoter.getIdentityPromoter()) {
            return null;
        }
        int[] starts = new int[slices.size()];
        block8: for (int i = 0; i < slices.size(); ++i) {
            DocValuesSlice slice = (DocValuesSlice)slices.get(i);
            starts[i] = slice.start;
            if (slice.docValues != null) continue;
            DocValues.Type promoted = promotedType.type();
            switch (promoted) {
                case BYTES_FIXED_DEREF: 
                case BYTES_FIXED_STRAIGHT: 
                case BYTES_FIXED_SORTED: {
                    assert (promotedType.getValueSize() >= 0);
                    slice.docValues = new EmptyFixedDocValues(slice.length, promoted, promotedType.getValueSize());
                    continue block8;
                }
                default: {
                    slice.docValues = new EmptyDocValues(slice.length, promoted);
                }
            }
        }
        return new MultiDocValues(slices.toArray(new DocValuesSlice[slices.size()]), starts, promotedType);
    }

    @Override
    protected DocValues.Source loadSource() throws IOException {
        return new MultiSource(this.slices, this.starts, false, this.type);
    }

    @Override
    public DocValues.Type getType() {
        return this.type;
    }

    @Override
    public int getValueSize() {
        return this.valueSize;
    }

    @Override
    protected DocValues.Source loadDirectSource() throws IOException {
        return new MultiSource(this.slices, this.starts, true, this.type);
    }

    private static class EmptyFixedSource
    extends EmptySource {
        private final int valueSize;
        private final byte[] valueArray;

        public EmptyFixedSource(DocValues.Type type, int valueSize) {
            super(type);
            this.valueSize = valueSize;
            this.valueArray = new byte[valueSize];
        }

        @Override
        public BytesRef getBytes(int docID, BytesRef ref) {
            ref.grow(this.valueSize);
            ref.length = this.valueSize;
            Arrays.fill(ref.bytes, ref.offset, ref.offset + this.valueSize, (byte)0);
            return ref;
        }

        @Override
        public double getFloat(int docID) {
            return 0.0;
        }

        @Override
        public long getInt(int docID) {
            return 0L;
        }

        @Override
        public BytesRef getByOrd(int ord, BytesRef bytesRef) {
            bytesRef.bytes = this.valueArray;
            bytesRef.length = this.valueSize;
            bytesRef.offset = 0;
            return bytesRef;
        }
    }

    private static class EmptySource
    extends DocValues.SortedSource {
        public EmptySource(DocValues.Type type) {
            super(type, BytesRef.getUTF8SortedAsUnicodeComparator());
        }

        @Override
        public BytesRef getBytes(int docID, BytesRef ref) {
            ref.length = 0;
            return ref;
        }

        @Override
        public double getFloat(int docID) {
            return 0.0;
        }

        @Override
        public long getInt(int docID) {
            return 0L;
        }

        @Override
        public DocValues.SortedSource asSortedSource() {
            if (this.getType() == DocValues.Type.BYTES_FIXED_SORTED || this.getType() == DocValues.Type.BYTES_VAR_SORTED) {
                // empty if block
            }
            return super.asSortedSource();
        }

        @Override
        public int ord(int docID) {
            return 0;
        }

        @Override
        public BytesRef getByOrd(int ord, BytesRef bytesRef) {
            bytesRef.length = 0;
            bytesRef.offset = 0;
            return bytesRef;
        }

        @Override
        public PackedInts.Reader getDocToOrd() {
            return null;
        }

        @Override
        public int getValueCount() {
            return 1;
        }
    }

    private static final class MultiSortedSource
    extends DocValues.SortedSource {
        private final PagedBytes.Reader data;
        private final int[] docToOrd;
        private final long[] ordToOffset;
        private int size;
        private int valueCount;

        public MultiSortedSource(DocValues.Type type, Comparator<BytesRef> comparator, PagedBytes pagedBytes, int size, int numValues, int[] docToOrd, long[] ordToOffset) {
            super(type, comparator);
            this.data = pagedBytes.freeze(true);
            this.size = size;
            this.valueCount = numValues;
            this.docToOrd = docToOrd;
            this.ordToOffset = ordToOffset;
        }

        @Override
        public int ord(int docID) {
            return this.docToOrd[docID];
        }

        @Override
        public BytesRef getByOrd(int ord, BytesRef bytesRef) {
            int size = this.size;
            long offset = ord * size;
            if (this.ordToOffset != null) {
                offset = this.ordToOffset[ord];
                size = (int)(this.ordToOffset[1 + ord] - offset);
            }
            assert (size >= 0);
            return this.data.fillSlice(bytesRef, offset, size);
        }

        @Override
        public PackedInts.Reader getDocToOrd() {
            return null;
        }

        @Override
        public int getValueCount() {
            return this.valueCount;
        }
    }

    private static final class RecordingBytesRefConsumer
    implements SortedBytesMergeUtils.BytesRefConsumer {
        private static final int PAGED_BYTES_BITS = 15;
        final PagedBytes pagedBytes = new PagedBytes(15);
        long[] ordToOffset;

        public RecordingBytesRefConsumer(DocValues.Type type) {
            this.ordToOffset = type == DocValues.Type.BYTES_VAR_SORTED ? new long[2] : null;
        }

        @Override
        public void consume(BytesRef ref, int ord, long offset) {
            this.pagedBytes.copy(ref);
            if (this.ordToOffset != null) {
                if (ord + 1 >= this.ordToOffset.length) {
                    this.ordToOffset = ArrayUtil.grow(this.ordToOffset, ord + 2);
                }
                this.ordToOffset[ord + 1] = offset;
            }
        }
    }

    private static class MultiSource
    extends DocValues.Source {
        private int numDocs = 0;
        private int start = 0;
        private DocValues.Source current;
        private final int[] starts;
        private final DocValuesSlice[] slices;
        private boolean direct;
        private Object cachedArray;

        public MultiSource(DocValuesSlice[] slices, int[] starts, boolean direct, DocValues.Type type) {
            super(type);
            this.slices = slices;
            this.starts = starts;
            assert (slices.length != 0);
            this.direct = direct;
        }

        @Override
        public long getInt(int docID) {
            int doc = this.ensureSource(docID);
            return this.current.getInt(doc);
        }

        private final int ensureSource(int docID) {
            if (docID >= this.start && docID < this.start + this.numDocs) {
                return docID - this.start;
            }
            int idx = ReaderUtil.subIndex(docID, this.starts);
            assert (idx >= 0 && idx < this.slices.length) : "idx was " + idx + " for doc id: " + docID + " slices : " + Arrays.toString(this.starts);
            assert (this.slices[idx] != null);
            try {
                this.current = this.direct ? this.slices[idx].docValues.getDirectSource() : this.slices[idx].docValues.getSource();
            }
            catch (IOException e) {
                throw new RuntimeException("load failed", e);
            }
            this.start = this.slices[idx].start;
            this.numDocs = this.slices[idx].length;
            return docID - this.start;
        }

        @Override
        public double getFloat(int docID) {
            int doc = this.ensureSource(docID);
            return this.current.getFloat(doc);
        }

        @Override
        public BytesRef getBytes(int docID, BytesRef bytesRef) {
            int doc = this.ensureSource(docID);
            return this.current.getBytes(doc, bytesRef);
        }

        @Override
        public DocValues.SortedSource asSortedSource() {
            try {
                if (this.type == DocValues.Type.BYTES_FIXED_SORTED || this.type == DocValues.Type.BYTES_VAR_SORTED) {
                    DocValues[] values = new DocValues[this.slices.length];
                    Comparator<BytesRef> comp = null;
                    for (int i = 0; i < values.length; ++i) {
                        values[i] = this.slices[i].docValues;
                        if (values[i] instanceof EmptyDocValues) continue;
                        Comparator<BytesRef> comparator = values[i].getDirectSource().asSortedSource().getComparator();
                        assert (comp == null || comp == comparator);
                        comp = comparator;
                    }
                    assert (comp != null);
                    int globalNumDocs = this.globalNumDocs();
                    SortedBytesMergeUtils.MergeContext ctx = SortedBytesMergeUtils.init(this.type, values, comp, globalNumDocs);
                    List<SortedBytesMergeUtils.SortedSourceSlice> slices = SortedBytesMergeUtils.buildSlices(this.docBases(), new MergeState.DocMap[values.length], values, ctx);
                    RecordingBytesRefConsumer consumer = new RecordingBytesRefConsumer(this.type);
                    int maxOrd = SortedBytesMergeUtils.mergeRecords(ctx, consumer, slices);
                    int[] docToOrd = new int[globalNumDocs];
                    for (SortedBytesMergeUtils.SortedSourceSlice slice : slices) {
                        slice.toAbsolutOrds(docToOrd);
                    }
                    return new MultiSortedSource(this.type, comp, consumer.pagedBytes, ctx.sizePerValues, maxOrd, docToOrd, consumer.ordToOffset);
                }
            }
            catch (IOException e) {
                throw new RuntimeException("load failed", e);
            }
            return super.asSortedSource();
        }

        private int globalNumDocs() {
            int docs = 0;
            for (int i = 0; i < this.slices.length; ++i) {
                docs += this.slices[i].length;
            }
            return docs;
        }

        private int[] docBases() {
            int[] docBases = new int[this.slices.length];
            for (int i = 0; i < this.slices.length; ++i) {
                docBases[i] = this.slices[i].start;
            }
            return docBases;
        }

        @Override
        public boolean hasArray() {
            boolean oneRealSource = false;
            for (DocValuesSlice slice : this.slices) {
                try {
                    DocValues.Source source = slice.docValues.getSource();
                    if (source instanceof EmptySource) continue;
                    oneRealSource = true;
                    if (source.hasArray()) continue;
                    return false;
                }
                catch (IOException e) {
                    throw new RuntimeException("load failed", e);
                }
            }
            return oneRealSource;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Object getArray() {
            if (!this.hasArray()) {
                return null;
            }
            try {
                Class<?> componentType = null;
                Object[] arrays = new Object[this.slices.length];
                int numDocs = 0;
                for (int i = 0; i < this.slices.length; ++i) {
                    DocValuesSlice slice = this.slices[i];
                    DocValues.Source source = slice.docValues.getSource();
                    Object array = null;
                    if (!(source instanceof EmptySource)) {
                        array = source.getArray();
                    }
                    numDocs += slice.length;
                    if (array != null) {
                        if (componentType == null) {
                            componentType = array.getClass().getComponentType();
                        }
                        assert (componentType == array.getClass().getComponentType());
                    }
                    arrays[i] = array;
                }
                assert (componentType != null);
                MultiSource multiSource = this;
                synchronized (multiSource) {
                    if (this.cachedArray != null) {
                        return this.cachedArray;
                    }
                    Object globalArray = Array.newInstance(componentType, numDocs);
                    for (int i = 0; i < this.slices.length; ++i) {
                        DocValuesSlice slice = this.slices[i];
                        if (arrays[i] == null) continue;
                        assert (slice.length == Array.getLength(arrays[i]));
                        System.arraycopy(arrays[i], 0, globalArray, slice.start, slice.length);
                    }
                    this.cachedArray = globalArray;
                    return this.cachedArray;
                }
            }
            catch (IOException e) {
                throw new RuntimeException("load failed", e);
            }
        }
    }

    public static class EmptyFixedDocValues
    extends DocValues {
        final int maxDoc;
        final DocValues.Source emptyFixedSource;
        final int valueSize;

        public EmptyFixedDocValues(int maxDoc, DocValues.Type type, int valueSize) {
            this.maxDoc = maxDoc;
            this.emptyFixedSource = new EmptyFixedSource(type, valueSize);
            this.valueSize = valueSize;
        }

        @Override
        protected DocValues.Source loadSource() throws IOException {
            return this.emptyFixedSource;
        }

        @Override
        public DocValues.Type getType() {
            return this.emptyFixedSource.getType();
        }

        @Override
        public int getValueSize() {
            return this.valueSize;
        }

        @Override
        protected DocValues.Source loadDirectSource() throws IOException {
            return this.emptyFixedSource;
        }
    }

    public static class EmptyDocValues
    extends DocValues {
        final int maxDoc;
        final DocValues.Source emptySource;

        public EmptyDocValues(int maxDoc, DocValues.Type type) {
            this.maxDoc = maxDoc;
            this.emptySource = new EmptySource(type);
        }

        @Override
        protected DocValues.Source loadSource() throws IOException {
            return this.emptySource;
        }

        @Override
        public DocValues.Type getType() {
            return this.emptySource.getType();
        }

        @Override
        protected DocValues.Source loadDirectSource() throws IOException {
            return this.emptySource;
        }
    }

    private static class DocValuesPuller {
        public DocValues pull(AtomicReader reader, String field) throws IOException {
            return reader.docValues(field);
        }

        public boolean stopLoadingOnNull(AtomicReader reader, String field) {
            return false;
        }
    }

    public static class DocValuesSlice {
        public static final DocValuesSlice[] EMPTY_ARRAY = new DocValuesSlice[0];
        final int start;
        final int length;
        DocValues docValues;

        public DocValuesSlice(DocValues docValues, int start, int length) {
            this.docValues = docValues;
            this.start = start;
            this.length = length;
        }
    }
}

