/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.index;

import java.io.IOException;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import org.apache.lucene.codecs.Codec;
import org.apache.lucene.codecs.DocValuesConsumer;
import org.apache.lucene.codecs.FieldInfosWriter;
import org.apache.lucene.codecs.PerDocConsumer;
import org.apache.lucene.index.DocConsumer;
import org.apache.lucene.index.DocFieldConsumer;
import org.apache.lucene.index.DocFieldConsumerPerField;
import org.apache.lucene.index.DocFieldProcessorPerField;
import org.apache.lucene.index.DocValues;
import org.apache.lucene.index.DocumentsWriterPerThread;
import org.apache.lucene.index.FieldInfo;
import org.apache.lucene.index.FieldInfos;
import org.apache.lucene.index.IndexableField;
import org.apache.lucene.index.PerDocWriteState;
import org.apache.lucene.index.SegmentWriteState;
import org.apache.lucene.index.StoredFieldsConsumer;
import org.apache.lucene.index.TypePromoter;
import org.apache.lucene.store.IOContext;
import org.apache.lucene.util.ArrayUtil;
import org.apache.lucene.util.IOUtils;

final class DocFieldProcessor
extends DocConsumer {
    final DocFieldConsumer consumer;
    final StoredFieldsConsumer fieldsWriter;
    final Codec codec;
    DocFieldProcessorPerField[] fields = new DocFieldProcessorPerField[1];
    int fieldCount;
    DocFieldProcessorPerField[] fieldHash = new DocFieldProcessorPerField[2];
    int hashMask = 1;
    int totalFieldCount;
    int fieldGen;
    final DocumentsWriterPerThread.DocState docState;
    private static final Comparator<DocFieldProcessorPerField> fieldsComp = new Comparator<DocFieldProcessorPerField>(){

        @Override
        public int compare(DocFieldProcessorPerField o1, DocFieldProcessorPerField o2) {
            return o1.fieldInfo.name.compareTo(o2.fieldInfo.name);
        }
    };
    private final Map<String, DocValuesConsumerHolder> docValues = new HashMap<String, DocValuesConsumerHolder>();
    private PerDocConsumer perDocConsumer;

    public DocFieldProcessor(DocumentsWriterPerThread docWriter, DocFieldConsumer consumer) {
        this.docState = docWriter.docState;
        this.codec = docWriter.codec;
        this.consumer = consumer;
        this.fieldsWriter = new StoredFieldsConsumer(docWriter);
    }

    @Override
    public void flush(SegmentWriteState state) throws IOException {
        HashMap<String, DocFieldConsumerPerField> childFields = new HashMap<String, DocFieldConsumerPerField>();
        Collection<DocFieldConsumerPerField> fields = this.fields();
        for (DocFieldConsumerPerField f : fields) {
            childFields.put(f.getFieldInfo().name, f);
        }
        this.fieldsWriter.flush(state);
        this.consumer.flush(childFields, state);
        for (DocValuesConsumerHolder consumer : this.docValues.values()) {
            consumer.docValuesConsumer.finish(state.segmentInfo.getDocCount());
        }
        IOUtils.close(this.perDocConsumer);
        FieldInfosWriter infosWriter = this.codec.fieldInfosFormat().getFieldInfosWriter();
        infosWriter.write(state.directory, state.segmentInfo.name, state.fieldInfos, IOContext.DEFAULT);
    }

    @Override
    public void abort() {
        Throwable th;
        block17: {
            block16: {
                block15: {
                    th = null;
                    for (DocFieldProcessorPerField field : this.fieldHash) {
                        while (field != null) {
                            DocFieldProcessorPerField next;
                            block14: {
                                next = field.next;
                                try {
                                    field.abort();
                                }
                                catch (Throwable t) {
                                    if (th != null) break block14;
                                    th = t;
                                }
                            }
                            field = next;
                        }
                    }
                    IOUtils.closeWhileHandlingException(this.perDocConsumer);
                    try {
                        this.fieldsWriter.abort();
                    }
                    catch (Throwable t) {
                        if (th != null) break block15;
                        th = t;
                    }
                }
                try {
                    this.consumer.abort();
                }
                catch (Throwable t) {
                    if (th != null) break block16;
                    th = t;
                }
            }
            try {
                if (this.perDocConsumer != null) {
                    this.perDocConsumer.abort();
                }
            }
            catch (Throwable t) {
                if (th != null) break block17;
                th = t;
            }
        }
        if (th != null) {
            if (th instanceof RuntimeException) {
                throw (RuntimeException)th;
            }
            if (th instanceof Error) {
                throw (Error)th;
            }
            throw new RuntimeException(th);
        }
    }

    @Override
    public boolean freeRAM() {
        return this.consumer.freeRAM();
    }

    public Collection<DocFieldConsumerPerField> fields() {
        HashSet<DocFieldConsumerPerField> fields = new HashSet<DocFieldConsumerPerField>();
        for (int i = 0; i < this.fieldHash.length; ++i) {
            DocFieldProcessorPerField field = this.fieldHash[i];
            while (field != null) {
                fields.add(field.consumer);
                field = field.next;
            }
        }
        assert (fields.size() == this.totalFieldCount);
        return fields;
    }

    @Override
    void doAfterFlush() {
        this.fieldHash = new DocFieldProcessorPerField[2];
        this.hashMask = 1;
        this.totalFieldCount = 0;
        this.perDocConsumer = null;
        this.docValues.clear();
    }

    private void rehash() {
        int newHashSize = this.fieldHash.length * 2;
        assert (newHashSize > this.fieldHash.length);
        DocFieldProcessorPerField[] newHashArray = new DocFieldProcessorPerField[newHashSize];
        int newHashMask = newHashSize - 1;
        for (int j = 0; j < this.fieldHash.length; ++j) {
            DocFieldProcessorPerField fp0 = this.fieldHash[j];
            while (fp0 != null) {
                int hashPos2 = fp0.fieldInfo.name.hashCode() & newHashMask;
                DocFieldProcessorPerField nextFP0 = fp0.next;
                fp0.next = newHashArray[hashPos2];
                newHashArray[hashPos2] = fp0;
                fp0 = nextFP0;
            }
        }
        this.fieldHash = newHashArray;
        this.hashMask = newHashMask;
    }

    @Override
    public void processDocument(FieldInfos.Builder fieldInfos) throws IOException {
        this.consumer.startDocument();
        this.fieldsWriter.startDocument();
        this.fieldCount = 0;
        int thisFieldGen = this.fieldGen++;
        for (IndexableField indexableField : this.docState.doc) {
            DocValues.Type dvType;
            String fieldName = indexableField.name();
            int hashPos = fieldName.hashCode() & this.hashMask;
            DocFieldProcessorPerField fp = this.fieldHash[hashPos];
            while (fp != null && !fp.fieldInfo.name.equals(fieldName)) {
                fp = fp.next;
            }
            if (fp == null) {
                FieldInfo fi = fieldInfos.addOrUpdate(fieldName, indexableField.fieldType());
                fp = new DocFieldProcessorPerField(this, fi);
                fp.next = this.fieldHash[hashPos];
                this.fieldHash[hashPos] = fp;
                ++this.totalFieldCount;
                if (this.totalFieldCount >= this.fieldHash.length / 2) {
                    this.rehash();
                }
            } else {
                fieldInfos.addOrUpdate(fp.fieldInfo.name, indexableField.fieldType());
            }
            if (thisFieldGen != fp.lastGen) {
                fp.fieldCount = 0;
                if (this.fieldCount == this.fields.length) {
                    int newSize = this.fields.length * 2;
                    DocFieldProcessorPerField[] newArray = new DocFieldProcessorPerField[newSize];
                    System.arraycopy(this.fields, 0, newArray, 0, this.fieldCount);
                    this.fields = newArray;
                }
                this.fields[this.fieldCount++] = fp;
                fp.lastGen = thisFieldGen;
            }
            fp.addField(indexableField);
            if (indexableField.fieldType().stored()) {
                this.fieldsWriter.addField(indexableField, fp.fieldInfo);
            }
            if ((dvType = indexableField.fieldType().docValueType()) == null) continue;
            DocValuesConsumerHolder docValuesConsumer = this.docValuesConsumer(dvType, this.docState, fp.fieldInfo);
            DocValuesConsumer consumer = docValuesConsumer.docValuesConsumer;
            if (docValuesConsumer.compatibility == null) {
                consumer.add(this.docState.docID, indexableField);
                docValuesConsumer.compatibility = new TypePromoter.TypeCompatibility(dvType, consumer.getValueSize());
                continue;
            }
            if (docValuesConsumer.compatibility.isCompatible(dvType, TypePromoter.getValueSize(dvType, indexableField.binaryValue()))) {
                consumer.add(this.docState.docID, indexableField);
                continue;
            }
            docValuesConsumer.compatibility.isCompatible(dvType, TypePromoter.getValueSize(dvType, indexableField.binaryValue()));
            TypePromoter.TypeCompatibility compatibility = docValuesConsumer.compatibility;
            throw new IllegalArgumentException("Incompatible DocValues type: " + dvType.name() + " size: " + TypePromoter.getValueSize(dvType, indexableField.binaryValue()) + " expected: " + " type: " + (Object)((Object)compatibility.getBaseType()) + " size: " + compatibility.getBaseSize());
        }
        ArrayUtil.quickSort(this.fields, 0, this.fieldCount, fieldsComp);
        for (int i = 0; i < this.fieldCount; ++i) {
            DocFieldProcessorPerField docFieldProcessorPerField = this.fields[i];
            docFieldProcessorPerField.consumer.processFields(docFieldProcessorPerField.fields, docFieldProcessorPerField.fieldCount);
        }
        if (this.docState.maxTermPrefix != null && this.docState.infoStream.isEnabled("IW")) {
            this.docState.infoStream.message("IW", "WARNING: document contains at least one immense term (whose UTF8 encoding is longer than the max length 32766), all of which were skipped.  Please correct the analyzer to not produce such terms.  The prefix of the first immense term is: '" + this.docState.maxTermPrefix + "...'");
            this.docState.maxTermPrefix = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    void finishDocument() throws IOException {
        try {
            this.fieldsWriter.finishDocument();
        }
        finally {
            this.consumer.finishDocument();
        }
    }

    DocValuesConsumerHolder docValuesConsumer(DocValues.Type valueType, DocumentsWriterPerThread.DocState docState, FieldInfo fieldInfo) throws IOException {
        DocValuesConsumerHolder docValuesConsumerAndDocID = this.docValues.get(fieldInfo.name);
        if (docValuesConsumerAndDocID != null) {
            if (docState.docID == docValuesConsumerAndDocID.docID) {
                throw new IllegalArgumentException("DocValuesField \"" + fieldInfo.name + "\" appears more than once in this document (only one value is allowed, per field)");
            }
            assert (docValuesConsumerAndDocID.docID < docState.docID);
            docValuesConsumerAndDocID.docID = docState.docID;
            return docValuesConsumerAndDocID;
        }
        if (this.perDocConsumer == null) {
            PerDocWriteState perDocWriteState = docState.docWriter.newPerDocWriteState("");
            this.perDocConsumer = docState.docWriter.codec.docValuesFormat().docsConsumer(perDocWriteState);
            if (this.perDocConsumer == null) {
                throw new IllegalStateException("codec=" + docState.docWriter.codec + " does not support docValues: from docValuesFormat().docsConsumer(...) returned null; field=" + fieldInfo.name);
            }
        }
        DocValuesConsumer docValuesConsumer = this.perDocConsumer.addValuesField(valueType, fieldInfo);
        assert (fieldInfo.getDocValuesType() == null || fieldInfo.getDocValuesType() == valueType);
        fieldInfo.setDocValuesType(valueType);
        docValuesConsumerAndDocID = new DocValuesConsumerHolder(docValuesConsumer);
        docValuesConsumerAndDocID.docID = docState.docID;
        this.docValues.put(fieldInfo.name, docValuesConsumerAndDocID);
        return docValuesConsumerAndDocID;
    }

    private static class DocValuesConsumerHolder {
        int docID;
        final DocValuesConsumer docValuesConsumer;
        TypePromoter.TypeCompatibility compatibility;

        public DocValuesConsumerHolder(DocValuesConsumer docValuesConsumer) {
            this.docValuesConsumer = docValuesConsumer;
        }
    }
}

