/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.codecs;

import java.io.IOException;
import java.util.Collections;
import java.util.EnumMap;
import java.util.Map;
import org.apache.lucene.index.DocValues;
import org.apache.lucene.store.IndexInput;
import org.apache.lucene.util.BytesRef;

public abstract class DocValuesArraySource
extends DocValues.Source {
    private static final Map<DocValues.Type, DocValuesArraySource> TEMPLATES;
    protected final int bytesPerValue;

    public static DocValuesArraySource forType(DocValues.Type type) {
        return TEMPLATES.get((Object)type);
    }

    DocValuesArraySource(int bytesPerValue, DocValues.Type type) {
        super(type);
        this.bytesPerValue = bytesPerValue;
    }

    @Override
    public abstract BytesRef getBytes(int var1, BytesRef var2);

    public abstract DocValuesArraySource newFromInput(IndexInput var1, int var2) throws IOException;

    public abstract DocValuesArraySource newFromArray(Object var1);

    @Override
    public final boolean hasArray() {
        return true;
    }

    public void toBytes(long value, BytesRef bytesRef) {
        DocValuesArraySource.copyLong(bytesRef, value);
    }

    public void toBytes(double value, BytesRef bytesRef) {
        DocValuesArraySource.copyLong(bytesRef, Double.doubleToRawLongBits(value));
    }

    public static void copyLong(BytesRef ref, long value) {
        if (ref.bytes.length < 8) {
            ref.bytes = new byte[8];
        }
        ref.offset = 0;
        DocValuesArraySource.copyInternal(ref, (int)(value >> 32), 0);
        DocValuesArraySource.copyInternal(ref, (int)value, 4);
        ref.length = 8;
    }

    public static void copyInt(BytesRef ref, int value) {
        if (ref.bytes.length < 4) {
            ref.bytes = new byte[4];
        }
        ref.offset = 0;
        DocValuesArraySource.copyInternal(ref, value, 0);
        ref.length = 4;
    }

    public static void copyShort(BytesRef ref, short value) {
        if (ref.bytes.length < 2) {
            ref.bytes = new byte[2];
        }
        ref.offset = 0;
        ref.bytes[ref.offset] = (byte)(value >> 8);
        ref.bytes[ref.offset + 1] = (byte)value;
        ref.length = 2;
    }

    private static void copyInternal(BytesRef ref, int value, int startOffset) {
        ref.bytes[startOffset] = (byte)(value >> 24);
        ref.bytes[startOffset + 1] = (byte)(value >> 16);
        ref.bytes[startOffset + 2] = (byte)(value >> 8);
        ref.bytes[startOffset + 3] = (byte)value;
    }

    public static short asShort(BytesRef b) {
        return (short)(0xFFFF & (b.bytes[b.offset] & 0xFF) << 8 | b.bytes[b.offset + 1] & 0xFF);
    }

    public static int asInt(BytesRef b) {
        return DocValuesArraySource.asIntInternal(b, b.offset);
    }

    public static long asLong(BytesRef b) {
        return (long)DocValuesArraySource.asIntInternal(b, b.offset) << 32 | (long)DocValuesArraySource.asIntInternal(b, b.offset + 4) & 0xFFFFFFFFL;
    }

    private static int asIntInternal(BytesRef b, int pos) {
        return (b.bytes[pos++] & 0xFF) << 24 | (b.bytes[pos++] & 0xFF) << 16 | (b.bytes[pos++] & 0xFF) << 8 | b.bytes[pos] & 0xFF;
    }

    static {
        EnumMap<DocValues.Type, DocValuesArraySource> templates = new EnumMap<DocValues.Type, DocValuesArraySource>(DocValues.Type.class);
        templates.put(DocValues.Type.FIXED_INTS_16, new ShortValues());
        templates.put(DocValues.Type.FIXED_INTS_32, new IntValues());
        templates.put(DocValues.Type.FIXED_INTS_64, new LongValues());
        templates.put(DocValues.Type.FIXED_INTS_8, new ByteValues());
        templates.put(DocValues.Type.FLOAT_32, new FloatValues());
        templates.put(DocValues.Type.FLOAT_64, new DoubleValues());
        TEMPLATES = Collections.unmodifiableMap(templates);
    }

    static final class DoubleValues
    extends DocValuesArraySource {
        private final double[] values;

        DoubleValues() {
            super(8, DocValues.Type.FLOAT_64);
            this.values = new double[0];
        }

        private DoubleValues(IndexInput input, int numDocs) throws IOException {
            super(8, DocValues.Type.FLOAT_64);
            this.values = new double[numDocs];
            for (int i = 0; i < this.values.length; ++i) {
                this.values[i] = Double.longBitsToDouble(input.readLong());
            }
        }

        private DoubleValues(double[] array) {
            super(8, DocValues.Type.FLOAT_64);
            this.values = array;
        }

        public double[] getArray() {
            return this.values;
        }

        @Override
        public double getFloat(int docID) {
            assert (docID >= 0 && docID < this.values.length);
            return this.values[docID];
        }

        @Override
        public DocValuesArraySource newFromInput(IndexInput input, int numDocs) throws IOException {
            return new DoubleValues(input, numDocs);
        }

        @Override
        public DocValuesArraySource newFromArray(Object array) {
            assert (array instanceof double[]);
            return new DoubleValues((double[])array);
        }

        @Override
        public BytesRef getBytes(int docID, BytesRef ref) {
            this.toBytes(this.getFloat(docID), ref);
            return ref;
        }
    }

    static final class FloatValues
    extends DocValuesArraySource {
        private final float[] values;

        FloatValues() {
            super(4, DocValues.Type.FLOAT_32);
            this.values = new float[0];
        }

        private FloatValues(IndexInput input, int numDocs) throws IOException {
            super(4, DocValues.Type.FLOAT_32);
            this.values = new float[numDocs];
            for (int i = 0; i < this.values.length; ++i) {
                this.values[i] = Float.intBitsToFloat(input.readInt());
            }
        }

        private FloatValues(float[] array) {
            super(4, DocValues.Type.FLOAT_32);
            this.values = array;
        }

        public float[] getArray() {
            return this.values;
        }

        @Override
        public double getFloat(int docID) {
            assert (docID >= 0 && docID < this.values.length);
            return this.values[docID];
        }

        @Override
        public void toBytes(double value, BytesRef bytesRef) {
            FloatValues.copyInt(bytesRef, Float.floatToRawIntBits((float)value));
        }

        @Override
        public DocValuesArraySource newFromInput(IndexInput input, int numDocs) throws IOException {
            return new FloatValues(input, numDocs);
        }

        @Override
        public DocValuesArraySource newFromArray(Object array) {
            assert (array instanceof float[]);
            return new FloatValues((float[])array);
        }

        @Override
        public BytesRef getBytes(int docID, BytesRef ref) {
            this.toBytes(this.getFloat(docID), ref);
            return ref;
        }
    }

    static final class LongValues
    extends DocValuesArraySource {
        private final long[] values;

        LongValues() {
            super(8, DocValues.Type.FIXED_INTS_64);
            this.values = new long[0];
        }

        private LongValues(IndexInput input, int numDocs) throws IOException {
            super(8, DocValues.Type.FIXED_INTS_64);
            this.values = new long[numDocs];
            for (int i = 0; i < this.values.length; ++i) {
                this.values[i] = input.readLong();
            }
        }

        private LongValues(long[] array) {
            super(8, DocValues.Type.FIXED_INTS_64);
            this.values = array;
        }

        public long[] getArray() {
            return this.values;
        }

        @Override
        public long getInt(int docID) {
            assert (docID >= 0 && docID < this.values.length);
            return this.values[docID];
        }

        @Override
        public DocValuesArraySource newFromInput(IndexInput input, int numDocs) throws IOException {
            return new LongValues(input, numDocs);
        }

        @Override
        public DocValuesArraySource newFromArray(Object array) {
            assert (array instanceof long[]);
            return new LongValues((long[])array);
        }

        @Override
        public BytesRef getBytes(int docID, BytesRef ref) {
            this.toBytes(this.getInt(docID), ref);
            return ref;
        }
    }

    static final class IntValues
    extends DocValuesArraySource {
        private final int[] values;

        IntValues() {
            super(4, DocValues.Type.FIXED_INTS_32);
            this.values = new int[0];
        }

        private IntValues(IndexInput input, int numDocs) throws IOException {
            super(4, DocValues.Type.FIXED_INTS_32);
            this.values = new int[numDocs];
            for (int i = 0; i < this.values.length; ++i) {
                this.values[i] = input.readInt();
            }
        }

        private IntValues(int[] array) {
            super(4, DocValues.Type.FIXED_INTS_32);
            this.values = array;
        }

        public int[] getArray() {
            return this.values;
        }

        @Override
        public double getFloat(int docID) {
            return this.getInt(docID);
        }

        @Override
        public long getInt(int docID) {
            assert (docID >= 0 && docID < this.values.length);
            return 0xFFFFFFFF & this.values[docID];
        }

        @Override
        public DocValuesArraySource newFromInput(IndexInput input, int numDocs) throws IOException {
            return new IntValues(input, numDocs);
        }

        @Override
        public void toBytes(long value, BytesRef bytesRef) {
            IntValues.copyInt(bytesRef, (int)(0xFFFFFFFFFFFFFFFFL & value));
        }

        @Override
        public DocValuesArraySource newFromArray(Object array) {
            assert (array instanceof int[]);
            return new IntValues((int[])array);
        }

        @Override
        public BytesRef getBytes(int docID, BytesRef ref) {
            this.toBytes(this.getInt(docID), ref);
            return ref;
        }
    }

    static final class ShortValues
    extends DocValuesArraySource {
        private final short[] values;

        ShortValues() {
            super(2, DocValues.Type.FIXED_INTS_16);
            this.values = new short[0];
        }

        private ShortValues(short[] array) {
            super(2, DocValues.Type.FIXED_INTS_16);
            this.values = array;
        }

        private ShortValues(IndexInput input, int numDocs) throws IOException {
            super(2, DocValues.Type.FIXED_INTS_16);
            this.values = new short[numDocs];
            for (int i = 0; i < this.values.length; ++i) {
                this.values[i] = input.readShort();
            }
        }

        public short[] getArray() {
            return this.values;
        }

        @Override
        public double getFloat(int docID) {
            return this.getInt(docID);
        }

        @Override
        public long getInt(int docID) {
            assert (docID >= 0 && docID < this.values.length);
            return this.values[docID];
        }

        @Override
        public DocValuesArraySource newFromInput(IndexInput input, int numDocs) throws IOException {
            return new ShortValues(input, numDocs);
        }

        @Override
        public void toBytes(long value, BytesRef bytesRef) {
            ShortValues.copyShort(bytesRef, (short)(0xFFFFL & value));
        }

        @Override
        public DocValuesArraySource newFromArray(Object array) {
            assert (array instanceof short[]);
            return new ShortValues((short[])array);
        }

        @Override
        public BytesRef getBytes(int docID, BytesRef ref) {
            this.toBytes(this.getInt(docID), ref);
            return ref;
        }
    }

    static final class ByteValues
    extends DocValuesArraySource {
        private final byte[] values;

        ByteValues() {
            super(1, DocValues.Type.FIXED_INTS_8);
            this.values = new byte[0];
        }

        private ByteValues(byte[] array) {
            super(1, DocValues.Type.FIXED_INTS_8);
            this.values = array;
        }

        private ByteValues(IndexInput input, int numDocs) throws IOException {
            super(1, DocValues.Type.FIXED_INTS_8);
            this.values = new byte[numDocs];
            input.readBytes(this.values, 0, this.values.length, false);
        }

        public byte[] getArray() {
            return this.values;
        }

        @Override
        public double getFloat(int docID) {
            return this.getInt(docID);
        }

        @Override
        public long getInt(int docID) {
            assert (docID >= 0 && docID < this.values.length);
            return this.values[docID];
        }

        @Override
        public DocValuesArraySource newFromInput(IndexInput input, int numDocs) throws IOException {
            return new ByteValues(input, numDocs);
        }

        @Override
        public DocValuesArraySource newFromArray(Object array) {
            assert (array instanceof byte[]);
            return new ByteValues((byte[])array);
        }

        @Override
        public void toBytes(long value, BytesRef bytesRef) {
            if (bytesRef.bytes.length == 0) {
                bytesRef.bytes = new byte[1];
            }
            bytesRef.bytes[0] = (byte)(0xFFL & value);
            bytesRef.offset = 0;
            bytesRef.length = 1;
        }

        @Override
        public BytesRef getBytes(int docID, BytesRef ref) {
            this.toBytes(this.getInt(docID), ref);
            return ref;
        }
    }
}

