/*
 * Decompiled with CFR 0.152.
 */
package org.musicbrainz.search.index;

import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.analysis.core.KeywordAnalyzer;
import org.apache.lucene.document.FieldType;
import org.musicbrainz.search.analysis.CaseInsensitiveKeywordAnalyzer;
import org.musicbrainz.search.analysis.MusicbrainzKeepAccentsAnalyzer;
import org.musicbrainz.search.analysis.MusicbrainzWithPosGapAnalyzer;
import org.musicbrainz.search.analysis.TitleAnalyzer;
import org.musicbrainz.search.analysis.TitleWithPosGapAnalyzer;
import org.musicbrainz.search.index.IndexField;
import org.musicbrainz.search.index.MusicBrainzFieldTypes;

public enum ReleaseGroupIndexField implements IndexField
{
    ID("_id", MusicBrainzFieldTypes.TEXT_STORED_NOT_ANALYZED_NO_NORMS, new KeywordAnalyzer()),
    ARTIST_ID("arid", MusicBrainzFieldTypes.TEXT_STORED_NOT_ANALYZED_NO_NORMS, new KeywordAnalyzer()),
    ARTIST("artist", MusicBrainzFieldTypes.TEXT_NOT_STORED_ANALYZED, new MusicbrainzWithPosGapAnalyzer()),
    ARTIST_CREDIT("artistcredit", MusicBrainzFieldTypes.TEXT_STORED_NOT_INDEXED),
    ARTIST_NAME("artistname", MusicBrainzFieldTypes.TEXT_NOT_STORED_ANALYZED, new MusicbrainzWithPosGapAnalyzer()),
    ARTIST_NAMECREDIT("creditname", MusicBrainzFieldTypes.TEXT_NOT_STORED_ANALYZED, new MusicbrainzWithPosGapAnalyzer()),
    COMMENT("comment", MusicBrainzFieldTypes.TEXT_STORED_ANALYZED),
    NUM_RELEASES("releases", MusicBrainzFieldTypes.TEXT_STORED_NOT_ANALYZED_NO_NORMS, new KeywordAnalyzer()),
    PRIMARY_TYPE("primarytype", MusicBrainzFieldTypes.TEXT_STORED_ANALYZED_NO_NORMS, new CaseInsensitiveKeywordAnalyzer()),
    RELEASE("release", MusicBrainzFieldTypes.TEXT_STORED_ANALYZED, new TitleWithPosGapAnalyzer()),
    RELEASE_ID("reid", MusicBrainzFieldTypes.TEXT_STORED_NOT_ANALYZED_NO_NORMS, new KeywordAnalyzer()),
    RELEASEGROUP_ID("rgid", MusicBrainzFieldTypes.TEXT_STORED_NOT_ANALYZED_NO_NORMS, new KeywordAnalyzer()),
    RELEASEGROUP("releasegroup", MusicBrainzFieldTypes.TEXT_STORED_ANALYZED, new TitleAnalyzer()),
    RELEASEGROUP_ACCENT("releasegroupaccent", MusicBrainzFieldTypes.TEXT_NOT_STORED_ANALYZED, new MusicbrainzKeepAccentsAnalyzer()),
    RELEASESTATUS("status", MusicBrainzFieldTypes.TEXT_STORED_ANALYZED_NO_NORMS, new CaseInsensitiveKeywordAnalyzer()),
    SECONDARY_TYPE("secondarytype", MusicBrainzFieldTypes.TEXT_STORED_ANALYZED_NO_NORMS, new CaseInsensitiveKeywordAnalyzer()),
    TAG("tag", MusicBrainzFieldTypes.TEXT_STORED_ANALYZED, new MusicbrainzWithPosGapAnalyzer()),
    TAGCOUNT("tagcount", MusicBrainzFieldTypes.TEXT_STORED_NOT_INDEXED),
    TYPE("type", MusicBrainzFieldTypes.TEXT_STORED_ANALYZED_NO_NORMS, new CaseInsensitiveKeywordAnalyzer());

    private String name;
    private Analyzer analyzer;
    private FieldType fieldType;

    private ReleaseGroupIndexField(String name, FieldType fieldType) {
        this.name = name;
        this.fieldType = fieldType;
    }

    private ReleaseGroupIndexField(String name, FieldType fieldType, Analyzer analyzer) {
        this(name, fieldType);
        this.analyzer = analyzer;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public Analyzer getAnalyzer() {
        return this.analyzer;
    }

    @Override
    public FieldType getFieldType() {
        return this.fieldType;
    }
}

