/*
 * Decompiled with CFR 0.152.
 */
package org.musicbrainz.search.index;

import java.util.HashSet;
import java.util.Set;
import org.apache.lucene.document.Document;
import org.apache.lucene.document.Field;
import org.apache.lucene.index.IndexableField;
import org.musicbrainz.search.MbDocument;
import org.musicbrainz.search.index.LabelIndexField;

public class LabelBoostDoc {
    private static float DOC_BOOST = 2.0f;
    private static Set<String> labelGuIdSet = new HashSet<String>();

    public static void boost(String labelGuid, MbDocument doc) {
        LabelBoostDoc.boost(labelGuid, doc.getLuceneDocument());
    }

    public static void boost(String labelGuid, Document doc) {
        if (labelGuIdSet.contains(labelGuid)) {
            for (IndexableField indexablefield : doc.getFields()) {
                if (!indexablefield.name().equals(LabelIndexField.ALIAS.getName())) continue;
                Field field = (Field)indexablefield;
                field.setBoost(DOC_BOOST);
                break;
            }
        }
    }

    static {
        labelGuIdSet.add("022fe361-596c-43a0-8e22-bad712bb9548");
        labelGuIdSet.add("29d7c88f-5200-4418-a683-5c94ea032e38");
        labelGuIdSet.add("590538e9-b183-4163-ab5a-171fb021ed12");
        labelGuIdSet.add("9e6b4d7f-4958-4db7-8504-d89e315836af");
        labelGuIdSet.add("f9ada3ae-3081-44df-8581-ca27a3462b68");
    }
}

